/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetEditor;
import org.eclipse.birt.report.designer.data.ui.property.AbstractDescriptionPropertyPage;
import org.eclipse.birt.report.designer.data.ui.util.DataSetExpressionProvider;
import org.eclipse.birt.report.designer.data.ui.util.Utility;
import org.eclipse.birt.report.designer.internal.ui.dialogs.PropertyHandleTableViewer;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.ExpressionCellEditor;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class DataSetComputedColumnsPage
extends AbstractDescriptionPropertyPage
implements ITableLabelProvider {
    private transient PropertyHandle computedColumns = null;
    private transient PropertyHandleTableViewer viewer = null;
    private transient ComputedColumn newColumn = null;
    private static final Image selectorImage = ReportPlatformUIImages.getImage("TableRowSelector");
    private static String[] dataTypes = new String[]{"any", "date-time", "decimal", "float", "integer", "string"};
    private static String[] dataTypeDisplayNames = new String[]{Messages.getString((String)"datatypes.any"), Messages.getString((String)"datatypes.dateTime"), Messages.getString((String)"datatypes.decimal"), Messages.getString((String)"datatypes.float"), Messages.getString((String)"datatypes.integer"), Messages.getString((String)"datatypes.string")};
    private static String COLUMN_NAME = "name";
    private static String EXPRESSION = "expression";
    private static String DATA_TYPE = "dataType";

    public Control createContents(Composite parent) {
        this.computedColumns = ((DataSetHandle)this.getContainer().getModel()).getPropertyHandle("computedColumns");
        this.viewer = new PropertyHandleTableViewer(parent, true, true, true);
        TableColumn column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(" ");
        column.setResizable(false);
        column.setWidth(19);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(Messages.getString((String)"dataset.editor.title.columnName"));
        column.setWidth(150);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(Messages.getString((String)"dataset.editor.title.dataType"));
        column.setWidth(200);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(Messages.getString((String)"dataset.editor.title.expression"));
        column.setWidth(200);
        this.viewer.getViewer().setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                ArrayList computedColumnsList = new ArrayList(10);
                Iterator iter = DataSetComputedColumnsPage.this.computedColumns.iterator();
                if (iter != null) {
                    while (iter.hasNext()) {
                        computedColumnsList.add(iter.next());
                    }
                }
                if (DataSetComputedColumnsPage.this.newColumn == null) {
                    DataSetComputedColumnsPage.this.newColumn = new ComputedColumn();
                }
                computedColumnsList.add(DataSetComputedColumnsPage.this.newColumn);
                return computedColumnsList.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.viewer.getViewer().setLabelProvider((IBaseLabelProvider)this);
        this.viewer.getViewer().setInput((Object)this.computedColumns);
        this.setupEditors();
        this.addListeners();
        return this.viewer.getControl();
    }

    public void pageActivated() {
        this.refreshColumnNames();
        this.getContainer().setMessage(Messages.getString((String)"dataset.editor.computedColumns"), 0);
        this.setPageProperties();
    }

    private void refreshColumnNames() {
        ((DataSetEditor)this.getContainer()).getCurrentItemModel(true, true);
    }

    private void setupEditors() {
        CellEditor[] editors = new CellEditor[4];
        editors[1] = new TextCellEditor((Composite)this.viewer.getViewer().getTable(), 0);
        editors[2] = new ComboBoxCellEditor((Composite)this.viewer.getViewer().getTable(), dataTypeDisplayNames, 8);
        ExpressionCellEditor editor = new ExpressionCellEditor((Composite)this.viewer.getViewer().getTable(), 0);
        DataSetExpressionProvider provider = new DataSetExpressionProvider((DesignElementHandle)this.getContainer().getModel());
        editor.setExpressionProvider(provider);
        editors[3] = editor;
        this.viewer.getViewer().setCellEditors(editors);
        this.viewer.getViewer().setColumnProperties(new String[]{"", COLUMN_NAME, DATA_TYPE, EXPRESSION});
        this.viewer.getViewer().setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return true;
            }

            public Object getValue(Object element, String property) {
                Object value = null;
                try {
                    value = (String)Utility.getProperty(element, property);
                }
                catch (Exception e) {
                    ExceptionHandler.handle(e);
                }
                if (property.equals(DATA_TYPE)) {
                    value = new Integer(DataSetComputedColumnsPage.this.getTypeIndex((String)value));
                }
                return value == null ? "" : value;
            }

            public void modify(Object element, String property, Object value) {
                if (value != null) {
                    int selectedType;
                    boolean validValue = true;
                    String finalValue = property.equals(DATA_TYPE) ? ((selectedType = ((Integer)value).intValue()) >= 0 ? DataSetComputedColumnsPage.this.getTypeString(selectedType) : null) : (String)value;
                    if (property.equals(COLUMN_NAME)) {
                        boolean bl = validValue = DataSetComputedColumnsPage.this.isUniqueColumnName(((TableItem)element).getData(), finalValue) && finalValue.trim().length() > 0;
                    }
                    if (validValue) {
                        ComputedColumn column;
                        try {
                            Utility.setProperty(((TableItem)element).getData(), property, finalValue);
                        }
                        catch (Exception e) {
                            ExceptionHandler.handle(e);
                        }
                        DataSetComputedColumnsPage.this.viewer.getViewer().update(((TableItem)element).getData(), null);
                        if (DataSetComputedColumnsPage.this.validateAllComputedColumns()) {
                            DataSetComputedColumnsPage.this.getContainer().setMessage(Messages.getString((String)"dataset.editor.computedColumns"), 0);
                        }
                        if (((TableItem)element).getData() instanceof ComputedColumn && ((column = (ComputedColumn)((TableItem)element).getData()).getName() != null && column.getName().trim().length() > 0 || column.getExpression() != null && column.getExpression().trim().length() > 0)) {
                            try {
                                DataSetComputedColumnsPage.this.computedColumns.addItem((IStructure)column);
                                DataSetComputedColumnsPage.this.newColumn = null;
                                DataSetComputedColumnsPage.this.viewer.getViewer().refresh();
                                DataSetComputedColumnsPage.this.validateAllComputedColumns();
                            }
                            catch (SemanticException e) {
                                if (column.getName() == null || column.getName().trim().length() == 0) {
                                    MessageDialog.openError(null, (String)Messages.getString((String)"dataset.editor.error.title"), (String)Messages.getString((String)"dataset.editor.error.missingComputedColumnName"));
                                    column.setExpression(null);
                                    DataSetComputedColumnsPage.this.viewer.getViewer().refresh();
                                }
                                ExceptionHandler.handle(e);
                            }
                        }
                    }
                }
            }
        });
    }

    private final String getTypeString(int index) {
        if (index > -1 && index < dataTypes.length) {
            return dataTypes[index];
        }
        return null;
    }

    private final int getTypeIndex(String dataTypeName) {
        for (int n = 0; n < dataTypes.length; ++n) {
            if (!dataTypes[n].equals(dataTypeName)) continue;
            return n;
        }
        return 0;
    }

    private final String getTypeDisplayName(String typeName) {
        for (int n = 0; n < dataTypes.length; ++n) {
            if (!dataTypes[n].equals(typeName)) continue;
            return dataTypeDisplayNames[n];
        }
        return dataTypeDisplayNames[0];
    }

    private void addListeners() {
        this.viewer.getViewer().getTable().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    DataSetComputedColumnsPage.this.removeSelectedItem();
                    DataSetComputedColumnsPage.this.setPageProperties();
                }
            }
        });
        this.viewer.getRemoveButton().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DataSetComputedColumnsPage.this.removeSelectedItem();
                DataSetComputedColumnsPage.this.setPageProperties();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.viewer.getRemoveMenuItem().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DataSetComputedColumnsPage.this.removeSelectedItem();
                DataSetComputedColumnsPage.this.setPageProperties();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.viewer.getRemoveAllMenuItem().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DataSetComputedColumnsPage.this.setPageProperties();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.viewer.getViewer().addSelectionChangedListener((ISelectionChangedListener)new ViewerSelectionListener());
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return selectorImage;
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String value = null;
        ComputedColumn computedColumn = null;
        computedColumn = element instanceof ComputedColumn ? (ComputedColumn)element : (ComputedColumn)((ComputedColumnHandle)element).getStructure();
        try {
            switch (columnIndex) {
                case 1: {
                    value = (String)Utility.getProperty(element, COLUMN_NAME);
                    break;
                }
                case 2: {
                    if (computedColumn == this.newColumn) break;
                    value = this.getTypeDisplayName((String)Utility.getProperty(element, DATA_TYPE));
                    break;
                }
                case 3: {
                    value = (String)Utility.getProperty(element, EXPRESSION);
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
        return value == null ? "" : value;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public String getPageDescription() {
        return Messages.getString((String)"DataSetComputedColumnsPage.description");
    }

    private final boolean isUniqueColumnName(Object computedColumn, String name) {
        ComputedColumn column = null;
        column = computedColumn instanceof ComputedColumnHandle ? (ComputedColumn)((ComputedColumnHandle)computedColumn).getStructure() : (ComputedColumn)computedColumn;
        Iterator iter = this.computedColumns.iterator();
        if (iter != null) {
            while (iter.hasNext()) {
                ComputedColumnHandle handle = (ComputedColumnHandle)iter.next();
                if (column == handle.getStructure() || !handle.getName().equals(name)) continue;
                this.getContainer().setMessage(Messages.getString((String)"DataSetComputedColumnsPage.duplicateName"), 3);
                return false;
            }
        }
        return true;
    }

    private void removeSelectedItem() {
        int count;
        int index = this.viewer.getViewer().getTable().getSelectionIndex();
        int n = count = this.computedColumns.getListValue() == null ? 0 : this.computedColumns.getListValue().size();
        if (index == count) {
            this.newColumn = null;
            this.viewer.getViewer().refresh();
        }
    }

    public boolean performCancel() {
        return super.performCancel();
    }

    public boolean performOk() {
        if (this.validateAllComputedColumns()) {
            return super.performOk();
        }
        return false;
    }

    private void setPageProperties() {
        boolean computedColumnsExist = false;
        computedColumnsExist = this.computedColumns != null && this.computedColumns.getListValue() != null && this.computedColumns.getListValue().size() > 0;
        this.viewer.getDownButton().setEnabled(computedColumnsExist);
        this.viewer.getUpButton().setEnabled(computedColumnsExist);
        this.viewer.getRemoveButton().setEnabled(computedColumnsExist);
        this.viewer.getRemoveMenuItem().setEnabled(computedColumnsExist);
        this.viewer.getRemoveAllMenuItem().setEnabled(computedColumnsExist);
        this.validateAllComputedColumns();
    }

    public String getToolTip() {
        return Messages.getString((String)"DataSetComputedColumnsPage.ComputedColumns.Tooltip");
    }

    public boolean canLeave() {
        return this.validateAllComputedColumns();
    }

    private boolean validateAllComputedColumns() {
        Iterator iter;
        if (this.computedColumns != null && (iter = this.computedColumns.iterator()) != null) {
            while (iter.hasNext()) {
                Object o = iter.next();
                ComputedColumn computedColumn = null;
                computedColumn = o instanceof ComputedColumnHandle ? (ComputedColumn)((ComputedColumnHandle)o).getStructure() : (ComputedColumn)o;
                if (this.validateSingleColumn(computedColumn)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean validateSingleColumn(ComputedColumn computedColumn) {
        if (computedColumn.getName() == null || computedColumn.getName().trim().length() == 0) {
            this.getContainer().setMessage(Messages.getFormattedString((String)"dataset.editor.error.missingComputedColumnName", (Object[])new Object[]{computedColumn.getName()}), 3);
            return false;
        }
        if (computedColumn.getExpression() == null || computedColumn.getExpression().trim().length() == 0) {
            this.getContainer().setMessage(Messages.getFormattedString((String)"dataset.editor.error.missingComputedColumnExpression", (Object[])new Object[]{computedColumn.getName()}), 3);
            return false;
        }
        return true;
    }

    private class ViewerSelectionListener
    implements ISelectionChangedListener {
        private ViewerSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            DataSetComputedColumnsPage.this.setPageProperties();
        }
    }
}

