/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import java.util.Iterator;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.model.api.CachedMetaDataHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;

public final class DataSetUIUtil {
    private static Logger logger = Logger.getLogger(DataSetUIUtil.class.getName());

    public static void updateColumnCache(DataSetHandle dataSetHandle) throws SemanticException {
        DataSessionContext context = null;
        try {
            context = new DataSessionContext(3, dataSetHandle.getRoot(), null);
            DataRequestSession drSession = DataRequestSession.newSession((DataSessionContext)context);
            drSession.refreshMetaData(dataSetHandle);
        }
        catch (BirtException e) {
            logger.entering(DataSetUIUtil.class.getName(), "updateColumnCache", new Object[]{e});
        }
    }

    public static CachedMetaDataHandle getCachedMetaDataHandle(DataSetHandle dataSetHandle) throws SemanticException {
        if (dataSetHandle.getCachedMetaDataHandle() == null) {
            DataSetUIUtil.updateColumnCache(dataSetHandle);
        }
        return dataSetHandle.getCachedMetaDataHandle();
    }

    public static boolean hasMetaData(DataSetHandle dataSetHandle) {
        CachedMetaDataHandle metaData = dataSetHandle.getCachedMetaDataHandle();
        if (metaData == null) {
            return false;
        }
        Iterator iter = metaData.getResultSet().iterator();
        return iter.hasNext();
    }

    private static String toModelDataType(int modelDataType) {
        if (modelDataType == 2) {
            return "integer";
        }
        if (modelDataType == 5) {
            return "string";
        }
        if (modelDataType == 6) {
            return "date-time";
        }
        if (modelDataType == 4) {
            return "decimal";
        }
        if (modelDataType == 3) {
            return "float";
        }
        return "any";
    }
}

