/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import org.eclipse.birt.report.designer.data.ui.dataset.ColumnDefPage;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetBasePage;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetUIUtil;
import org.eclipse.birt.report.designer.data.ui.util.Utility;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ScriptDataSetHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.SWTException;

public class DefaultDataSetWizard
extends Wizard {
    private static final String CREATE_DATA_SET_TRANS_NAME = Messages.getString((String)"AbstractDataSetWizard.ModelTrans.Create");
    private transient boolean useTransaction = true;
    private DataSetBasePage dataSetPage;
    private ColumnDefPage columnDefPage;

    public DefaultDataSetWizard() {
        this(null, true);
    }

    public DefaultDataSetWizard(DataSourceHandle dataSourceHandle, boolean useTransaction) {
        this.useTransaction = useTransaction;
        this.dataSetPage = new DataSetBasePage(useTransaction);
        this.dataSetPage.setNewDataSource(dataSourceHandle);
        this.setForcePreviousAndNextButtons(true);
        this.addPage((IWizardPage)this.dataSetPage);
        this.columnDefPage = new ColumnDefPage();
        this.addPage((IWizardPage)this.columnDefPage);
    }

    public boolean performFinish() {
        DataSetHandle dataSetHandle;
        if (!this.canFinish()) {
            return false;
        }
        if (this.useTransaction) {
            Utility.getCommandStack().startTrans(CREATE_DATA_SET_TRANS_NAME);
        }
        if ((dataSetHandle = this.dataSetPage.createSelectedDataSet()) != null) {
            if (dataSetHandle instanceof ScriptDataSetHandle) {
                this.columnDefPage.saveResult(dataSetHandle);
            }
            if (this.useTransaction) {
                Utility.getCommandStack().commit();
            }
            try {
                this.createSelectedDataSetTearDown(dataSetHandle);
                DataSetUIUtil.updateColumnCache(dataSetHandle);
            }
            catch (Exception e) {
                if (e instanceof SWTException) {
                    SWTException swtException = (SWTException)e;
                    if (swtException.code == 24) {
                        Utility.log(e);
                    }
                }
                ExceptionHandler.handle(e);
            }
        } else {
            if (this.useTransaction) {
                Utility.getCommandStack().rollback();
            }
            return false;
        }
        return true;
    }

    private void createSelectedDataSetTearDown(DataSetHandle dataSetHandle) throws ContentException, NameException {
        ModuleHandle parentHandle = Utility.getReportModuleHandle();
        SlotHandle slotHandle = parentHandle.getDataSets();
        slotHandle.add((DesignElementHandle)dataSetHandle);
        if (dataSetHandle instanceof ScriptDataSetHandle) {
            Utility.setScriptActivityEditor();
        }
    }

    public boolean canFinish() {
        return this.dataSetPage.isPageComplete() && this.columnDefPage.isPageComplete();
    }
}

