/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.BaseQueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.report.designer.data.ui.dataset.PopupSelectionList;
import org.eclipse.birt.report.designer.data.ui.util.DataSetProvider;
import org.eclipse.birt.report.designer.data.ui.util.ExpressionUtility;
import org.eclipse.birt.report.designer.internal.ui.dialogs.ExpressionFilter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.SelectValueDialog;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ExpressionValueCellEditor
extends CellEditor {
    private static String[] actions = new String[]{Messages.getString((String)"ExpressionValueCellEditor.selectValueAction"), Messages.getString((String)"ExpressionValueCellEditor.buildExpressionAction")};
    private transient ParamBindingHandle[] bindingParams = null;
    private transient String selectValueExpression;
    private transient Text expressionText;
    private transient Button btnPopup;
    private transient ReportElementHandle currentItem = null;
    private transient String[] popupItems = null;
    private transient boolean refreshItems = true;
    private boolean useDataSetFilter = true;
    private static String[] EMPTY_ARRAY = new String[0];
    private IExpressionProvider provider;

    public ExpressionValueCellEditor() {
    }

    public ExpressionValueCellEditor(Composite parent) {
        super(parent);
    }

    public ExpressionValueCellEditor(Composite parent, boolean useDataSetFilter) {
        super(parent);
        this.useDataSetFilter = useDataSetFilter;
    }

    public ExpressionValueCellEditor(Composite parent, int style) {
        super(parent, style);
    }

    protected Control createControl(Composite parent) {
        Composite editorComposite = new Composite(parent, this.getStyle());
        editorComposite.setLayout((Layout)new ExpressionCellLayout());
        this.expressionText = new Text(editorComposite, 0);
        this.expressionText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                ExpressionValueCellEditor.this.keyReleaseOccured(e);
            }
        });
        this.expressionText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.expressionText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.expressionText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ExpressionValueCellEditor.this.focusLost();
            }
        });
        this.btnPopup = new Button(editorComposite, 1028);
        this.btnPopup.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExpressionValueCellEditor.this.refreshList();
                Rectangle textBounds = ExpressionValueCellEditor.this.expressionText.getBounds();
                Point pt = ExpressionValueCellEditor.this.expressionText.toDisplay(textBounds.x, textBounds.y);
                Rectangle rect = new Rectangle(pt.x, pt.y, ((ExpressionValueCellEditor)ExpressionValueCellEditor.this).expressionText.getParent().getBounds().width, textBounds.height);
                PopupSelectionList popup = new PopupSelectionList(ExpressionValueCellEditor.this.expressionText.getParent().getShell());
                popup.setItems(ExpressionValueCellEditor.this.popupItems);
                String value = popup.open(rect);
                int selectionIndex = popup.getSelectionIndex();
                if (value != null) {
                    String newValue = null;
                    if (value.equals(actions[0])) {
                        if (ExpressionUtility.isColumnExpression(ExpressionValueCellEditor.this.selectValueExpression)) {
                            try {
                                List selectValueList = ExpressionValueCellEditor.this.getSelectValueList();
                                SelectValueDialog dialog = new SelectValueDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.getString((String)"ExpressionValueCellEditor.title"));
                                dialog.setSelectedValueList(selectValueList);
                                if (ExpressionValueCellEditor.this.bindingParams != null) {
                                    dialog.setBindingParams(ExpressionValueCellEditor.this.bindingParams);
                                }
                                if (dialog.open() == 0) {
                                    newValue = dialog.getSelectedExprValue();
                                }
                            }
                            catch (Exception ex) {
                                MessageDialog.openError(null, (String)Messages.getString((String)"SelectValueDialog.selectValue"), (String)(Messages.getString((String)"SelectValueDialog.messages.error.selectVauleUnavailable") + "\n" + ex.getMessage()));
                            }
                        } else {
                            MessageDialog.openInformation(null, (String)Messages.getString((String)"SelectValueDialog.selectValue"), (String)Messages.getString((String)"SelectValueDialog.messages.info.selectVauleUnavailable"));
                        }
                    } else if (value.equals(actions[1])) {
                        ExpressionBuilder dialog = new ExpressionBuilder(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)ExpressionValueCellEditor.this.getValue());
                        dialog.setExpressionProvier(ExpressionValueCellEditor.this.provider);
                        if (dialog.open() == 0) {
                            newValue = dialog.getResult();
                        }
                    } else if (selectionIndex > 3) {
                        newValue = "params[\"" + value + "\"]";
                    }
                    if (newValue != null) {
                        ExpressionValueCellEditor.this.setValue(newValue);
                    }
                    ExpressionValueCellEditor.this.expressionText.setFocus();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.setValueValid(true);
        return editorComposite;
    }

    private List getSelectValueList() throws BirtException {
        ArrayList<Object> selectValueList = new ArrayList<Object>();
        if (this.selectValueExpression != null && this.selectValueExpression.trim().length() > 0 && this.currentItem instanceof DataSetHandle) {
            IPreparedQuery queryDefn = DataSetProvider.getCurrentInstance().prepareQuery((DataSetHandle)this.currentItem, this.getBindingParams(), true, this.useDataSetFilter);
            BaseQueryDefinition query = (BaseQueryDefinition)queryDefn.getReportQueryDefn();
            String bindingNameGroup = "GROUP_SELECTVALUE";
            ScriptExpression bindingExprGroup = new ScriptExpression(ExpressionUtility.getReplacedColRefExpr(this.selectValueExpression));
            GroupDefinition groupDefn = new GroupDefinition();
            groupDefn.setKeyExpression("row.GROUP_SELECTVALUE");
            if (bindingNameGroup != null) {
                query.addResultSetExpression(bindingNameGroup, (IBaseExpression)bindingExprGroup);
            }
            query.addGroup(groupDefn);
            query.setUsesDetails(false);
            IPreparedQuery preparedQuery = DataSetProvider.getCurrentInstance().prepareQuery((DataSetHandle)this.currentItem, (IQueryDefinition)query, true, this.useDataSetFilter);
            IQueryResults results = preparedQuery.execute(null);
            if (results != null) {
                IResultIterator iter = null;
                iter = results.getResultIterator();
                if (iter != null) {
                    while (iter.next()) {
                        Object candiateValue = iter.getValue(bindingNameGroup);
                        if (candiateValue == null) continue;
                        selectValueList.add(candiateValue);
                    }
                }
                results.close();
            }
        } else {
            selectValueList.clear();
            ExceptionHandler.openErrorMessageBox(Messages.getString((String)"SelectValueDialog.errorRetrievinglist"), Messages.getString((String)"SelectValueDialog.noExpressionSet"));
        }
        return selectValueList;
    }

    protected void focusLost() {
        if (this.btnPopup != null && !this.btnPopup.isFocusControl() && Display.getCurrent().getCursorControl() != this.btnPopup) {
            super.focusLost();
        }
    }

    protected Object doGetValue() {
        if (this.expressionText != null) {
            return this.expressionText.getText();
        }
        return null;
    }

    protected void doSetFocus() {
        if (this.expressionText != null && this.expressionText.isVisible()) {
            this.expressionText.setFocus();
        }
    }

    protected void doSetValue(Object value) {
        if (value != null && this.expressionText != null) {
            this.expressionText.setText(value.toString());
        }
    }

    public ParamBindingHandle[] getBindingParams() {
        return this.bindingParams;
    }

    public void setBindingParams(ParamBindingHandle[] bindingParams) {
        this.bindingParams = bindingParams;
    }

    public String getSelectValueExpression() {
        return this.selectValueExpression;
    }

    public void setSelectValueExpression(String selectValueExpression) {
        this.selectValueExpression = selectValueExpression;
    }

    public void setReportElement(ReportElementHandle reportItem) {
        this.currentItem = reportItem;
    }

    private void refreshList() {
        if (this.refreshItems) {
            ArrayList<String> finalItems = new ArrayList<String>(10);
            for (int n = 0; n < actions.length; ++n) {
                finalItems.add(actions[n]);
            }
            if (this.currentItem != null) {
                // empty if block
            }
            this.popupItems = finalItems.toArray(EMPTY_ARRAY);
        }
        this.refreshItems = false;
    }

    public void activate() {
        this.refreshItems = true;
        super.activate();
    }

    public void setExpressionProvider(IExpressionProvider provider) {
        this.provider = provider;
    }

    public void addFilter(ExpressionFilter filter) {
    }

    public void setDataSetList(List dataSetList) {
    }

    private class ExpressionCellLayout
    extends Layout {
        private ExpressionCellLayout() {
        }

        public void layout(Composite editor, boolean force) {
            Rectangle bounds = editor.getClientArea();
            Point size = ExpressionValueCellEditor.this.btnPopup.computeSize(-1, -1, force);
            ExpressionValueCellEditor.this.expressionText.setBounds(0, 0, bounds.width - size.x, bounds.height);
            ExpressionValueCellEditor.this.btnPopup.setBounds(bounds.width - size.x, 0, size.x, bounds.height);
        }

        public Point computeSize(Composite editor, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Point contentsSize = ExpressionValueCellEditor.this.expressionText.computeSize(-1, -1, force);
            Point buttonSize = ExpressionValueCellEditor.this.btnPopup.computeSize(-1, -1, force);
            Point result = new Point(buttonSize.x, Math.max(contentsSize.y, buttonSize.y));
            return result;
        }
    }
}

