/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.data.ui.property.AbstractDescriptionPropertyPage;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.model.api.ColumnHintHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.elements.structures.ColumnHint;
import org.eclipse.birt.report.model.api.elements.structures.ResultSetColumn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class OutputColumnDefnPage
extends AbstractDescriptionPropertyPage
implements Listener {
    private boolean modelChanged = true;
    private PropertyHandle rsColumns;
    private PropertyHandle columnHints;
    private Map rsColumnMap = new HashMap();
    private Map columnHintMap = new HashMap();
    private List columnHandlesList = new ArrayList();
    private OutputColumnTableViewer viewer;
    private static String[] dataTypes = new String[]{"any", "date-time", "decimal", "float", "integer", "string"};
    private static String[] dataTypeDisplayNames = new String[]{Messages.getString((String)"datatypes.any"), Messages.getString((String)"datatypes.dateTime"), Messages.getString((String)"datatypes.decimal"), Messages.getString((String)"datatypes.float"), Messages.getString((String)"datatypes.integer"), Messages.getString((String)"datatypes.string")};
    private static String NAME = "name";
    private static String TYPE = "dataType";
    private static String ALIAS = "alias";
    private static String DISPLAY_NAME = "displayName";
    private static String HELP_TEXT = "helpText";
    private ColumnDefn newDefn = null;
    private static final Image selectorImage = ReportPlatformUIImages.getImage("TableRowSelector");
    private static String DEFAULT_MESSAGE = Messages.getString((String)"dataset.editor.outputColumns");
    private static String DUPLICATE_MESSAGE = Messages.getString((String)"error.duplicateName");
    private static String BLANK_MESSAGE = Messages.getString((String)"error.emptyName");

    public Control createContents(Composite parent) {
        this.rsColumns = ((DataSetHandle)this.getContainer().getModel()).getPropertyHandle("resultSetHints");
        this.columnHints = ((DataSetHandle)this.getContainer().getModel()).getPropertyHandle("columnHints");
        this.createCachedMap();
        this.initColumnHandles();
        this.viewer = new OutputColumnTableViewer(parent, true, true, true);
        TableColumn column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(" ");
        column.setResizable(false);
        column.setWidth(19);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(Messages.getString((String)"dataset.editor.title.name"));
        column.setWidth(100);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(Messages.getString((String)"dataset.editor.title.type"));
        column.setWidth(100);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(Messages.getString((String)"dataset.editor.title.alias"));
        column.setWidth(100);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(Messages.getString((String)"dataset.editor.title.displayName"));
        column.setWidth(100);
        this.viewer.getViewer().setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                List temp = OutputColumnDefnPage.this.columnHandlesList;
                ArrayList<ColumnDefn> defns = new ArrayList<ColumnDefn>();
                if (OutputColumnDefnPage.this.newDefn == null) {
                    OutputColumnDefnPage.this.newDefn = new ColumnDefn();
                }
                defns.addAll(temp);
                defns.add(OutputColumnDefnPage.this.newDefn);
                return defns.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.viewer.getViewer().setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                if (columnIndex == 0) {
                    return selectorImage;
                }
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                String value = null;
                ColumnDefn defn = null;
                if (element instanceof ColumnHandles) {
                    defn = new ColumnDefn((ColumnHandles)element);
                } else if (element instanceof ColumnDefn) {
                    defn = (ColumnDefn)element;
                } else {
                    return "";
                }
                switch (columnIndex) {
                    case 1: {
                        value = defn.getColumnName();
                        break;
                    }
                    case 2: {
                        if (defn == OutputColumnDefnPage.this.newDefn) break;
                        value = OutputColumnDefnPage.this.getTypeDisplayName(defn.getDataType());
                        break;
                    }
                    case 3: {
                        value = defn.getAlias();
                        break;
                    }
                    case 4: {
                        value = defn.getDisplayName();
                        break;
                    }
                    case 5: {
                        value = defn.getHelpText();
                    }
                }
                if (value == null) {
                    value = "";
                }
                return value;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.viewer.getViewer().setInput((Object)this.columnHandlesList);
        this.setupEditors();
        this.setPageProperties();
        ((DataSetHandle)this.getContainer().getModel()).addListener((Listener)this);
        return this.viewer.getControl();
    }

    protected final void setupEditors() {
        CellEditor[] editors = new CellEditor[6];
        editors[1] = new TextCellEditor((Composite)this.viewer.getViewer().getTable(), 0);
        editors[2] = new ComboBoxCellEditor((Composite)this.viewer.getViewer().getTable(), dataTypeDisplayNames, 8);
        editors[3] = new TextCellEditor((Composite)this.viewer.getViewer().getTable(), 0);
        editors[4] = new TextCellEditor((Composite)this.viewer.getViewer().getTable(), 0);
        editors[5] = new TextCellEditor((Composite)this.viewer.getViewer().getTable(), 0);
        this.viewer.getViewer().setColumnProperties(new String[]{"", NAME, TYPE, ALIAS, DISPLAY_NAME, HELP_TEXT});
        this.viewer.getViewer().setCellEditors(editors);
        this.viewer.getViewer().setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                OutputColumnDefnPage.this.getContainer().setMessage(DEFAULT_MESSAGE, 0);
                return element != OutputColumnDefnPage.this.newDefn || property.equals(NAME);
            }

            public Object getValue(Object element, String property) {
                ColumnDefn defn = null;
                if (element instanceof ColumnHandles) {
                    defn = new ColumnDefn((ColumnHandles)element);
                } else if (element == OutputColumnDefnPage.this.newDefn) {
                    defn = OutputColumnDefnPage.this.newDefn;
                } else {
                    return "";
                }
                Object value = null;
                try {
                    value = defn.getProperty(property);
                }
                catch (Exception e) {
                    ExceptionHandler.handle(e);
                }
                if (property.equals(TYPE)) {
                    value = value != null ? new Integer(OutputColumnDefnPage.this.getTypeIndex(value.toString())) : new Integer(-1);
                }
                if (value == null) {
                    value = "";
                }
                return value;
            }

            public void modify(Object element, String property, Object value) {
                Object actualElement = ((TableItem)element).getData();
                Object finalValue = value;
                ColumnDefn defn = null;
                if (actualElement instanceof ColumnHandles) {
                    defn = new ColumnDefn((ColumnHandles)actualElement);
                } else if (actualElement == OutputColumnDefnPage.this.newDefn) {
                    defn = OutputColumnDefnPage.this.newDefn;
                } else {
                    return;
                }
                if (property.equals(TYPE)) {
                    finalValue = OutputColumnDefnPage.this.getTypeString((Integer)value);
                }
                if (property.equals(NAME)) {
                    if (finalValue == null || finalValue.equals("")) {
                        OutputColumnDefnPage.this.getContainer().setMessage(BLANK_MESSAGE, 3);
                        return;
                    }
                    if (OutputColumnDefnPage.this.isDuplicated(finalValue, actualElement)) {
                        OutputColumnDefnPage.this.getContainer().setMessage(DUPLICATE_MESSAGE, 3);
                        return;
                    }
                    OutputColumnDefnPage.this.updateNewDefnMap(defn.getColumnName(), finalValue);
                }
                defn.setProperty(property, finalValue);
                OutputColumnDefnPage.this.getContainer().setMessage(DEFAULT_MESSAGE, 0);
                try {
                    if (actualElement == OutputColumnDefnPage.this.newDefn && OutputColumnDefnPage.this.newDefn.getColumnName() != null && OutputColumnDefnPage.this.newDefn.getColumnName().trim().length() > 0) {
                        if (OutputColumnDefnPage.this.newDefn.getDataType() == null || OutputColumnDefnPage.this.newDefn.getDataType().trim().length() == 0) {
                            OutputColumnDefnPage.this.newDefn.setDataType("any");
                        }
                        OutputColumnDefnPage.this.addNewDefn(OutputColumnDefnPage.this.newDefn);
                        OutputColumnDefnPage.this.newDefn = null;
                        OutputColumnDefnPage.this.setPageProperties();
                        OutputColumnDefnPage.this.viewer.getViewer().refresh();
                    }
                    OutputColumnDefnPage.this.viewer.getViewer().update(actualElement, null);
                    OutputColumnDefnPage.this.updateMessage();
                }
                catch (Exception ex) {
                    ExceptionHandler.handle(ex);
                }
            }
        });
    }

    private boolean isDuplicated(Object columnName, Object data) {
        if (this.columnHintMap.containsKey(columnName)) {
            if (data instanceof ColumnDefn) {
                return true;
            }
            return this.columnHintMap.get(columnName) != ((ColumnHandles)data).getColumnHintHandle().getStructure();
        }
        return false;
    }

    private void addNewDefn(ColumnDefn defn) throws SemanticException {
        String name = defn.getColumnName();
        if (this.rsColumnMap != null) {
            if (this.rsColumnMap.get(name) != null) {
                name = this.getUniqueName();
                defn.setColumnName(name);
            }
            if (this.rsColumns != null && this.columnHints != null) {
                ResultSetColumnHandle rsHandle = (ResultSetColumnHandle)this.rsColumns.addItem((IStructure)defn.getResultSetColumn());
                ColumnHintHandle columnHandle = (ColumnHintHandle)this.columnHints.addItem((IStructure)defn.getColumnHint());
                this.rsColumnMap.put(name, defn.getResultSetColumn());
                this.columnHintMap.put(name, defn.getColumnHint());
                this.columnHandlesList.add(new ColumnHandles(rsHandle, columnHandle));
            }
        }
    }

    private void updateNewDefnMap(Object oldName, Object newName) {
        if (this.rsColumnMap != null && oldName != null && !oldName.equals(newName) && this.rsColumnMap.get(oldName) != null) {
            this.rsColumnMap.put(newName, this.rsColumnMap.get(oldName));
            this.rsColumnMap.remove(oldName);
            this.columnHintMap.put(newName, this.columnHintMap.get(oldName));
            this.columnHintMap.remove(oldName);
        }
    }

    private final int getTypeIndex(String dataTypeName) {
        for (int n = 0; n < dataTypes.length; ++n) {
            if (!dataTypes[n].equals(dataTypeName)) continue;
            return n;
        }
        return -1;
    }

    private final String getTypeString(int index) {
        if (index > -1 && index < dataTypes.length) {
            return dataTypes[index];
        }
        return null;
    }

    private final String getTypeDisplayName(String typeName) {
        for (int n = 0; n < dataTypes.length; ++n) {
            if (!dataTypes[n].equals(typeName)) continue;
            return dataTypeDisplayNames[n];
        }
        return dataTypeDisplayNames[0];
    }

    private void setPageProperties() {
        boolean columnsExist = false;
        columnsExist = this.columnHandlesList != null && this.columnHandlesList.size() > 0;
        this.viewer.getDownButton().setEnabled(columnsExist);
        this.viewer.getUpButton().setEnabled(columnsExist);
        this.viewer.getRemoveButton().setEnabled(columnsExist);
        this.viewer.getRemoveMenuItem().setEnabled(columnsExist);
        this.viewer.getRemoveAllMenuItem().setEnabled(columnsExist);
    }

    public void pageActivated() {
        this.getContainer().setMessage(DEFAULT_MESSAGE, 0);
        if (this.modelChanged) {
            this.modelChanged = false;
            this.refreshColumns();
        }
    }

    private void refreshColumns() {
        try {
            this.refreshPositions();
            this.viewer.getViewer().refresh();
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
        this.modelChanged = true;
    }

    protected final ColumnDefn findColumnByPosition(int position) {
        Iterator iter;
        ResultSetColumnHandle column = null;
        ColumnHintHandle hint = null;
        if (this.rsColumns != null && (iter = this.rsColumns.iterator()) != null) {
            while (iter.hasNext() && ((column = (ResultSetColumnHandle)iter.next()).getPosition() == null || column.getPosition() != position)) {
            }
        }
        if (this.columnHints != null && (iter = this.columnHints.iterator()) != null) {
            while (iter.hasNext() && ((hint = (ColumnHintHandle)iter.next()).getColumnName() == null || !hint.getColumnName().equals(column.getColumnName()))) {
            }
        }
        if (column != null) {
            return new ColumnDefn(new ColumnHandles(column, hint));
        }
        return null;
    }

    protected final ColumnDefn findColumnByName(String name) {
        if (this.columnHints != null) {
            return new ColumnDefn(new ColumnHandles((ResultSetColumnHandle)this.rsColumnMap.get(name), (ColumnHintHandle)this.columnHintMap.get(name)));
        }
        return null;
    }

    protected final void refreshPositions() {
        if (this.rsColumns == null) {
            return;
        }
        int position = 1;
        Iterator iter = this.rsColumns.iterator();
        if (iter != null) {
            while (iter.hasNext()) {
                ResultSetColumnHandle column = (ResultSetColumnHandle)iter.next();
                column.setPosition(new Integer(position++));
            }
        }
    }

    protected final String getUniqueName() {
        int n = 1;
        String prefix = "column";
        StringBuffer buf = new StringBuffer();
        while (buf.length() == 0) {
            Iterator iter;
            buf.append(prefix).append(n++);
            if (this.rsColumns == null || (iter = this.rsColumns.iterator()) == null) continue;
            while (iter.hasNext() && buf.length() > 0) {
                ResultSetColumnHandle column = (ResultSetColumnHandle)iter.next();
                if (!buf.toString().equalsIgnoreCase(column.getColumnName())) continue;
                buf.setLength(0);
            }
        }
        return buf.toString();
    }

    public boolean performCancel() {
        this.disposeAll();
        return super.performCancel();
    }

    public boolean performOk() {
        if (this.isValid()) {
            this.refreshPositions();
            this.disposeAll();
            return super.performOk();
        }
        return false;
    }

    private boolean isValid() {
        boolean validate = true;
        if (this.columnHints == null) {
            this.columnHints = ((DataSetHandle)this.getContainer().getModel()).getPropertyHandle("columnHints");
        }
        Iterator iterator1 = this.columnHints.iterator();
        int i = 0;
        while (iterator1.hasNext() && validate) {
            ColumnHintHandle columnHint = (ColumnHintHandle)iterator1.next();
            String newColumnNameOrAlias = columnHint.getAlias();
            Iterator iterator2 = this.columnHints.iterator();
            if (newColumnNameOrAlias != null && newColumnNameOrAlias.length() > 0) {
                int n = 0;
                while (iterator2.hasNext()) {
                    ColumnHintHandle columnHint2 = (ColumnHintHandle)iterator2.next();
                    if (i != n && (columnHint2.getColumnName() != null && columnHint2.getColumnName().equals(newColumnNameOrAlias) || columnHint2.getAlias() != null && columnHint2.getAlias().equals(newColumnNameOrAlias))) {
                        validate = false;
                        this.getContainer().setMessage(Messages.getFormattedString((String)"dataset.editor.error.columnOrAliasNameAlreadyUsed", (Object[])new Object[]{newColumnNameOrAlias, n > i ? new Integer(i + 1) : new Integer(n + 1), n > i ? new Integer(n + 1) : new Integer(i + 1)}), 3);
                        break;
                    }
                    ++n;
                }
            }
            ++i;
        }
        return validate;
    }

    private void updateMessage() {
        if (this.isValid()) {
            this.getContainer().setMessage(Messages.getString((String)"dataset.editor.outputColumns"), 0);
        }
    }

    private void disposeAll() {
        this.rsColumnMap = null;
        this.columnHintMap = null;
        ((DataSetHandle)this.getContainer().getModel()).removeListener((Listener)this);
    }

    public String getPageDescription() {
        return Messages.getString((String)"OutputColumnDefnPage.description");
    }

    public boolean canLeave() {
        if (this.isValid()) {
            this.refreshPositions();
            return super.canLeave();
        }
        return false;
    }

    private void refreshCachedMap() {
        this.columnHintMap.clear();
        this.rsColumnMap.clear();
        Iterator iterator = this.columnHints.iterator();
        while (iterator.hasNext()) {
            ColumnHintHandle handle = (ColumnHintHandle)iterator.next();
            this.columnHintMap.put(handle.getColumnName(), handle.getStructure());
        }
        IStructure toDelete = null;
        if (this.rsColumns == null) {
            return;
        }
        Iterator iterator2 = this.rsColumns.iterator();
        while (iterator2.hasNext()) {
            ResultSetColumnHandle handle = (ResultSetColumnHandle)iterator2.next();
            if (this.columnHintMap.get(handle.getColumnName()) == null) {
                toDelete = handle.getStructure();
                continue;
            }
            this.rsColumnMap.put(handle.getColumnName(), handle.getStructure());
        }
        if (toDelete != null) {
            try {
                this.rsColumns.removeItem(toDelete);
            }
            catch (PropertyValueException e) {
                ExceptionHandler.handle(e);
            }
        }
    }

    private void createCachedMap() {
        ResultSetColumnHandle handle;
        if (this.rsColumns == null) {
            return;
        }
        Iterator iterator = this.rsColumns.iterator();
        while (iterator.hasNext()) {
            handle = (ResultSetColumnHandle)iterator.next();
            this.rsColumnMap.put(handle.getColumnName(), handle.getStructure());
        }
        iterator = this.columnHints.iterator();
        while (iterator.hasNext()) {
            handle = (ColumnHintHandle)iterator.next();
            this.columnHintMap.put(handle.getColumnName(), handle.getStructure());
        }
    }

    private void initColumnHandles() {
        if (this.columnHints == null || this.rsColumns == null) {
            return;
        }
        Iterator it = this.rsColumns.iterator();
        Iterator it1 = this.columnHints.iterator();
        while (it.hasNext()) {
            this.columnHandlesList.add(new ColumnHandles((ResultSetColumnHandle)it.next(), (ColumnHintHandle)it1.next()));
        }
    }

    public String getToolTip() {
        return Messages.getString((String)"OutputColumnDefnPage.OutputColumns.Tooltip");
    }

    static /* synthetic */ Map access$2500(OutputColumnDefnPage x0) {
        return x0.columnHintMap;
    }

    static /* synthetic */ Map access$2600(OutputColumnDefnPage x0) {
        return x0.rsColumnMap;
    }

    private class OutputColumnTableViewer {
        private TableViewer viewer;
        private Composite mainControl;
        private Button btnRemove;
        private Button btnUp;
        private Button btnDown;
        private MenuItem itmRemove;
        private MenuItem itmRemoveAll;
        private Menu menu;

        public OutputColumnTableViewer(Composite parent, boolean showMenus, boolean showButtons, boolean enableKeyStrokes) {
            this.mainControl = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            this.mainControl.setLayout((Layout)layout);
            GridData data = null;
            this.viewer = new TableViewer(this.mainControl, 65536);
            data = new GridData(1808);
            this.viewer.getControl().setLayoutData((Object)data);
            this.viewer.getTable().setHeaderVisible(true);
            this.viewer.getTable().setLinesVisible(true);
            if (showButtons) {
                Composite btnComposite = new Composite(this.mainControl, 0);
                data = new GridData();
                data.verticalAlignment = 0x1000000;
                btnComposite.setLayoutData((Object)data);
                GridLayout btnLayout = new GridLayout();
                layout.verticalSpacing = 20;
                btnComposite.setLayout((Layout)btnLayout);
                GridData btnData = new GridData(2);
                btnData.widthHint = 20;
                btnData.heightHint = 20;
                this.btnUp = new Button(btnComposite, 132);
                this.btnUp.setLayoutData((Object)btnData);
                this.btnUp.addSelectionListener(new SelectionListener(this){
                    private final /* synthetic */ OutputColumnTableViewer this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        int index = OutputColumnTableViewer.access$2000(this.this$1).getTable().getSelectionIndex();
                        if (index - 1 >= 0 && index < OutputColumnDefnPage.access$000(OutputColumnTableViewer.access$2100(this.this$1)).size()) {
                            ColumnHandles columnHandle1 = (ColumnHandles)OutputColumnDefnPage.access$000(OutputColumnTableViewer.access$2100(this.this$1)).get(index);
                            OutputColumnTableViewer.access$2000(this.this$1).cancelEditing();
                            try {
                                OutputColumnDefnPage.access$000(OutputColumnTableViewer.access$2100(this.this$1)).set(index, OutputColumnDefnPage.access$000(OutputColumnTableViewer.access$2100(this.this$1)).get(index - 1));
                                OutputColumnDefnPage.access$000(OutputColumnTableViewer.access$2100(this.this$1)).set(index - 1, columnHandle1);
                                if (OutputColumnDefnPage.access$2200(OutputColumnTableViewer.access$2100(this.this$1)) != null) {
                                    OutputColumnDefnPage.access$2200(OutputColumnTableViewer.access$2100(this.this$1)).moveItem(index, index - 1);
                                }
                            }
                            catch (Exception e1) {
                                ExceptionHandler.handle(e1);
                            }
                            OutputColumnTableViewer.access$2000(this.this$1).refresh();
                            OutputColumnTableViewer.access$2000(this.this$1).getTable().select(index - 1);
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                btnData = new GridData(2);
                btnData.widthHint = 20;
                btnData.heightHint = 20;
                this.btnRemove = new Button(btnComposite, 8);
                this.btnRemove.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
                this.btnRemove.setLayoutData((Object)btnData);
                this.btnRemove.addSelectionListener(new SelectionListener(this){
                    private final /* synthetic */ OutputColumnTableViewer this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        OutputColumnTableViewer.access$2300(this.this$1);
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                btnData = new GridData(2);
                btnData.widthHint = 20;
                btnData.heightHint = 20;
                this.btnDown = new Button(btnComposite, 1028);
                this.btnDown.setLayoutData((Object)btnData);
                this.btnDown.addSelectionListener(new SelectionListener(this){
                    private final /* synthetic */ OutputColumnTableViewer this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        int index = OutputColumnTableViewer.access$2000(this.this$1).getTable().getSelectionIndex();
                        if (index > -1 && index < OutputColumnDefnPage.access$000(OutputColumnTableViewer.access$2100(this.this$1)).size() - 1) {
                            OutputColumnTableViewer.access$2000(this.this$1).cancelEditing();
                            try {
                                ColumnHandles columnHandle = (ColumnHandles)OutputColumnDefnPage.access$000(OutputColumnTableViewer.access$2100(this.this$1)).get(index);
                                OutputColumnDefnPage.access$000(OutputColumnTableViewer.access$2100(this.this$1)).set(index, OutputColumnDefnPage.access$000(OutputColumnTableViewer.access$2100(this.this$1)).get(index + 1));
                                OutputColumnDefnPage.access$000(OutputColumnTableViewer.access$2100(this.this$1)).set(index + 1, columnHandle);
                                if (OutputColumnDefnPage.access$2200(OutputColumnTableViewer.access$2100(this.this$1)) != null) {
                                    OutputColumnDefnPage.access$2200(OutputColumnTableViewer.access$2100(this.this$1)).moveItem(index, index + 1);
                                }
                            }
                            catch (Exception e1) {
                                ExceptionHandler.handle(e1);
                            }
                            OutputColumnTableViewer.access$2000(this.this$1).refresh();
                            OutputColumnTableViewer.access$2000(this.this$1).getTable().select(index + 1);
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
            }
            if (showMenus) {
                this.menu = new Menu((Control)this.viewer.getTable());
                this.menu.addMenuListener((MenuListener)new MenuAdapter(this){
                    private final /* synthetic */ OutputColumnTableViewer this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void menuShown(MenuEvent e) {
                        OutputColumnTableViewer.access$2000(this.this$1).cancelEditing();
                    }
                });
                this.itmRemove = new MenuItem(this.menu, 0);
                this.itmRemove.setText(Messages.getString((String)"PropertyHandleTableViewer.Menu.Remove"));
                this.itmRemove.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                    private final /* synthetic */ OutputColumnTableViewer this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        OutputColumnTableViewer.access$2300(this.this$1);
                    }
                });
                this.itmRemoveAll = new MenuItem(this.menu, 0);
                this.itmRemoveAll.setText(Messages.getString((String)"PropertyHandleTableViewer.Menu.RemoveAll"));
                this.itmRemoveAll.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                    private final /* synthetic */ OutputColumnTableViewer this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        try {
                            int index = 0;
                            while (index < OutputColumnDefnPage.access$000(OutputColumnTableViewer.access$2100(this.this$1)).size()) {
                                OutputColumnDefnPage.access$000(OutputColumnTableViewer.access$2100(this.this$1)).remove(0);
                            }
                            if (OutputColumnDefnPage.access$2200(OutputColumnTableViewer.access$2100(this.this$1)) != null) {
                                OutputColumnDefnPage.access$2200(OutputColumnTableViewer.access$2100(this.this$1)).clearValue();
                            }
                            OutputColumnDefnPage.access$2400(OutputColumnTableViewer.access$2100(this.this$1)).clearValue();
                            OutputColumnTableViewer.access$2000(this.this$1).refresh();
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                        OutputColumnDefnPage.access$2500(OutputColumnTableViewer.access$2100(this.this$1)).clear();
                        OutputColumnDefnPage.access$2600(OutputColumnTableViewer.access$2100(this.this$1)).clear();
                        OutputColumnDefnPage.access$1400(OutputColumnTableViewer.access$2100(this.this$1));
                    }
                });
                this.viewer.getTable().setMenu(this.menu);
            }
            if (enableKeyStrokes) {
                this.viewer.getTable().addKeyListener(new KeyListener(this){
                    private final /* synthetic */ OutputColumnTableViewer this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void keyPressed(KeyEvent e) {
                    }

                    public void keyReleased(KeyEvent e) {
                        if (e.keyCode == 127) {
                            OutputColumnTableViewer.access$2300(this.this$1);
                        }
                    }
                });
            }
        }

        public TableViewer getViewer() {
            return this.viewer;
        }

        public Composite getControl() {
            return this.mainControl;
        }

        public Button getUpButton() {
            return this.btnUp;
        }

        public Menu getMenu() {
            return this.menu;
        }

        public Button getDownButton() {
            return this.btnDown;
        }

        public Button getRemoveButton() {
            return this.btnRemove;
        }

        public MenuItem getRemoveMenuItem() {
            return this.itmRemove;
        }

        public MenuItem getRemoveAllMenuItem() {
            return this.itmRemoveAll;
        }

        private final void removeSelectedItem() {
            int index = this.viewer.getTable().getSelectionIndex();
            int count = OutputColumnDefnPage.this.columnHandlesList.size();
            if (index > -1 && index < count) {
                try {
                    OutputColumnDefnPage.this.columnHandlesList.remove(index);
                    if (OutputColumnDefnPage.this.rsColumns != null) {
                        OutputColumnDefnPage.this.rsColumns.removeItem(index);
                    }
                    OutputColumnDefnPage.this.columnHints.removeItem(index);
                }
                catch (Exception e1) {
                    ExceptionHandler.handle(e1);
                }
                this.viewer.refresh();
                this.viewer.getTable().select(index);
                OutputColumnDefnPage.this.refreshCachedMap();
            }
            OutputColumnDefnPage.this.setPageProperties();
        }

        static /* synthetic */ TableViewer access$2000(OutputColumnTableViewer x0) {
            return x0.viewer;
        }

        static /* synthetic */ OutputColumnDefnPage access$2100(OutputColumnTableViewer x0) {
            return x0.OutputColumnDefnPage.this;
        }

        static /* synthetic */ void access$2300(OutputColumnTableViewer x0) {
            x0.removeSelectedItem();
        }
    }

    private class ColumnDefn {
        private ResultSetColumnHandle rsColumnHandle;
        private ColumnHintHandle columnHintHandle;
        private ResultSetColumn rsColumn;
        private ColumnHint columnHint;

        public ColumnDefn() {
            this.rsColumn = new ResultSetColumn();
            this.columnHint = new ColumnHint();
        }

        public ColumnDefn(ColumnHandles hc) {
            this.rsColumnHandle = hc.getResultSetColumnHandle();
            this.columnHintHandle = hc.getColumnHintHandle();
        }

        public ResultSetColumn getResultSetColumn() {
            if (this.rsColumnHandle != null) {
                return (ResultSetColumn)this.rsColumnHandle.getStructure();
            }
            return this.rsColumn;
        }

        public ColumnHint getColumnHint() {
            if (this.columnHintHandle != null) {
                return (ColumnHint)this.columnHintHandle.getStructure();
            }
            return this.columnHint;
        }

        public String getColumnName() {
            if (this.rsColumnHandle != null) {
                return this.rsColumnHandle.getColumnName();
            }
            if (this.rsColumn != null) {
                return this.rsColumn.getColumnName();
            }
            return null;
        }

        public void setColumnName(String columnName) {
            if (this.rsColumnHandle != null && this.columnHintHandle != null) {
                this.rsColumnHandle.setColumnName(columnName);
                this.columnHintHandle.setColumnName(columnName);
            } else if (this.rsColumn != null && this.columnHint != null) {
                this.rsColumn.setColumnName(columnName);
                this.columnHint.setProperty("columnName", (Object)columnName);
            }
        }

        public String getAlias() {
            if (this.columnHintHandle != null) {
                return this.columnHintHandle.getAlias();
            }
            return (String)this.columnHint.getProperty(null, "alias");
        }

        public void setAlias(String alias) {
            if (this.columnHintHandle != null) {
                this.columnHintHandle.setAlias(alias);
            } else {
                this.columnHint.setProperty("alias", (Object)alias);
            }
        }

        public String getDataType() {
            if (this.rsColumnHandle != null) {
                return this.rsColumnHandle.getDataType();
            }
            return this.rsColumn.getDataType();
        }

        public void setDataType(String dataType) {
            try {
                if (this.rsColumnHandle != null) {
                    this.rsColumnHandle.setDataType(dataType);
                } else {
                    this.rsColumn.setDataType(dataType);
                }
            }
            catch (SemanticException e) {
                e.printStackTrace();
            }
        }

        public String getDisplayName() {
            if (this.columnHintHandle != null) {
                return this.columnHintHandle.getDisplayName();
            }
            return (String)this.columnHint.getProperty(null, "displayName");
        }

        public void setDisplayName(String displayName) {
            if (this.columnHintHandle != null) {
                this.columnHintHandle.setDisplayName(displayName);
            } else {
                this.columnHint.setProperty("displayName", (Object)displayName);
            }
        }

        public String getHelpText() {
            if (this.columnHintHandle != null) {
                return this.columnHintHandle.getHelpText();
            }
            return (String)this.columnHint.getProperty(null, "helpText");
        }

        public void setHelpText(String helpText) {
            if (this.columnHintHandle != null) {
                this.columnHintHandle.setHelpText(helpText);
            } else {
                this.columnHint.setProperty("helpText", (Object)helpText);
            }
        }

        public void setProperty(Object property, Object value) {
            if (property.equals(NAME)) {
                this.setColumnName((String)value);
            } else if (property.equals(TYPE)) {
                this.setDataType((String)value);
            } else if (property.equals(ALIAS)) {
                this.setAlias((String)value);
            } else if (property.equals(DISPLAY_NAME)) {
                this.setDisplayName((String)value);
            } else if (property.equals(HELP_TEXT)) {
                this.setHelpText((String)value);
            }
        }

        public Object getProperty(Object property) {
            if (property.equals(NAME)) {
                return this.getColumnName();
            }
            if (property.equals(TYPE)) {
                return this.getDataType();
            }
            if (property.equals(ALIAS)) {
                return this.getAlias();
            }
            if (property.equals(DISPLAY_NAME)) {
                return this.getDisplayName();
            }
            if (property.equals(HELP_TEXT)) {
                return this.getHelpText();
            }
            return null;
        }
    }

    private class ColumnHandles {
        private ResultSetColumnHandle rsColumnHandle;
        private ColumnHintHandle chHandle;

        ColumnHandles(ResultSetColumnHandle rsch, ColumnHintHandle chh) {
            this.rsColumnHandle = rsch;
            this.chHandle = chh;
        }

        public ResultSetColumnHandle getResultSetColumnHandle() {
            return this.rsColumnHandle;
        }

        public ColumnHintHandle getColumnHintHandle() {
            return this.chHandle;
        }
    }
}

