/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.report.designer.data.ui.util.Utility;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.ColumnHintHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.ColumnHint;
import org.eclipse.birt.report.model.api.elements.structures.ResultSetColumn;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;

public class ResultSetColumnPage
extends Composite {
    private static final ResultSetColumnModel dummyModel = new ResultSetColumnModel();
    private IChoiceSet dataTypes = DesignEngine.getMetaDataDictionary().getChoiceSet("columnDataType");
    private static String[] allowedDataTypes = new String[]{"any", "date-time", "decimal", "float", "integer", "string"};
    private static String COLUMN_NAME = Messages.getString((String)"dataset.editor.title.name");
    private static String COLUMN_DATA_TYPE = Messages.getString((String)"dataset.editor.title.type");
    private static String COLUMN_ALIAS = Messages.getString((String)"dataset.editor.title.alias");
    private static String COLUMN_DISPLAY_NAME = Messages.getString((String)"dataset.editor.title.displayName");
    private static String ERROR_DLG_TITLE = "Invalid input";
    private static String ERROR_MSG_EMPTY_COLUMN_NAME = "The column name cannot be empty";
    private static String ERROR_MSG_DUPLICATED_NAME = "This name has been used by another column.";
    private ArrayList columnList = new ArrayList();
    private ArrayList renameRecord = new ArrayList();
    private ArrayList listenerList = new ArrayList();
    private IStructuredContentProvider contentProvider = new IStructuredContentProvider(){

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList list = (ArrayList)inputElement;
            ArrayList<ResultSetColumnModel> elementsList = new ArrayList<ResultSetColumnModel>(list);
            elementsList.add(dummyModel);
            return elementsList.toArray();
        }
    };
    private ITableLabelProvider labelProvider = new ITableLabelProvider(){

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ResultSetColumnModel model = (ResultSetColumnModel)element;
            String text = null;
            if (model != dummyModel) {
                switch (columnIndex) {
                    case 1: {
                        text = model.columnName;
                        break;
                    }
                    case 2: {
                        text = ResultSetColumnPage.this.dataTypes.findChoice(allowedDataTypes[model.dataType]).getDisplayName();
                        break;
                    }
                    case 3: {
                        text = model.alias;
                        break;
                    }
                    case 4: {
                        text = model.displayName;
                    }
                }
            } else if (columnIndex == 1) {
                text = "<New column here...>";
            }
            return Utility.convertToGUIString(text);
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    };
    private ICellModifier cellModifier = new ICellModifier(){

        public boolean canModify(Object element, String property) {
            if (property == null) {
                return false;
            }
            return element != dummyModel || property.equals(COLUMN_NAME);
        }

        public Object getValue(Object element, String property) {
            ResultSetColumnModel model = (ResultSetColumnModel)element;
            if (COLUMN_DATA_TYPE.equals(property)) {
                return new Integer(model.dataType);
            }
            String value = null;
            if (COLUMN_NAME.equals(property)) {
                if (model != dummyModel) {
                    value = model.columnName;
                }
            } else if (COLUMN_ALIAS.equals(property)) {
                value = model.alias;
            } else if (COLUMN_DISPLAY_NAME.equals(property)) {
                value = model.displayName;
            }
            return Utility.convertToGUIString(value);
        }

        public void modify(Object element, String property, Object newValue) {
            if (element instanceof Item) {
                element = ((Item)element).getData();
            }
            ResultSetColumnModel model = (ResultSetColumnModel)element;
            if (COLUMN_DATA_TYPE.equals(property)) {
                model.dataType = (Integer)newValue;
            } else {
                String value = (String)newValue;
                if (COLUMN_NAME.equals(property) && StringUtil.isBlank((String)value)) {
                    ExceptionHandler.openMessageBox(ERROR_DLG_TITLE, ERROR_MSG_EMPTY_COLUMN_NAME, 2);
                    return;
                }
                if ((COLUMN_NAME.equals(property) || COLUMN_ALIAS.equals(property)) && ResultSetColumnPage.this.containColumn(model, value = Utility.convertToModelString(value, true), true)) {
                    ExceptionHandler.openMessageBox(ERROR_DLG_TITLE, ERROR_MSG_DUPLICATED_NAME, 2);
                    return;
                }
                if (model == dummyModel) {
                    model = new ResultSetColumnModel();
                    ResultSetColumnPage.this.columnList.add(model);
                }
                if (COLUMN_NAME.equals(property)) {
                    ResultSetColumnPage.this.addRenameRecord(model.columnName, value);
                    model.columnName = value;
                } else if (COLUMN_ALIAS.equals(property)) {
                    model.alias = value;
                } else if (COLUMN_DISPLAY_NAME.equals(property)) {
                    model.displayName = value;
                }
            }
            ResultSetColumnPage.this.updateTable();
            ResultSetColumnPage.this.updateButtons();
        }
    };
    private TableViewer columnTable;
    private Button up;
    private Button down;
    private Button delete;

    public ResultSetColumnPage(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(1808);
        gd.widthHint = 650;
        this.setLayoutData(gd);
        this.createTableArea();
        this.createButtonArea();
        this.initAccessible();
    }

    private void createTableArea() {
        Table table = new Table((Composite)this, 67588);
        table.setLayoutData((Object)new GridData(1808));
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    ResultSetColumnPage.this.buttonPressed(127);
                }
            }
        });
        String[] columns = new String[]{null, COLUMN_NAME, COLUMN_DATA_TYPE, COLUMN_ALIAS, COLUMN_DISPLAY_NAME};
        int[] columnWidth = new int[]{20, 100, 100, 100, 100};
        String[] displayDataTypes = new String[allowedDataTypes.length];
        for (int i = 0; i < displayDataTypes.length; ++i) {
            displayDataTypes[i] = this.dataTypes.findChoice(allowedDataTypes[i]).getDisplayName();
        }
        ComboBoxCellEditor comboCell = new ComboBoxCellEditor((Composite)table, displayDataTypes, 8);
        CellEditor[] cellEditors = new CellEditor[]{null, new TextCellEditor((Composite)table), comboCell, new TextCellEditor((Composite)table), new TextCellEditor((Composite)table)};
        for (int i = 0; i < columns.length; ++i) {
            TableColumn column = new TableColumn(table, 16384);
            column.setResizable(columns[i] != null);
            if (columns[i] != null) {
                column.setText(columns[i]);
            }
            column.setWidth(columnWidth[i]);
        }
        this.columnTable = new TableViewer(table);
        this.columnTable.setCellEditors(cellEditors);
        this.columnTable.setColumnProperties(columns);
        this.columnTable.setContentProvider((IContentProvider)this.contentProvider);
        this.columnTable.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.columnTable.setCellModifier(this.cellModifier);
        this.columnTable.setInput((Object)this.columnList);
        this.columnTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ResultSetColumnPage.this.updateButtons();
            }
        });
    }

    private void createButtonArea() {
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayoutData((Object)new GridData(4));
        composite.setLayout((Layout)Utility.createGridLayoutWithoutMargin());
        this.up = new Button(composite, 132);
        GridData gd = new GridData(4);
        gd.heightHint = 20;
        gd.widthHint = 20;
        this.up.setLayoutData((Object)gd);
        this.up.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResultSetColumnPage.this.buttonPressed(128);
            }
        });
        this.delete = new Button(composite, 8);
        gd = new GridData(4);
        gd.heightHint = 20;
        gd.widthHint = 20;
        this.delete.setLayoutData((Object)gd);
        this.delete.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
        this.delete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResultSetColumnPage.this.buttonPressed(127);
            }
        });
        this.down = new Button(composite, 1028);
        gd = new GridData(4);
        gd.heightHint = 20;
        gd.widthHint = 20;
        this.down.setLayoutData((Object)gd);
        this.down.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResultSetColumnPage.this.buttonPressed(1024);
            }
        });
    }

    private void buttonPressed(int buttonId) {
        ResultSetColumnModel model = this.getSelectedColumn();
        int index = this.columnList.indexOf(model);
        this.columnList.remove(index);
        switch (buttonId) {
            case 128: {
                this.columnList.add(index - 1, model);
                break;
            }
            case 1024: {
                this.columnList.add(index + 1, model);
            }
        }
        this.updateTable();
        this.updateButtons();
    }

    public void setInput(DataSetHandle handle) {
        if (handle != null) {
            Iterator iter = handle.getPropertyHandle("resultSetHints").iterator();
            block0: while (iter.hasNext()) {
                ResultSetColumnHandle columnHandle = (ResultSetColumnHandle)iter.next();
                ResultSetColumnModel model = new ResultSetColumnModel();
                model.columnName = columnHandle.getColumnName();
                for (int i = 0; i < allowedDataTypes.length; ++i) {
                    if (!allowedDataTypes[i].equals(columnHandle.getDataType())) continue;
                    model.dataType = i;
                    continue block0;
                }
            }
            iter = handle.getPropertyHandle("columnHints").iterator();
            while (iter.hasNext()) {
                ColumnHintHandle hintHandle = (ColumnHintHandle)iter.next();
                int index = this.columnList.indexOf(hintHandle.getColumnName());
                if (index == -1) continue;
                ResultSetColumnModel model = (ResultSetColumnModel)this.columnList.get(index);
                model.alias = hintHandle.getAlias();
                model.displayName = hintHandle.getDisplayName();
                model.helpText = hintHandle.getHelpText();
            }
            this.updateTable();
        }
    }

    public void saveResult(DataSetHandle handle) {
        Assert.isNotNull((Object)handle);
        PropertyHandle resultSetPropertyHandle = handle.getPropertyHandle("resultSetHints");
        PropertyHandle columnHintPropertyHandle = handle.getPropertyHandle("columnHints");
        try {
            resultSetPropertyHandle.setStringValue(null);
            ArrayList<ColumnHintHandle> removeList = new ArrayList<ColumnHintHandle>();
            Iterator iter = columnHintPropertyHandle.iterator();
            while (iter.hasNext()) {
                ColumnHintHandle columnHintHandle = (ColumnHintHandle)iter.next();
                String newName = this.getNewName(columnHintHandle.getColumnName());
                if (newName != null) {
                    columnHintHandle.setColumnName(newName);
                }
                if (this.containColumn(null, columnHintHandle.getColumnName(), false)) continue;
                removeList.add(columnHintHandle);
            }
            columnHintPropertyHandle.removeItems(removeList);
            iter = this.columnList.iterator();
            int i = 0;
            while (iter.hasNext()) {
                ResultSetColumnModel model = (ResultSetColumnModel)iter.next();
                ResultSetColumn column = StructureFactory.createResultSetColumn();
                column.setColumnName(model.columnName);
                column.setDataType(allowedDataTypes[model.dataType]);
                column.setPosition(new Integer(i));
                resultSetPropertyHandle.addItem((IStructure)column);
                ColumnHintHandle columnHintHandle = null;
                Iterator hintIter = columnHintPropertyHandle.iterator();
                while (hintIter.hasNext() && !(columnHintHandle = (ColumnHintHandle)hintIter.next()).getColumnName().equals(model.columnName)) {
                    columnHintHandle = null;
                }
                if (columnHintHandle == null) {
                    ColumnHint columnHint = StructureFactory.createColumnHint();
                    columnHint.setProperty("columnName", (Object)model.columnName);
                    columnHintHandle = (ColumnHintHandle)columnHintPropertyHandle.addItem((IStructure)columnHint);
                }
                columnHintHandle.setAlias(model.alias);
                columnHintHandle.setDisplayName(model.displayName);
                columnHintHandle.setHelpText(model.helpText);
                ++i;
            }
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
    }

    public boolean isEmpty() {
        return this.columnList.isEmpty();
    }

    private void addRenameRecord(String oldName, String newName) {
        if (oldName == null) {
            return;
        }
        Iterator iter = this.renameRecord.iterator();
        while (iter.hasNext()) {
            String[] record = (String[])iter.next();
            if (!record[1].equals(oldName)) continue;
            record[1] = newName;
            return;
        }
        this.renameRecord.add(new String[]{oldName, newName});
    }

    private String getNewName(String oldName) {
        Iterator iter = this.renameRecord.iterator();
        while (iter.hasNext()) {
            String[] record = (String[])iter.next();
            if (!record[0].equals(oldName)) continue;
            return record[1];
        }
        return null;
    }

    private boolean containColumn(ResultSetColumnModel currentModel, String newName, boolean includingAlias) {
        if (newName == null) {
            return false;
        }
        Iterator iter = this.columnList.iterator();
        while (iter.hasNext()) {
            ResultSetColumnModel model = (ResultSetColumnModel)iter.next();
            if (model == currentModel || !newName.equals(model.columnName) && (!includingAlias || !newName.equals(model.alias))) continue;
            return true;
        }
        return false;
    }

    private ResultSetColumnModel getSelectedColumn() {
        return (ResultSetColumnModel)((IStructuredSelection)this.columnTable.getSelection()).getFirstElement();
    }

    public void addTreeRefreshListener(ITreeRefreshListener listener) {
        if (!this.listenerList.contains(listener)) {
            this.listenerList.add(listener);
        }
    }

    public void updateTable() {
        this.columnTable.refresh();
        Iterator iter = this.listenerList.iterator();
        while (iter.hasNext()) {
            ((ITreeRefreshListener)iter.next()).treeChanged();
        }
    }

    private void updateButtons() {
        ResultSetColumnModel model;
        int selectedIndex;
        boolean deleteEnabled = false;
        boolean downEnabled = false;
        boolean upEnabled = false;
        if (!this.columnTable.getSelection().isEmpty() && (selectedIndex = this.columnList.indexOf(model = this.getSelectedColumn())) != -1) {
            upEnabled = selectedIndex != 0;
            downEnabled = selectedIndex != this.columnList.size() - 1;
            deleteEnabled = true;
        }
        this.up.setEnabled(upEnabled);
        this.down.setEnabled(downEnabled);
        this.delete.setEnabled(deleteEnabled);
    }

    void initAccessible() {
        this.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getHelp(AccessibleEvent e) {
                e.result = ResultSetColumnPage.this.getToolTipText();
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point testPoint = ResultSetColumnPage.this.toControl(new Point(e.x, e.y));
                if (ResultSetColumnPage.this.getBounds().contains(testPoint)) {
                    e.childID = -1;
                }
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = ResultSetColumnPage.this.getBounds();
                Point pt = ResultSetColumnPage.this.toDisplay(new Point(location.x, location.y));
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 46;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0;
            }
        });
    }

    private static class ResultSetColumnModel {
        private String columnName;
        private String alias;
        private int dataType = 0;
        private String displayName;
        private String helpText;

        private ResultSetColumnModel() {
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ResultSetColumnModel) {
                ResultSetColumnModel model = (ResultSetColumnModel)obj;
                if (this.columnName == null) {
                    return model.columnName == null;
                }
                return this.columnName.equals(model.columnName);
            }
            return false;
        }
    }

    public static interface ITreeRefreshListener {
        public void treeChanged();
    }
}

