/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetViewData;
import org.eclipse.birt.report.designer.data.ui.util.DataSetProvider;
import org.eclipse.birt.report.designer.data.ui.util.Utility;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;

public class DataSetExpressionProvider
extends ExpressionProvider {
    public static final String DATASETS = Messages.getString((String)"ExpressionProvider.Category.DataSets");
    private List dataSetList = new ArrayList();

    public DataSetExpressionProvider(DesignElementHandle handle) {
        super(handle);
        this.dataSetList.add(handle);
    }

    protected List getCategoryList() {
        List categoryList = super.getCategoryList();
        if (this.dataSetList != null && !this.dataSetList.isEmpty()) {
            categoryList.add(0, DATASETS);
        }
        return categoryList;
    }

    protected List getChildrenList(Object parent) {
        if (DATASETS.equals(parent)) {
            return this.dataSetList;
        }
        if (parent instanceof DataSetHandle) {
            ArrayList<DataSetViewData> list = new ArrayList<DataSetViewData>();
            list.addAll(Arrays.asList(DataSetProvider.getCurrentInstance().getColumns((DataSetHandle)parent, false)));
            return list;
        }
        return super.getChildrenList(parent);
    }

    public String getDisplayText(Object element) {
        if (element instanceof DataSetHandle) {
            return ((DataSetHandle)element).getName();
        }
        if (element instanceof DataSetViewData) {
            return ((DataSetViewData)element).getDisplayName();
        }
        return super.getDisplayText(element);
    }

    public String getInsertText(Object element) {
        if (element instanceof DataSetViewData) {
            return Utility.getExpression(element);
        }
        return super.getInsertText(element);
    }
}

