/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetViewData;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.ScriptDataSetHandle;
import org.eclipse.birt.report.model.api.ScriptDataSourceHandle;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class Utility {
    private static final String BINDING_COLUMN_PREFIX = "row";

    public static ImageDescriptor getImageDescriptor(String imageDescriptor) {
        return ReportPlatformUIImages.getImageDescriptor(imageDescriptor);
    }

    public static ModuleHandle getReportModuleHandle() {
        return HandleAdapterFactory.getInstance().getReportDesignHandleAdapter().getModuleHandle();
    }

    public static CommandStack getCommandStack() {
        return SessionHandleAdapter.getInstance().getCommandStack();
    }

    public static String getUniqueDataSetName(String baseName) {
        String finalName = baseName;
        int n = 1;
        while (HandleAdapterFactory.getInstance().getReportDesignHandleAdapter().checkDataSetName(finalName)) {
            finalName = baseName + n++;
        }
        return finalName;
    }

    public static String getUniqueDataSourceName(String baseName) {
        String finalName = baseName;
        int n = 1;
        while (HandleAdapterFactory.getInstance().getReportDesignHandleAdapter().checkDataSourceName(finalName)) {
            finalName = baseName + n++;
        }
        return finalName;
    }

    public static boolean checkDataSourceName(String name) {
        return HandleAdapterFactory.getInstance().getReportDesignHandleAdapter().checkDataSourceName(name);
    }

    public static boolean checkDataSetName(String name) {
        return HandleAdapterFactory.getInstance().getReportDesignHandleAdapter().checkDataSetName(name);
    }

    public static List getVisibleDataSources() {
        return Utility.getReportModuleHandle().getVisibleDataSources();
    }

    public static List getDataSources() {
        return Utility.getReportModuleHandle().getDataSources().getContents();
    }

    public static List getVisibleDataSets() {
        return Utility.getReportModuleHandle().getVisibleDataSets();
    }

    public static DesignElementFactory getDesignElementFactory() {
        DesignElementFactory factory = DesignElementFactory.getInstance(HandleAdapterFactory.getInstance().getReportDesignHandleAdapter().getModuleHandle().getDataSets().getElementHandle().getModuleHandle());
        return factory;
    }

    public static OdaDataSetHandle newOdaDataSet(String name, String type) {
        return Utility.getDesignElementFactory().newOdaDataSet(name, type);
    }

    public static JointDataSetHandle newJointDataSet(String name) {
        return Utility.getDesignElementFactory().newJointDataSet(name);
    }

    public static ScriptDataSetHandle newScriptDataSet(String name) {
        return Utility.getDesignElementFactory().newScriptDataSet(name);
    }

    public static OdaDataSourceHandle newOdaDataSource(String name, String type) {
        return Utility.getDesignElementFactory().newOdaDataSource(name, type);
    }

    public static ScriptDataSourceHandle newScriptDataSource(String name) {
        return Utility.getDesignElementFactory().newScriptDataSource(name);
    }

    public static void setScriptActivityEditor() {
        if (UIUtil.getActiveReportEditor().findPage("report.script") != null) {
            UIUtil.getActiveReportEditor().setActivePage("report.script");
        }
    }

    public static Object getProperty(Object obj, String propertyName) throws IntrospectionException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method;
        Object value = null;
        PropertyDescriptor descriptor = Utility.getPropertyDescriptor(obj, propertyName);
        if (descriptor != null && (method = descriptor.getReadMethod()) != null) {
            value = method.invoke(obj, null);
        }
        return value;
    }

    public static void setProperty(Object obj, String propertyName, Object value) throws IntrospectionException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method;
        PropertyDescriptor descriptor = Utility.getPropertyDescriptor(obj, propertyName);
        if (descriptor != null && (method = descriptor.getWriteMethod()) != null) {
            method.invoke(obj, value);
        }
    }

    private static PropertyDescriptor getPropertyDescriptor(Object obj, String propertyName) throws IntrospectionException {
        PropertyDescriptor[] descriptors = Utility.getPropertyDescriptors(obj);
        for (int n = 0; n < descriptors.length; ++n) {
            if (!descriptors[n].getName().equals(propertyName)) continue;
            return descriptors[n];
        }
        return null;
    }

    private static PropertyDescriptor[] getPropertyDescriptors(Object obj) throws IntrospectionException {
        BeanInfo info = Introspector.getBeanInfo(obj.getClass());
        return info.getPropertyDescriptors();
    }

    public static String convertToGUIString(String string) {
        if (string == null) {
            string = "";
        }
        return string;
    }

    public static String convertToModelString(String string, boolean trim) {
        if (string == null) {
            return null;
        }
        if (trim) {
            string = string.trim();
        }
        if (string.length() == 0) {
            string = null;
        }
        return string;
    }

    public static GridLayout createGridLayoutWithoutMargin() {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        return layout;
    }

    public static String getExpression(Object element) {
        if (element instanceof DataSetViewData) {
            String colName = ((DataSetViewData)element).getAlias();
            if (colName == null || colName.trim().length() == 0) {
                colName = ((DataSetViewData)element).getName();
            }
            return Utility.getColumnExpression(colName);
        }
        return null;
    }

    public static String getColumnExpression(String columnName) {
        Assert.isNotNull((Object)columnName);
        if (StringUtil.isBlank((String)columnName)) {
            return null;
        }
        return "row[\"" + Utility.escape(columnName) + "\"]";
    }

    public static String escape(String str) {
        String[][] chars = new String[][]{{"\\\\", "\"", "'"}, {"\\\\\\\\", "\\\\\"", "\\\\'"}};
        String result = str;
        for (int i = 0; i < chars[0].length; ++i) {
            result = result.replaceAll(chars[0][i], chars[1][i]);
        }
        return result;
    }

    public static void setSystemHelp(Control control, String contextId) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(control, contextId);
    }

    public static void log(Exception e) {
        ILog log = new ReportPlugin().getLog();
        log.log((IStatus)new Status(4, "org.eclipse.ui", 0, e.getMessage(), (Throwable)e));
    }
}

