/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetUIUtil;
import org.eclipse.birt.report.designer.internal.ui.dialogs.ExpressionFilter;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CachedMetaDataHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IArgumentInfo;
import org.eclipse.birt.report.model.api.metadata.IArgumentInfoList;
import org.eclipse.birt.report.model.api.metadata.IClassInfo;
import org.eclipse.birt.report.model.api.metadata.ILocalizableInfo;
import org.eclipse.birt.report.model.api.metadata.IMemberInfo;
import org.eclipse.birt.report.model.api.metadata.IMethodInfo;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class ExpressionTreeSupport
implements ISelectionChangedListener {
    private static final Image IMAGE_FOLDER = ReportPlatformUIImages.getImage("IMG_OBJ_FOLDER");
    private static final Image IMAGE_OPERATOR = ExpressionTreeSupport.getIconImage("Operator");
    private static final Image IMAGE_COLUMN = ExpressionTreeSupport.getIconImage("DataColumn");
    private static final Image IMAGE_GOLBAL = ExpressionTreeSupport.getIconImage("Global");
    private static final Image IMAGE_METHOD = ExpressionTreeSupport.getIconImage("Method");
    private static final Image IMAGE_STATIC_METHOD = ExpressionTreeSupport.getIconImage("Static Method");
    private static final Image IMAGE_MEMBER = ExpressionTreeSupport.getIconImage("Member");
    private static final Image IMAGE_STATIC_MEMBER = ExpressionTreeSupport.getIconImage("Static Member");
    private static final String[][] OPERATORS_ASSIGNMENT = new String[][]{{"=", Messages.getString((String)"ExpressionProvider.Operator.Assign")}, {"+=", Messages.getString((String)"ExpressionProvider.Operator.AddTo")}, {"-=", Messages.getString((String)"ExpressionProvider.Operator.SubFrom")}, {"*=", Messages.getString((String)"ExpressionProvider.Operator.MultTo")}, {"/=", Messages.getString((String)"ExpressionProvider.Operator.DividingFrom")}};
    private static final String[][] OPERATORS_COMPARISON = new String[][]{{"==", Messages.getString((String)"ExpressionProvider.Operator.Equals")}, {"<", Messages.getString((String)"ExpressionProvider.Operator.Less")}, {"<=", Messages.getString((String)"ExpressionProvider.Operator.LessEqual")}, {"!=", Messages.getString((String)"ExpressionProvider.Operator.NotEqual")}, {">", Messages.getString((String)"ExpressionProvider.Operator.Greater")}, {">=", Messages.getString((String)"ExpressionProvider.Operator.GreaterEquals")}};
    private static final String[][] OPERATORS_COMPUTATIONAL = new String[][]{{"+", Messages.getString((String)"ExpressionProvider.Operator.Add")}, {"-", Messages.getString((String)"ExpressionProvider.Operator.Sub")}, {"*", Messages.getString((String)"ExpressionProvider.Operator.Mult")}, {"/", Messages.getString((String)"ExpressionProvider.Operator.Divides")}, {"++X ", Messages.getString((String)"ExpressionProvider.Operator.Inc")}, {"X++ ", Messages.getString((String)"ExpressionProvider.Operator.ReturnInc")}, {"--X ", Messages.getString((String)"ExpressionProvider.Operator.Dec")}, {"X-- ", Messages.getString((String)"ExpressionProvider.Operator.ReturnDec")}};
    private static final String[][] OPERATORS_LOGICAL = new String[][]{{"&&", Messages.getString((String)"ExpressionProvider.Operator.And")}, {"||", Messages.getString((String)"ExpressionProvider.Operator.Or")}};
    private static final String TREE_ITEM_CONTEXT = Messages.getString((String)"ExpressionProvider.Category.Context");
    private static final String TREE_ITEM_OPERATORS = Messages.getString((String)"ExpressionProvider.Category.Operators");
    private static final String TREE_ITEM_BIRT_OBJECTS = Messages.getString((String)"ExpressionProvider.Category.BirtObjects");
    private static final String TREE_ITEM_DATASETS = Messages.getString((String)"ExpressionProvider.Category.DataSets");
    private static final String TREE_ITEM_PARAMETERS = Messages.getString((String)"ExpressionProvider.Category.Parameters");
    private static final String TREE_ITEM_NATIVE_OBJECTS = Messages.getString((String)"ExpressionProvider.Category.NativeObjects");
    private static final String TREE_ITEM_LOGICAL = Messages.getString((String)"ExpressionProvider.Operators.Logical");
    private static final String TREE_ITEM_COMPUTATIONAL = Messages.getString((String)"ExpressionProvider.Operators.Computational");
    private static final String TREE_ITEM_COMPARISON = Messages.getString((String)"ExpressionProvider.Operators.Comparison");
    private static final String TREE_ITEM_ASSIGNMENT = Messages.getString((String)"ExpressionProvider.Operators.Assignment");
    protected static final String ITEM_DATA_KEY_TOOLTIP = "TOOL_TIP";
    protected static final String ITEM_DATA_KEY_TEXT = "TEXT";
    protected static final String ITEM_DATA_KEY_ENABLED = "ENABLED";
    private static final String OBJECTS_TYPE_NATIVE = "native";
    private static final String OBJECTS_TYPE_BIRT = "birt";
    private SourceViewer expressionViewer;
    private Tree tree;
    private DropTarget dropTarget;
    public static final String TREE_NAME_OPERATORS = "Operators";
    public static final String TREE_NAME_NATIVE_OBJECTS = "Native Objects";
    public static final String TREE_NAME_BIRT_OBJECTS = "Birt Objects";
    public static final String TREE_NAME_DATASETS = "DataSets";
    public static final String TREE_NAME_PARAMETERS = "Parameters";
    public static final String TREE_NAME_CONTEXT = "Context";
    private Object currentEditObject;
    private String currentMethodName;
    private TreeItem contextItem;

    public void createDefaultExpressionTree(List dataSetList) {
        this.createFilteredExpressionTree(dataSetList, null);
    }

    public void createFilteredExpressionTree(List dataSetList, List filterList) {
        if (this.filter(TREE_NAME_CONTEXT, filterList)) {
            this.createContextCatagory();
        }
        if (this.filter(TREE_NAME_PARAMETERS, filterList)) {
            this.createParamtersTree();
        }
        if (this.filter(TREE_NAME_NATIVE_OBJECTS, filterList)) {
            this.createNativeObjectsTree();
        }
        if (this.filter(TREE_NAME_BIRT_OBJECTS, filterList)) {
            this.createBirtObjectsTree();
        }
        if (this.filter(TREE_NAME_OPERATORS, filterList)) {
            this.createOperatorsTree();
        }
    }

    private boolean filter(String treeName, List filters) {
        if (filters == null) {
            return true;
        }
        Iterator iter = filters.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof ExpressionFilter) || ((ExpressionFilter)obj).select(this, treeName)) continue;
            return false;
        }
        return true;
    }

    public void createOperatorsTree() {
        Assert.isNotNull((Object)this.tree);
        TreeItem topItem = this.createTopTreeItem(this.tree, TREE_ITEM_OPERATORS);
        TreeItem subItem = this.createSubFolderItem(topItem, TREE_ITEM_ASSIGNMENT);
        this.createSubTreeItems(subItem, OPERATORS_ASSIGNMENT, IMAGE_OPERATOR);
        subItem = this.createSubFolderItem(topItem, TREE_ITEM_COMPARISON);
        this.createSubTreeItems(subItem, OPERATORS_COMPARISON, IMAGE_OPERATOR);
        subItem = this.createSubFolderItem(topItem, TREE_ITEM_COMPUTATIONAL);
        this.createSubTreeItems(subItem, OPERATORS_COMPUTATIONAL, IMAGE_OPERATOR);
        subItem = this.createSubFolderItem(topItem, TREE_ITEM_LOGICAL);
        this.createSubTreeItems(subItem, OPERATORS_LOGICAL, IMAGE_OPERATOR);
    }

    public void createNativeObjectsTree() {
        Assert.isNotNull((Object)this.tree);
        TreeItem topItem = this.createTopTreeItem(this.tree, TREE_ITEM_NATIVE_OBJECTS);
        this.createObjects(topItem, OBJECTS_TYPE_NATIVE);
    }

    public void createParamtersTree() {
        Assert.isNotNull((Object)this.tree);
        TreeItem topItem = this.createTopTreeItem(this.tree, TREE_ITEM_PARAMETERS);
        Iterator iterator = SessionHandleAdapter.getInstance().getReportDesignHandle().getAllParameters().iterator();
        while (iterator.hasNext()) {
            ReportElementHandle handle = (ReportElementHandle)iterator.next();
            if (handle instanceof ParameterHandle) {
                this.createSubTreeItem(topItem, DEUtil.getDisplayLabel((Object)handle, (boolean)false), ReportPlatformUIImages.getImage(handle), DEUtil.getExpression((Object)handle), ((ParameterHandle)handle).getHelpText(), true);
                continue;
            }
            if (!(handle instanceof ParameterGroupHandle)) continue;
            TreeItem groupItem = this.createSubTreeItem(topItem, DEUtil.getDisplayLabel((Object)handle, (boolean)false), ReportPlatformUIImages.getImage(handle), true);
            Iterator itor = ((ParameterGroupHandle)handle).getParameters().iterator();
            while (itor.hasNext()) {
                ParameterHandle parameter = (ParameterHandle)itor.next();
                this.createSubTreeItem(groupItem, parameter.getDisplayLabel(), ReportPlatformUIImages.getImage(handle), DEUtil.getExpression((Object)parameter), parameter.getDisplayLabel(), true);
            }
        }
    }

    public void createDataSetsTree(List dataSetList) {
        Assert.isNotNull((Object)this.tree);
        TreeItem topItem = this.createTopTreeItem(this.tree, TREE_ITEM_DATASETS);
        Iterator iterator = dataSetList.iterator();
        while (iterator.hasNext()) {
            DataSetHandle handle = (DataSetHandle)iterator.next();
            TreeItem dataSetItem = this.createSubTreeItem(topItem, DEUtil.getDisplayLabel((Object)handle, (boolean)false), ReportPlatformUIImages.getImage(handle), true);
            try {
                CachedMetaDataHandle cachedMetadata = DataSetUIUtil.getCachedMetaDataHandle(handle);
                Iterator iter = cachedMetadata.getResultSet().iterator();
                while (iter.hasNext()) {
                    ResultSetColumnHandle element = (ResultSetColumnHandle)iter.next();
                    this.createSubTreeItem(dataSetItem, element.getColumnName(), IMAGE_COLUMN, DEUtil.getExpression((Object)element), element.getColumnName(), true);
                }
            }
            catch (SemanticException e) {
            }
        }
    }

    public void createBirtObjectsTree() {
        Assert.isNotNull((Object)this.tree);
        TreeItem topItem = this.createTopTreeItem(this.tree, TREE_ITEM_BIRT_OBJECTS);
        this.createObjects(topItem, OBJECTS_TYPE_BIRT);
    }

    private TreeItem createTopTreeItem(Tree parent, String text) {
        TreeItem item = new TreeItem(parent, 0);
        item.setText(text);
        item.setImage(IMAGE_FOLDER);
        item.setData(ITEM_DATA_KEY_TOOLTIP, (Object)"");
        return item;
    }

    private TreeItem createSubTreeItem(TreeItem parent, String text, Image image, boolean isEnabled) {
        return this.createSubTreeItem(parent, text, image, null, text, isEnabled);
    }

    private TreeItem createSubTreeItem(TreeItem parent, String text, Image image, String textData, String toolTip, boolean isEnabled) {
        TreeItem item = new TreeItem(parent, 0);
        item.setText(text);
        if (image != null) {
            item.setImage(image);
        }
        item.setData(ITEM_DATA_KEY_TOOLTIP, (Object)toolTip);
        item.setData(ITEM_DATA_KEY_TEXT, (Object)textData);
        item.setData(ITEM_DATA_KEY_ENABLED, (Object)new Boolean(isEnabled));
        return item;
    }

    private TreeItem createSubFolderItem(TreeItem parent, String text) {
        return this.createSubTreeItem(parent, text, IMAGE_FOLDER, true);
    }

    private TreeItem createSubFolderItem(TreeItem parent, IClassInfo classInfo) {
        return this.createSubTreeItem(parent, classInfo.getDisplayName(), IMAGE_FOLDER, null, classInfo.getToolTip(), true);
    }

    private void createSubTreeItems(TreeItem parent, String[][] texts, Image image) {
        for (int i = 0; i < texts.length; ++i) {
            this.createSubTreeItem(parent, texts[i][0], image, texts[i][0], texts[i][1], true);
        }
    }

    public void addMouseTrackListener() {
        Assert.isNotNull((Object)this.tree);
        this.tree.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent event) {
                Widget widget = event.widget;
                if (widget == ExpressionTreeSupport.this.tree) {
                    Point pt = new Point(event.x, event.y);
                    TreeItem item = ExpressionTreeSupport.this.tree.getItem(pt);
                    if (item == null) {
                        ExpressionTreeSupport.this.tree.setToolTipText("");
                    } else {
                        String text = (String)item.getData(ExpressionTreeSupport.ITEM_DATA_KEY_TOOLTIP);
                        ExpressionTreeSupport.this.tree.setToolTipText(text);
                    }
                }
            }
        });
    }

    public void addMouseListener() {
        Assert.isNotNull((Object)this.tree);
        this.tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                TreeItem[] selection = ExpressionTreeSupport.this.getTreeSelection();
                if (selection == null || selection.length <= 0) {
                    return;
                }
                TreeItem item = selection[0];
                if (item != null) {
                    Object obj = item.getData(ExpressionTreeSupport.ITEM_DATA_KEY_TEXT);
                    Boolean isEnabled = (Boolean)item.getData(ExpressionTreeSupport.ITEM_DATA_KEY_ENABLED);
                    if (obj != null && isEnabled.booleanValue()) {
                        String text = (String)obj;
                        ExpressionTreeSupport.this.insertText(text);
                    }
                }
            }
        });
    }

    protected TreeItem[] getTreeSelection() {
        return this.tree.getSelection();
    }

    public void addDragSupportToTree() {
        Assert.isNotNull((Object)this.tree);
        DragSource dragSource = new DragSource((Control)this.tree, 1);
        dragSource.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        dragSource.addDragListener((DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                TreeItem[] selection = ExpressionTreeSupport.this.tree.getSelection();
                if (selection.length <= 0 || selection[0].getData(ExpressionTreeSupport.ITEM_DATA_KEY_TEXT) == null || !((Boolean)selection[0].getData(ExpressionTreeSupport.ITEM_DATA_KEY_ENABLED)).booleanValue()) {
                    event.doit = false;
                    return;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                TreeItem[] selection;
                if (TextTransfer.getInstance().isSupportedType(event.dataType) && (selection = ExpressionTreeSupport.this.tree.getSelection()).length > 0) {
                    event.data = selection[0].getData(ExpressionTreeSupport.ITEM_DATA_KEY_TEXT);
                }
            }
        });
    }

    protected void insertText(String text) {
        StyledText textWidget = this.expressionViewer.getTextWidget();
        if (!textWidget.isEnabled()) {
            return;
        }
        int selectionStart = textWidget.getSelection().x;
        if (text.equalsIgnoreCase("x++")) {
            text = textWidget.getSelectionText() + "++";
        } else if (text.equalsIgnoreCase("x--")) {
            text = textWidget.getSelectionText() + "--";
        } else if (text.equalsIgnoreCase("++x")) {
            text = "++" + textWidget.getSelectionText();
        } else if (text.equalsIgnoreCase("--x")) {
            text = "--" + textWidget.getSelectionText();
        }
        textWidget.insert(text);
        textWidget.setSelection(selectionStart + text.length());
        textWidget.setFocus();
        if (text.endsWith("()")) {
            textWidget.setCaretOffset(textWidget.getCaretOffset() - 1);
        }
    }

    public void addDropSupportToViewer() {
        Assert.isNotNull((Object)this.expressionViewer);
        final StyledText text = this.expressionViewer.getTextWidget();
        this.dropTarget = new DropTarget((Control)text, 17);
        this.dropTarget.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        this.dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                text.setFocus();
                if (event.detail == 16) {
                    event.detail = 1;
                }
                if (event.detail != 1) {
                    event.detail = 0;
                }
            }

            public void dragOver(DropTargetEvent event) {
                event.feedback = 10;
            }

            public void dragOperationChanged(DropTargetEvent event) {
                this.dragEnter(event);
            }

            public void drop(DropTargetEvent event) {
                if (event.data instanceof String) {
                    ExpressionTreeSupport.this.insertText((String)event.data);
                }
            }
        });
    }

    public void dispose() {
        if (this.dropTarget != null && !this.dropTarget.isDisposed()) {
            this.dropTarget.dispose();
        }
    }

    public void setTree(Tree tree) {
        this.tree = tree;
    }

    protected Tree getTree() {
        return this.tree;
    }

    public void setExpressionViewer(SourceViewer expressionViewer) {
        this.expressionViewer = expressionViewer;
    }

    protected SourceViewer getExpressionViewer() {
        return this.expressionViewer;
    }

    private static Image getIconImage(String id) {
        return ReportPlatformUIImages.getImage(id);
    }

    private void createObjects(TreeItem topItem, String objectType) {
        Iterator itor = DesignEngine.getMetaDataDictionary().getClasses().iterator();
        while (itor.hasNext()) {
            IClassInfo classInfo = (IClassInfo)itor.next();
            if (classInfo.isNative() && OBJECTS_TYPE_BIRT.equals(objectType) || !classInfo.isNative() && OBJECTS_TYPE_NATIVE.equals(objectType)) continue;
            TreeItem subItem = this.createSubFolderItem(topItem, classInfo);
            Image globalImage = null;
            if (this.isGlobal(classInfo.getName())) {
                globalImage = IMAGE_GOLBAL;
            }
            Iterator iterator = classInfo.getMembers().iterator();
            while (iterator.hasNext()) {
                IMemberInfo memberInfo = (IMemberInfo)iterator.next();
                Image image = globalImage;
                if (image == null) {
                    image = memberInfo.isStatic() ? IMAGE_STATIC_MEMBER : IMAGE_MEMBER;
                }
                this.createSubTreeItem(subItem, memberInfo.getDisplayName(), image, this.getMemberTextData(classInfo.getName(), (ILocalizableInfo)memberInfo), memberInfo.getToolTip(), true);
            }
            ArrayList<IMethodInfo> methodList = new ArrayList<IMethodInfo>();
            methodList.add(classInfo.getConstructor());
            methodList.addAll(classInfo.getMethods());
            Iterator iterator2 = methodList.iterator();
            while (iterator2.hasNext()) {
                IMethodInfo methodInfo = (IMethodInfo)iterator2.next();
                if (methodInfo == null) continue;
                Image image = globalImage;
                if (image == null) {
                    image = methodInfo.isStatic() ? IMAGE_STATIC_METHOD : IMAGE_METHOD;
                }
                List displayList = this.getMethodArgumentsList(classInfo.getName(), methodInfo);
                for (int i = 0; i < displayList.size(); ++i) {
                    String[] array = (String[])displayList.get(i);
                    this.createSubTreeItem(subItem, array[0], image, array[1], methodInfo.getToolTip(), true);
                }
            }
        }
    }

    private boolean isGlobal(String name) {
        return name != null && name.startsWith("Global");
    }

    private List getMethodArgumentsList(String className, IMethodInfo info) {
        ArrayList<String[]> list = new ArrayList<String[]>();
        boolean isClassNameAdded = !this.isGlobal(className) && this.isStatic((ILocalizableInfo)info);
        String methodStart = info.isConstructor() ? "new " : "";
        Iterator it = info.argumentListIterator();
        while (it.hasNext()) {
            String[] array = new String[2];
            StringBuffer displayText = new StringBuffer(methodStart);
            displayText.append(info.getDisplayName());
            displayText.append("(");
            StringBuffer expression = new StringBuffer(methodStart);
            if (isClassNameAdded) {
                expression.append(className + ".");
            }
            expression.append(info.getName());
            expression.append("(");
            IArgumentInfoList arguments = (IArgumentInfoList)it.next();
            boolean firstTime = true;
            Iterator iterator = arguments.argumentsIterator();
            while (iterator.hasNext()) {
                IArgumentInfo argument = (IArgumentInfo)iterator.next();
                if (!firstTime) {
                    displayText.append(", ");
                }
                firstTime = false;
                displayText.append("optionalArgument".equals(argument.getName()) ? argument.getDisplayName() : argument.getType() + " " + argument.getDisplayName());
            }
            displayText.append(")");
            expression.append(")");
            array[0] = displayText.toString();
            array[1] = expression.toString();
            list.add(array);
        }
        return list;
    }

    private String getMemberTextData(String className, ILocalizableInfo info) {
        StringBuffer textData = new StringBuffer();
        if (!this.isGlobal(className) && this.isStatic(info)) {
            textData.append(className + ".");
        }
        textData.append(info.getName());
        return textData.toString();
    }

    private boolean isStatic(ILocalizableInfo info) {
        return info instanceof IMethodInfo && ((IMethodInfo)info).isStatic() || info instanceof IMemberInfo && ((IMemberInfo)info).isStatic();
    }

    public void createContextCatagory() {
        Assert.isNotNull((Object)this.tree);
        this.contextItem = this.createTopTreeItem(this.tree, TREE_ITEM_CONTEXT);
        this.createContextObjects(this.currentMethodName);
    }

    public void createContextObjects(String methodName) {
        if (this.contextItem != null && !this.contextItem.isDisposed() && this.currentEditObject != null && methodName != null) {
            this.removeTreeItem();
            DesignElementHandle handle = (DesignElementHandle)this.currentEditObject;
            Map argMap = DEUtil.getDesignElementMethodArguments((DesignElementHandle)handle, (String)methodName);
            Iterator iter = argMap.keySet().iterator();
            while (iter.hasNext()) {
                String argName = (String)iter.next();
                this.createSubTreeItem(this.contextItem, argName, IMAGE_METHOD, argName, "", true);
            }
        }
    }

    public void setCurrentEditObject(Object obj) {
        this.currentEditObject = obj;
        this.removeTreeItem();
    }

    private void removeTreeItem() {
        if (this.contextItem == null || this.contextItem.isDisposed()) {
            return;
        }
        TreeItem[] items = this.contextItem.getItems();
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null || items[i].isDisposed()) continue;
            items[i].dispose();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object[] sel;
        ISelection selection = event.getSelection();
        if (selection != null && (sel = ((IStructuredSelection)selection).toArray()).length == 1 && sel[0] instanceof IPropertyDefn) {
            IPropertyDefn elePropDefn = (IPropertyDefn)sel[0];
            this.currentMethodName = elePropDefn.getName();
            this.createContextObjects(this.currentMethodName);
        }
    }
}

