/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs.js;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.internal.ui.dialogs.js.JSObjectMetaData;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.metadata.IArgumentInfo;
import org.eclipse.birt.report.model.api.metadata.IArgumentInfoList;
import org.eclipse.birt.report.model.api.metadata.IClassInfo;
import org.eclipse.birt.report.model.api.metadata.IMemberInfo;
import org.eclipse.birt.report.model.api.metadata.IMethodInfo;

public class JSSyntaxContext {
    private static Map engineObjectMap = new HashMap();
    private static Map classMap = new HashMap();
    private Map objectMetaMap = new HashMap();
    private static JSObjectMetaData.JSMethod[] noMthods = new JSObjectMetaData.JSMethod[0];
    private static JSObjectMetaData.JSField[] noFields = new JSObjectMetaData.JSField[0];

    public static JSObjectMetaData getEnginJSObject(String classType) {
        return engineObjectMap.containsKey(classType) ? (JSObjectMetaData)engineObjectMap.get(classType) : null;
    }

    public static JSObjectMetaData[] getAllEnginJSObjects() {
        return engineObjectMap.values().toArray(new JSObjectMetaData[engineObjectMap.values().size()]);
    }

    public static JSObjectMetaData getJavaClassMeta(String className) throws ClassNotFoundException {
        JSObjectMetaData meta = null;
        if (!classMap.containsKey(className)) {
            meta = new JavaClassJSObject(className);
            classMap.put(className, meta);
        } else {
            meta = (JSObjectMetaData)classMap.get(className);
        }
        return meta;
    }

    public void setVariable(String name, String className) {
        try {
            this.objectMetaMap.put(name, JSSyntaxContext.getJavaClassMeta(className));
        }
        catch (Exception e) {
            if (JSSyntaxContext.getEnginJSObject(className) != null) {
                this.objectMetaMap.put(name, JSSyntaxContext.getEnginJSObject(className));
            }
            this.removeVariable(name);
        }
    }

    public void setVariable(String name, Class clazz) throws ClassNotFoundException {
        this.objectMetaMap.put(name, new JavaClassJSObject(clazz.getName()));
    }

    public void removeVariable(String name) {
        this.objectMetaMap.remove(name);
    }

    public void clear() {
        this.objectMetaMap.clear();
    }

    public JSObjectMetaData getVariableMeta(String variableName) {
        if (this.objectMetaMap.containsKey(variableName)) {
            return (JSObjectMetaData)this.objectMetaMap.get(variableName);
        }
        return JSSyntaxContext.getEnginJSObject(variableName);
    }

    static {
        List engineClassesList = DesignEngine.getMetaDataDictionary().getClasses();
        Iterator iter = engineClassesList.iterator();
        while (iter.hasNext()) {
            IClassInfo element = (IClassInfo)iter.next();
            engineObjectMap.put(element.getName(), new EnginClassJSObject(element));
        }
    }

    private static class EnginClassJSObject
    implements JSObjectMetaData {
        private IClassInfo classInfo;
        private boolean showPublic;

        public EnginClassJSObject(IClassInfo classInfo) {
            this.classInfo = classInfo;
            this.showPublic = "DataSet".equals(classInfo.getName()) || "DataSource".equals(classInfo.getName());
        }

        public String getName() {
            if (this.classInfo == null) {
                return "";
            }
            return this.classInfo.getName();
        }

        public JSObjectMetaData.JSMethod[] getMethods() {
            if (this.classInfo == null) {
                return noMthods;
            }
            List methods = this.classInfo.getMethods();
            ArrayList<EngineClassMethod> all = new ArrayList<EngineClassMethod>();
            Iterator iter = methods.iterator();
            while (iter.hasNext()) {
                IMethodInfo method = (IMethodInfo)iter.next();
                if (!this.showPublic && !method.isStatic()) continue;
                all.add(new EngineClassMethod(method));
            }
            Collections.sort(all);
            return all.toArray(new JSObjectMetaData.JSMethod[all.size()]);
        }

        public JSObjectMetaData.JSField[] getFields() {
            if (this.classInfo == null) {
                return noFields;
            }
            List members = this.classInfo.getMembers();
            ArrayList<EngineClassField> all = new ArrayList<EngineClassField>();
            Iterator iter = members.iterator();
            while (iter.hasNext()) {
                IMemberInfo member = (IMemberInfo)iter.next();
                if (!this.showPublic && !member.isStatic()) continue;
                all.add(new EngineClassField(member));
            }
            Collections.sort(all);
            return all.toArray(new JSObjectMetaData.JSField[all.size()]);
        }

        public String getDescription() {
            return null;
        }

        public int getVisibility() {
            return 0;
        }

        private class EngineClassField
        implements JSObjectMetaData.JSField,
        Comparable {
            private IMemberInfo member;
            private String displayText;

            public EngineClassField(IMemberInfo member) {
                this.member = member;
            }

            public String getName() {
                return this.member.getDisplayName();
            }

            public JSObjectMetaData getType() {
                JSObjectMetaData meta = JSSyntaxContext.getEnginJSObject(this.member.getDataType());
                if (meta == null) {
                    try {
                        return JSSyntaxContext.getJavaClassMeta(this.member.getDataType());
                    }
                    catch (ClassNotFoundException e) {
                        return null;
                    }
                }
                return meta;
            }

            public String getDisplayText() {
                if (this.displayText == null) {
                    StringBuffer strbuf = new StringBuffer(this.getName());
                    strbuf.append(" ");
                    strbuf.append(EnginClassJSObject.this.classInfo.getName());
                    this.displayText = strbuf.toString();
                    Object var1_1 = null;
                }
                return this.displayText;
            }

            public String getDescription() {
                return null;
            }

            public int getVisibility() {
                return 0;
            }

            public int compareTo(Object obj) {
                if (obj instanceof EngineClassField && ((EngineClassField)obj).getName() != null) {
                    return this.getName().compareToIgnoreCase(((EngineClassField)obj).getName());
                }
                return 0;
            }
        }

        private class EngineClassMethod
        implements JSObjectMetaData.JSMethod,
        Comparable {
            private IMethodInfo method;
            private String displayText;

            public EngineClassMethod(IMethodInfo method) {
                this.method = method;
            }

            public String getName() {
                return this.method.getDisplayName();
            }

            public JSObjectMetaData getReturn() {
                JSObjectMetaData meta = JSSyntaxContext.getEnginJSObject(this.method.getReturnType());
                if (meta == null) {
                    try {
                        return JSSyntaxContext.getJavaClassMeta(this.method.getReturnType());
                    }
                    catch (ClassNotFoundException e) {
                        return null;
                    }
                }
                return meta;
            }

            public String getDisplayText() {
                if (this.displayText == null) {
                    StringBuffer strbuf = new StringBuffer(this.getName());
                    strbuf.append("(");
                    Iterator iter = this.method.argumentListIterator();
                    if (iter.hasNext()) {
                        IArgumentInfoList element = (IArgumentInfoList)iter.next();
                        int i = 0;
                        Iterator iterator = element.argumentsIterator();
                        while (iterator.hasNext()) {
                            if (i++ > 0) {
                                strbuf.append(", ");
                            }
                            IArgumentInfo argument = (IArgumentInfo)iterator.next();
                            strbuf.append(argument.getType()).append(" ").append(argument.getName());
                        }
                    }
                    strbuf.append(") ");
                    strbuf.append(EnginClassJSObject.this.classInfo.getName());
                    this.displayText = strbuf.toString();
                    Object var1_1 = null;
                }
                return this.displayText;
            }

            public String getDescription() {
                return null;
            }

            public int getVisibility() {
                if (this.method.isStatic()) {
                    return 3;
                }
                return 0;
            }

            public int compareTo(Object obj) {
                if (obj instanceof EngineClassMethod && ((EngineClassMethod)obj).getName() != null) {
                    return this.getName().compareToIgnoreCase(((EngineClassMethod)obj).getName());
                }
                return 0;
            }
        }
    }

    private static class JavaClassJSObject
    implements JSObjectMetaData {
        private Class clazz;

        JavaClassJSObject(Class clazz) {
            this.clazz = clazz;
        }

        public JavaClassJSObject(String className) throws ClassNotFoundException {
            this.clazz = Class.forName(className);
            if (this.clazz.isArray()) {
                this.clazz = this.clazz.getComponentType();
            }
        }

        public String getName() {
            return this.clazz.getName();
        }

        public JSObjectMetaData.JSMethod[] getMethods() {
            ArrayList jsMehods = new ArrayList();
            jsMehods.addAll(this.getMethods(this.clazz.getMethods()));
            Collections.sort(jsMehods);
            return jsMehods.toArray(new JSObjectMetaData.JSMethod[jsMehods.size()]);
        }

        private List getMethods(Method[] methods) {
            int i;
            ArrayList<JavaClassMethod> jsMehods = new ArrayList<JavaClassMethod>();
            ArrayList<String> setMethodList = new ArrayList<String>();
            ArrayList<String> getMethodList = new ArrayList<String>();
            for (i = 0; i < methods.length; ++i) {
                if (methods[i].getName().startsWith("set") && methods[i].getParameterTypes() != null && methods[i].getParameterTypes().length == 1) {
                    setMethodList.add(methods[i].getName().substring(3));
                    continue;
                }
                if (methods[i].getName().startsWith("get") && methods[i].getParameterTypes() != null && methods[i].getParameterTypes().length == 0) {
                    getMethodList.add(methods[i].getName().substring(3));
                    continue;
                }
                jsMehods.add(new JavaClassMethod(methods[i]));
            }
            for (i = 0; i < methods.length; ++i) {
                if (methods[i].getName().startsWith("set") && methods[i].getParameterTypes() != null && methods[i].getParameterTypes().length == 1) {
                    if (getMethodList.contains(methods[i].getName().substring(3))) continue;
                    jsMehods.add(new JavaClassMethod(methods[i]));
                    continue;
                }
                if (!methods[i].getName().startsWith("get") || methods[i].getParameterTypes() == null || methods[i].getParameterTypes().length != 0 || setMethodList.contains(methods[i].getName().substring(3))) continue;
                jsMehods.add(new JavaClassMethod(methods[i]));
            }
            return jsMehods;
        }

        public JSObjectMetaData.JSField[] getFields() {
            ArrayList jsFields = new ArrayList();
            jsFields.addAll(this.getFields(this.clazz));
            Collections.sort(jsFields);
            return jsFields.toArray(new JSObjectMetaData.JSField[jsFields.size()]);
        }

        private List getFields(Class clazz) {
            String methodName;
            int i;
            Method[] methods = clazz.getMethods();
            ArrayList<JavaClassField> jsFields = new ArrayList<JavaClassField>();
            ArrayList<String> setMethodList = new ArrayList<String>();
            for (i = 0; i < methods.length; ++i) {
                methodName = methods[i].getName();
                if (!methodName.startsWith("set") || methods[i].getParameterTypes() == null || methods[i].getParameterTypes().length != 1) continue;
                setMethodList.add(methodName.substring(3));
            }
            for (i = 0; i < methods.length; ++i) {
                methodName = methods[i].getName();
                if (!methods[i].getName().startsWith("get") || methods[i].getParameterTypes() == null || methods[i].getParameterTypes().length != 0 || !setMethodList.contains(methodName.substring(3))) continue;
                Class<?> type = methods[i].getReturnType();
                JavaClassField field = new JavaClassField(methods[i].getDeclaringClass(), this.getFieldName(methodName), type.getName(), type.isArray());
                if (jsFields.contains(field)) continue;
                jsFields.add(field);
            }
            Field[] fields = clazz.getFields();
            for (int i2 = 0; i2 < fields.length; ++i2) {
                jsFields.add(new JavaClassField(fields[i2]));
            }
            return jsFields;
        }

        private String getFieldName(String methodName) {
            if (methodName.length() == 3) {
                return "";
            }
            if (methodName.length() == 4) {
                return methodName.substring(3, 4).toLowerCase();
            }
            return methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
        }

        public String toString() {
            return this.clazz.getName();
        }

        public String getDescription() {
            return null;
        }

        public int getVisibility() {
            return 0;
        }

        private String getSimpleName(Class clazz) {
            String simpleName = null;
            if (clazz.isArray()) {
                simpleName = clazz.getComponentType().getName();
                if (!clazz.getComponentType().isPrimitive()) {
                    simpleName = simpleName.substring(simpleName.lastIndexOf(".") + 1);
                }
                simpleName = simpleName + "[]";
            } else {
                simpleName = clazz.getName();
                if (!clazz.isPrimitive()) {
                    simpleName = simpleName.substring(simpleName.lastIndexOf(".") + 1);
                }
            }
            return simpleName;
        }

        private Object getSimpleName(String name) {
            return name.substring(name.lastIndexOf(".") + 1);
        }

        private class JavaClassField
        implements JSObjectMetaData.JSField,
        Comparable {
            private String name;
            private JSObjectMetaData type;
            private Field field;
            private Class declareClazz;
            private String displayText;
            private boolean isArray;

            public JavaClassField(Field field) {
                this.field = field;
                this.name = field.getName();
                try {
                    this.type = JSSyntaxContext.getJavaClassMeta(field.getType().getName());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }

            public JavaClassField(Class declareClazz, String name, String type, boolean isArray) {
                this.declareClazz = declareClazz;
                this.name = name;
                try {
                    this.type = JSSyntaxContext.getJavaClassMeta(type);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
                this.isArray = isArray;
            }

            public String getName() {
                return this.name;
            }

            public JSObjectMetaData getType() {
                return this.type;
            }

            public boolean equals(Object obj) {
                if (obj == null || !(obj instanceof JavaClassField) || ((JavaClassField)obj).getName() == null) {
                    return false;
                }
                return ((JavaClassField)obj).getName().equals(this.name);
            }

            public String getDisplayText() {
                if (this.displayText == null) {
                    StringBuffer strbuf = new StringBuffer(this.getName());
                    strbuf.append(" ");
                    if (this.field != null && this.field.getType() != null) {
                        strbuf.append(JavaClassJSObject.this.getSimpleName(this.field.getType()));
                        strbuf.append(" - ");
                    } else if (this.type != null) {
                        strbuf.append(JavaClassJSObject.this.getSimpleName(this.type.getName()));
                        if (this.isArray) {
                            strbuf.append("[]");
                        }
                        strbuf.append(" - ");
                    }
                    if (this.field == null) {
                        strbuf.append(JavaClassJSObject.this.getSimpleName(this.declareClazz));
                    } else {
                        strbuf.append(JavaClassJSObject.this.getSimpleName(this.field.getDeclaringClass()));
                    }
                    this.displayText = strbuf.toString();
                    Object var1_1 = null;
                }
                return this.displayText;
            }

            public String getDescription() {
                return null;
            }

            public int getVisibility() {
                if (this.field == null) {
                    return 0;
                }
                if ((this.field.getModifiers() & 8) != 0) {
                    return 3;
                }
                if ((this.field.getModifiers() & 1) != 0) {
                    return 0;
                }
                if ((this.field.getModifiers() & 2) != 0) {
                    return 2;
                }
                if ((this.field.getModifiers() & 4) != 0) {
                    return 1;
                }
                return 0;
            }

            public int compareTo(Object obj) {
                if (obj instanceof JavaClassField && ((JavaClassField)obj).getName() != null) {
                    if (this.getVisibility() == 3 && ((JavaClassField)obj).getVisibility() == 0) {
                        return 1;
                    }
                    return this.getName().compareToIgnoreCase(((JavaClassField)obj).getName());
                }
                return 0;
            }
        }

        private class JavaClassMethod
        implements JSObjectMetaData.JSMethod,
        Comparable {
            private Method method;
            private String displayText;

            public JavaClassMethod(Method method) {
                this.method = method;
            }

            public String getName() {
                return this.method.getName();
            }

            public JSObjectMetaData getReturn() {
                try {
                    return JSSyntaxContext.getJavaClassMeta(this.method.getReturnType().getName());
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }

            public String getDisplayText() {
                if (this.displayText == null) {
                    StringBuffer strbuf = new StringBuffer(this.getName());
                    strbuf.append("(");
                    Class<?>[] parameters = this.method.getParameterTypes();
                    for (int i = 0; i < parameters.length; ++i) {
                        if (i > 0) {
                            strbuf.append(", ");
                        }
                        strbuf.append(JavaClassJSObject.this.getSimpleName(parameters[i])).append(" ").append("arg").append(i + 1);
                    }
                    strbuf.append(") ");
                    strbuf.append(JavaClassJSObject.this.getSimpleName(this.method.getReturnType()));
                    strbuf.append(" - ");
                    strbuf.append(JavaClassJSObject.this.getSimpleName(this.method.getDeclaringClass()));
                    this.displayText = strbuf.toString();
                    Object var1_1 = null;
                }
                return this.displayText;
            }

            public String getDescription() {
                return null;
            }

            public int getVisibility() {
                if ((this.method.getModifiers() & 8) != 0) {
                    return 3;
                }
                if ((this.method.getModifiers() & 1) != 0) {
                    return 0;
                }
                if ((this.method.getModifiers() & 2) != 0) {
                    return 2;
                }
                if ((this.method.getModifiers() & 4) != 0) {
                    return 1;
                }
                return 0;
            }

            public int compareTo(Object obj) {
                if (obj instanceof JavaClassMethod && ((JavaClassMethod)obj).getName() != null) {
                    if (this.getVisibility() == 3 && ((JavaClassMethod)obj).getVisibility() == 0) {
                        return 1;
                    }
                    return this.getName().compareToIgnoreCase(((JavaClassMethod)obj).getName());
                }
                return 0;
            }
        }
    }
}

