/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs.resource;

import java.io.File;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public class ResourceFileFolderSelectionDialog
extends ElementTreeSelectionDialog {
    private File rootFile;

    public ResourceFileFolderSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parent, labelProvider, contentProvider);
        this.setSorter(new FileViewerSorter());
    }

    public void setInput(Object input) {
        this.rootFile = new File(input.toString());
        super.setInput(input);
    }

    public String getPath() {
        Object[] selected = this.getResult();
        if (selected.length > 0 && this.rootFile != null) {
            File file = (File)selected[0];
            return this.rootFile.toURI().relativize(file.toURI()).getPath();
        }
        return null;
    }

    protected Control createDialogArea(Composite parent) {
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.ResourceSelectDialog_ID");
        return super.createDialogArea(parent);
    }

    private static class FileViewerSorter
    extends ViewerSorter {
        private FileViewerSorter() {
        }

        public int category(Object element) {
            if (element instanceof File && !((File)element).isDirectory()) {
                return 1;
            }
            return 0;
        }
    }
}

