/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.notification;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportElementEditPart;

public class DeferredRefreshManager {
    private ArrayList refreshVisualEditParts = new ArrayList();
    private ArrayList refreshChildrenEditParts = new ArrayList();
    private boolean refreshing = false;

    public void refreshEditParts() {
        this.refreshing = true;
        this.refreshChildrenEditParts();
        this.refreshVisualsEditParts();
        this.refreshing = false;
    }

    protected void refreshVisualsEditParts() {
        Iterator iter = this.refreshVisualEditParts.iterator();
        while (iter.hasNext()) {
            ReportElementEditPart part = (ReportElementEditPart)((Object)iter.next());
            if (!part.isActive()) continue;
            part.refreshFigure();
        }
        this.refreshVisualEditParts.clear();
    }

    protected void refreshChildrenEditParts() {
        Object[] iter = this.refreshChildrenEditParts.toArray();
        for (int i = iter.length - 1; i >= 0; --i) {
            ReportElementEditPart part = (ReportElementEditPart)((Object)iter[i]);
            if (!part.isActive()) continue;
            part.refreshChildrenFigures();
        }
        this.refreshChildrenEditParts.clear();
    }

    public void markEditPartForRefreshChildren(ReportElementEditPart part) {
        if (this.refreshing) {
            part.refreshChildrenFigures();
        } else {
            this.markForRefresh(part, this.refreshChildrenEditParts);
            this.markForRefresh(part, this.refreshVisualEditParts);
            List list = part.getChildren();
            for (int i = 0; i < list.size(); ++i) {
                this.markEditPartForRefreshChildren((ReportElementEditPart)((Object)list.get(i)));
            }
        }
    }

    public void markEditPartForRefreshVisuals(ReportElementEditPart part) {
        if (this.refreshing) {
            part.refreshFigure();
        } else {
            this.markForRefresh(part, this.refreshVisualEditParts);
        }
    }

    protected void markForRefresh(ReportElementEditPart part, ArrayList editParts) {
        if (!editParts.contains((Object)part)) {
            editParts.add(part);
            part.getFigure().repaint();
        }
    }
}

