/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.parts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.core.commands.DeleteCommand;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.core.model.schematic.ListBandProxy;
import org.eclipse.birt.report.designer.core.model.schematic.RowHandleAdapter;
import org.eclipse.birt.report.designer.core.model.views.outline.ReportElementModel;
import org.eclipse.birt.report.designer.core.util.mediator.IColleague;
import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;
import org.eclipse.birt.report.designer.internal.ui.command.WrapperCommandStack;
import org.eclipse.birt.report.designer.internal.ui.editors.notification.DeferredRefreshManager;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.DeferredGraphicalViewer;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.EditorSelectionProvider;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableUtil;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.ReportCreationTool;
import org.eclipse.birt.report.designer.internal.ui.palette.ReportCombinedTemplateCreationEntry;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.dnd.TemplateTransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.ui.actions.CopyTemplateAction;
import org.eclipse.gef.ui.actions.DeleteAction;
import org.eclipse.gef.ui.actions.EditorPartAction;
import org.eclipse.gef.ui.actions.GEFActionConstants;
import org.eclipse.gef.ui.actions.RedoAction;
import org.eclipse.gef.ui.actions.SaveAction;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.gef.ui.actions.StackAction;
import org.eclipse.gef.ui.actions.UndoAction;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.palette.CustomizeAction;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.gef.ui.palette.LayoutAction;
import org.eclipse.gef.ui.palette.PaletteContextMenuProvider;
import org.eclipse.gef.ui.palette.PaletteEditPartFactory;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerPreferences;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.palette.SettingsAction;
import org.eclipse.gef.ui.palette.customize.PaletteSettingsDialog;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.views.palette.PalettePage;
import org.eclipse.gef.ui.views.palette.PaletteViewerPage;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

public abstract class GraphicalEditorWithFlyoutPalette
extends GraphicalEditor
implements EditorSelectionProvider,
IColleague {
    private PaletteViewerProvider provider;
    private FlyoutPaletteComposite splitter;
    private CustomPalettePage page;
    private List stackActionIDs = new ArrayList();
    private List editorActionIDs = new ArrayList();
    private List editPartActionIDs = new ArrayList();
    private ISelectionListener selectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            GraphicalEditorWithFlyoutPalette.this.updateActions(GraphicalEditorWithFlyoutPalette.this.editPartActionIDs);
        }
    };

    protected void initializeGraphicalViewer() {
        this.splitter.hookDropTargetListener(this.getGraphicalViewer());
        this.updateActions(this.stackActionIDs);
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener(this.getSelectionListener());
    }

    public WrapperCommandStack getWrapperCommandStack() {
        return (WrapperCommandStack)((Object)this.getMultiPageEditor().getAdapter(CommandStack.class));
    }

    protected void firePropertyChange(int propertyId) {
        super.firePropertyChange(propertyId);
        this.updateActions(this.editorActionIDs);
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        return new PaletteViewerProvider((EditDomain)this.getEditDomain()){

            protected void configurePaletteViewer(PaletteViewer viewer) {
                viewer.setContextMenu((MenuManager)new PaletteContextMenuProvider(this, viewer){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                        super(x0);
                    }

                    public void buildContextMenu(IMenuManager menu) {
                        GEFActionConstants.addStandardActionGroups((IMenuManager)menu);
                        List lst = this.getPaletteViewer().getSelectedEditParts();
                        if (lst.size() == 0) {
                            return;
                        }
                        menu.appendToGroup("org.eclipse.gef.group.view", (IAction)new LayoutAction(this.getPaletteViewer().getPaletteViewerPreferences()));
                        if (this.getPaletteViewer().getCustomizer() != null) {
                            menu.appendToGroup("org.eclipse.gef.group.rest", (IAction)new CustomizeAction(this.getPaletteViewer()));
                        }
                        PaletteViewer paletteViewer = this.getPaletteViewer();
                        menu.appendToGroup("org.eclipse.gef.group.rest", (IAction)new SettingsAction(this, paletteViewer, paletteViewer){
                            private final /* synthetic */ PaletteViewer val$paletteViewer;
                            private final /* synthetic */ 3 this$2;
                            {
                                this.this$2 = this$2;
                                this.val$paletteViewer = val$paletteViewer;
                                super(x0);
                            }

                            public void run() {
                                PaletteViewerPreferences prefs = this.val$paletteViewer.getPaletteViewerPreferences();
                                PaletteSettingsDialog settings = new PaletteSettingsDialog(this, this.val$paletteViewer.getControl().getShell(), prefs, prefs){
                                    private final /* synthetic */ PaletteViewerPreferences val$prefs;
                                    private final /* synthetic */ 4 this$3;
                                    {
                                        this.this$3 = this$3;
                                        this.val$prefs = val$prefs;
                                        super(x0, x1);
                                    }

                                    protected Control createLayoutSettings(Composite parent) {
                                        Composite composite = new Composite(parent, 0);
                                        composite.setFont(parent.getFont());
                                        GridLayout layout = new GridLayout(1, false);
                                        composite.setLayout((Layout)layout);
                                        Control layoutOptions = this.createLayoutOptions(composite);
                                        GridData data = new GridData(2);
                                        layoutOptions.setLayoutData((Object)data);
                                        this.handleLayoutSettingChanged(this.val$prefs.getLayoutSetting());
                                        return composite;
                                    }

                                    protected void handleLayoutSettingChanged(int newSetting) {
                                        this.val$prefs.setLayoutSetting(newSetting);
                                    }
                                };
                                settings.open();
                            }
                        });
                    }
                });
                viewer.addDragSourceListener((TransferDragSourceListener)new TemplateTransferDragSourceListener((EditPartViewer)viewer));
                viewer.getControl().addMouseListener(new MouseListener(this, viewer){
                    private final /* synthetic */ PaletteViewer val$viewer;
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$viewer = val$viewer;
                    }

                    public void mouseDoubleClick(MouseEvent e) {
                        EditPart editPart = this.val$viewer.findObjectAt(new Point(e.x, e.y));
                        ReportCombinedTemplateCreationEntry entry = null;
                        if (editPart != null && editPart.getModel() instanceof ReportCombinedTemplateCreationEntry) {
                            entry = (ReportCombinedTemplateCreationEntry)((Object)editPart.getModel());
                        }
                        if (entry == null) {
                            return;
                        }
                        ReportCreationTool tool = (ReportCreationTool)entry.createTool();
                        EditDomain domain = UIUtil.getLayoutEditPartViewer().getEditDomain();
                        tool.setEditDomain(domain);
                        tool.setViewer(UIUtil.getLayoutEditPartViewer());
                        tool.performCreation(UIUtil.getCurrentEditPart());
                        Display.getCurrent().asyncExec(new Runnable(this, domain){
                            private final /* synthetic */ EditDomain val$domain;
                            private final /* synthetic */ 6 this$2;
                            {
                                this.this$2 = this$2;
                                this.val$domain = val$domain;
                            }

                            public void run() {
                                this.val$domain.loadDefaultTool();
                            }
                        });
                    }

                    public void mouseDown(MouseEvent e) {
                    }

                    public void mouseUp(MouseEvent e) {
                    }
                });
            }

            public PaletteViewer createPaletteViewer(Composite parent) {
                PaletteViewer pViewer = new PaletteViewer();
                pViewer.setEditPartFactory((EditPartFactory)new PaletteEditPartFactory());
                pViewer.createControl(parent);
                this.configurePaletteViewer(pViewer);
                this.hookPaletteViewer(pViewer);
                return pViewer;
            }
        };
    }

    protected CustomPalettePage createPalettePage() {
        return new CustomPalettePage(this.getPaletteViewerProvider());
    }

    protected void createActions() {
        this.addStackAction((StackAction)new UndoAction((IEditorPart)this));
        this.addStackAction((StackAction)new RedoAction((IEditorPart)this));
        this.addEditPartAction((SelectionAction)new DeleteAction((IWorkbenchPart)this){

            public Command createDeleteCommand(List objects) {
                if (objects.isEmpty()) {
                    return null;
                }
                if (!(objects.get(0) instanceof EditPart)) {
                    return null;
                }
                GroupRequest deleteReq = new GroupRequest((Object)"delete");
                deleteReq.setEditParts(objects);
                List temp = TableUtil.filletCellModel(objects);
                ArrayList<Object> list = new ArrayList<Object>();
                for (int i = 0; i < temp.size(); ++i) {
                    EditPart object = (EditPart)temp.get(i);
                    list.add(object.getModel());
                }
                return new DeleteCommand((Object)list.toArray());
            }
        });
        SaveAction saveAction = new SaveAction((IEditorPart)this);
        saveAction.setLazyEnablementCalculation(true);
        this.addEditorAction((EditorPartAction)saveAction);
        this.addAction((IAction)new CopyTemplateAction((IEditorPart)this));
    }

    protected boolean hasRuler() {
        return false;
    }

    protected boolean hasButtonPane() {
        return true;
    }

    public void createPartControl(Composite parent) {
        this.splitter = new FlyoutPaletteComposite(parent, 0, this.getSite().getPage(), this.getPaletteViewerProvider(), this.getPalettePreferences());
        super.createPartControl((Composite)this.splitter);
        Control ctrl = this.getGraphicalControl();
        this.splitter.setGraphicalControl(ctrl);
        if (this.page != null) {
            this.splitter.setExternalViewer(this.page.getPaletteViewer());
            this.page = null;
        }
    }

    public void dispose() {
        SessionHandleAdapter.getInstance().getMediator().removeColleague((IColleague)this);
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener(this.getSelectionListener());
        super.dispose();
        if (this.splitter != null) {
            this.splitter.setExternalViewer(null);
        }
        this.splitter = null;
        this.getSelectionActions().clear();
        this.getActionRegistry().dispose();
        ArrayList<IAction> list = new ArrayList<IAction>();
        Iterator actions = this.getActionRegistry().getActions();
        while (actions.hasNext()) {
            IAction action = (IAction)actions.next();
            list.add(action);
        }
        for (int i = 0; i < list.size(); ++i) {
            this.getActionRegistry().removeAction((IAction)list.get(i));
        }
    }

    public Object getAdapter(Class type) {
        if (type == PalettePage.class) {
            if (this.splitter == null) {
                this.page = this.createPalettePage();
                return this.page;
            }
            return this.createPalettePage();
        }
        if (type == PaletteRoot.class) {
            return this.getPaletteRoot();
        }
        if (type == ZoomManager.class) {
            return this.getGraphicalViewer().getProperty(ZoomManager.class.toString());
        }
        return super.getAdapter(type);
    }

    protected abstract IEditorPart getMultiPageEditor();

    protected Control getGraphicalControl() {
        return this.getGraphicalViewer().getControl();
    }

    public GraphicalViewer getGraphicalViewer() {
        return super.getGraphicalViewer();
    }

    protected abstract FlyoutPaletteComposite.FlyoutPreferences getPalettePreferences();

    protected abstract PaletteRoot getPaletteRoot();

    protected final PaletteViewerProvider getPaletteViewerProvider() {
        if (this.provider == null) {
            this.provider = this.createPaletteViewerProvider();
        }
        return this.provider;
    }

    protected void setEditDomain(DefaultEditDomain ed) {
        super.setEditDomain(ed);
        this.getEditDomain().setPaletteRoot(this.getPaletteRoot());
    }

    protected void createGraphicalViewer(Composite parent) {
        DeferredGraphicalViewer viewer = new DeferredGraphicalViewer();
        viewer.hookRefreshListener(this.getRefreshManager());
        viewer.createControl(parent);
        this.setGraphicalViewer((GraphicalViewer)viewer);
        this.configureGraphicalViewer();
        this.hookGraphicalViewer();
        this.initializeGraphicalViewer();
        SessionHandleAdapter.getInstance().getMediator().addColleague((IColleague)this);
    }

    protected abstract DeferredRefreshManager getRefreshManager();

    protected void hookZoom(ScalableFreeformRootEditPart root) {
        ArrayList<String> zoomLevels = new ArrayList<String>(3);
        zoomLevels.add(ZoomManager.FIT_ALL);
        zoomLevels.add(ZoomManager.FIT_WIDTH);
        zoomLevels.add(ZoomManager.FIT_HEIGHT);
        root.getZoomManager().setZoomLevelContributions(zoomLevels);
        ZoomInAction zoomIn = new ZoomInAction(root.getZoomManager());
        ZoomOutAction zoomOut = new ZoomOutAction(root.getZoomManager());
        this.getActionRegistry().registerAction((IAction)zoomIn);
        this.getActionRegistry().registerAction((IAction)zoomOut);
        this.getSite().getKeyBindingService().registerAction((IAction)zoomIn);
        this.getSite().getKeyBindingService().registerAction((IAction)zoomOut);
    }

    protected ISelectionListener getSelectionListener() {
        return this.selectionListener;
    }

    protected void addAction(IAction action) {
        this.getActionRegistry().registerAction(action);
    }

    protected void addEditorAction(EditorPartAction action) {
        this.getActionRegistry().registerAction((IAction)action);
        this.editorActionIDs.add(action.getId());
    }

    protected void addEditPartAction(SelectionAction action) {
        this.getActionRegistry().registerAction((IAction)action);
        this.editPartActionIDs.add(action.getId());
    }

    protected void addStackAction(StackAction action) {
        this.getActionRegistry().registerAction((IAction)action);
        this.stackActionIDs.add(action.getId());
    }

    protected void updateActions(List actionIds) {
        Iterator ids = actionIds.iterator();
        while (ids.hasNext()) {
            IAction action = this.getActionRegistry().getAction(ids.next());
            if (null == action || !(action instanceof UpdateAction)) continue;
            ((UpdateAction)action).update();
        }
    }

    public void updateStackActions() {
        this.updateActions(this.stackActionIDs);
    }

    public void performRequest(ReportRequest request) {
        if ("selection".equals(request.getType())) {
            this.handleSelectionChange(request);
        } else if ("create element".equals(request.getType())) {
            this.handleCreateElement(request);
        }
    }

    protected void handleCreateElement(ReportRequest request) {
        final GraphicalViewer viewer = this.getGraphicalViewer();
        if (!viewer.getControl().isVisible()) {
            return;
        }
        final List list = request.getSelectionModelList();
        if (list.size() != 1) {
            return;
        }
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                Request directEditRequest;
                Object part = viewer.getEditPartRegistry().get(list.get(0));
                if (part instanceof EditPart && ((EditPart)part).understandsRequest(directEditRequest = new Request((Object)"create element"))) {
                    ((EditPart)part).performRequest(directEditRequest);
                }
            }
        });
    }

    protected void handleSelectionChange(ReportRequest request) {
        List select = this.convertEventToGFE(request);
        if (select == null) {
            return;
        }
        this.getGraphicalViewer().setSelection((ISelection)new StructuredSelection(select));
        if (select.size() > 0) {
            this.getGraphicalViewer().reveal((EditPart)select.get(select.size() - 1));
        }
    }

    private List convertEventToGFE(ReportRequest event) {
        if (event.getSource() == this.getGraphicalViewer()) {
            return null;
        }
        ArrayList tempList = new ArrayList();
        List list = event.getSelectionModelList();
        int size = list.size();
        if (size != 0 && list.get(0) instanceof RowHandle) {
            RowHandle handle = (RowHandle)list.get(0);
            RowHandleAdapter adapter = HandleAdapterFactory.getInstance().getRowHandleAdapter((Object)handle);
            Object tableParent = adapter.getTableParent();
            if (tableParent == null) {
                return null;
            }
            TableEditPart part = (TableEditPart)((Object)this.getGraphicalViewer().getEditPartRegistry().get(tableParent));
            int[] selectRows = new int[]{adapter.getRowNumber()};
            for (int i = 1; i < size; ++i) {
                Object o = list.get(i);
                if (o instanceof RowHandle) {
                    handle = (RowHandle)o;
                    adapter = HandleAdapterFactory.getInstance().getRowHandleAdapter((Object)handle);
                    if (tableParent != adapter.getTableParent()) {
                        return null;
                    }
                } else {
                    return null;
                }
                int len = selectRows.length;
                int[] temp = new int[len + 1];
                System.arraycopy(selectRows, 0, temp, 0, len);
                temp[len] = adapter.getRowNumber();
                selectRows = temp;
            }
            if (handle.getRoot() == null) {
                return null;
            }
            if (part != null) {
                Arrays.sort(selectRows);
                int len = selectRows.length;
                if (len > 1) {
                    for (int i = 0; i < len - 1; ++i) {
                        if (selectRows[i + 1] - selectRows[i] == 1) continue;
                        return null;
                    }
                }
                part.selectRow(selectRows);
            }
            return null;
        }
        for (int i = 0; i < size; ++i) {
            Object obj = list.get(i);
            if (obj instanceof EditPart) {
                tempList.add(obj);
                continue;
            }
            Object part = null;
            if (obj instanceof ReportElementModel) {
                obj = ((ReportElementModel)obj).getSlotHandle();
                part = this.getGraphicalViewer().getEditPartRegistry().get(new ListBandProxy((SlotHandle)obj));
            } else {
                part = this.getGraphicalViewer().getEditPartRegistry().get(obj);
            }
            if (!(part instanceof EditPart)) continue;
            tempList.add(part);
        }
        if (tempList.isEmpty()) {
            return null;
        }
        return tempList;
    }

    public void setFocus() {
        if (this.getGraphicalViewer() != null && this.getGraphicalViewer().getControl() != null) {
            super.setFocus();
        }
    }

    protected class CustomPalettePage
    extends PaletteViewerPage {
        public CustomPalettePage(PaletteViewerProvider provider) {
            super(provider);
        }

        public void createControl(Composite parent) {
            super.createControl(parent);
            if (GraphicalEditorWithFlyoutPalette.this.splitter != null) {
                GraphicalEditorWithFlyoutPalette.this.splitter.setExternalViewer(this.viewer);
            }
        }

        public void dispose() {
            if (GraphicalEditorWithFlyoutPalette.this.splitter != null) {
                GraphicalEditorWithFlyoutPalette.this.splitter.setExternalViewer(null);
            }
            super.dispose();
        }

        public PaletteViewer getPaletteViewer() {
            return this.viewer;
        }
    }
}

