/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.parts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;

public class ReportFocusTraverseManager {
    private IFigure findDeepestRightmostChildOf(IFigure fig) {
        while (fig.getChildren().size() != 0) {
            fig = (IFigure)fig.getChildren().get(fig.getChildren().size() - 1);
        }
        return fig;
    }

    public IFigure getNextFocusableFigure(IFigure root, IFigure focusOwner) {
        boolean found = false;
        IFigure nextFocusOwner = focusOwner;
        if (focusOwner == null) {
            if (root.getChildren().size() != 0) {
                nextFocusOwner = (IFigure)root.getChildren().get(0);
                if (this.isFocusEligible(nextFocusOwner)) {
                    return nextFocusOwner;
                }
            } else {
                return null;
            }
        }
        while (!found) {
            IFigure parent = nextFocusOwner.getParent();
            List siblings = parent.getChildren();
            int siblingPos = siblings.indexOf(nextFocusOwner);
            if (nextFocusOwner.getChildren().size() != 0) {
                if (!this.isFocusEligible(nextFocusOwner = (IFigure)nextFocusOwner.getChildren().get(0))) continue;
                found = true;
                continue;
            }
            if (siblingPos < siblings.size() - 1) {
                nextFocusOwner = (IFigure)siblings.get(siblingPos + 1);
                if (!this.isFocusEligible(nextFocusOwner)) continue;
                found = true;
                continue;
            }
            boolean untraversedSiblingFound = false;
            while (!untraversedSiblingFound) {
                IFigure p = nextFocusOwner.getParent();
                IFigure gp = p.getParent();
                if (gp != null) {
                    int parentSiblingCount = gp.getChildren().size();
                    int parentIndex = gp.getChildren().indexOf(p);
                    if (parentIndex < parentSiblingCount - 1) {
                        nextFocusOwner = (IFigure)p.getParent().getChildren().get(parentIndex + 1);
                        untraversedSiblingFound = true;
                        if (!this.isFocusEligible(nextFocusOwner)) continue;
                        found = true;
                        continue;
                    }
                    nextFocusOwner = p;
                    continue;
                }
                nextFocusOwner = null;
                untraversedSiblingFound = true;
                found = true;
            }
        }
        return nextFocusOwner;
    }

    public IFigure getNextFocusableFigureInSameOrder(IFigure root, IFigure focusOwner) {
        boolean found = false;
        IFigure nextFocusOwner = focusOwner;
        if (focusOwner == null) {
            if (root.getChildren().size() != 0) {
                nextFocusOwner = (IFigure)root.getChildren().get(0);
                if (this.isFocusEligible(nextFocusOwner)) {
                    return nextFocusOwner;
                }
            } else {
                return null;
            }
        }
        ArrayList<IFigure> list = new ArrayList<IFigure>();
        while (!found) {
            IFigure parent = nextFocusOwner.getParent();
            List siblings = parent.getChildren();
            int siblingPos = siblings.indexOf(nextFocusOwner);
            if (siblingPos < siblings.size() - 1) {
                nextFocusOwner = (IFigure)siblings.get(siblingPos + 1);
                list.add(nextFocusOwner);
                if (!this.isFocusEligible(nextFocusOwner)) continue;
                found = true;
                continue;
            }
            if (siblings.size() == 1) {
                nextFocusOwner = (IFigure)siblings.get(0);
                if (this.isFocusEligible(nextFocusOwner)) {
                    found = true;
                    continue;
                }
                return null;
            }
            nextFocusOwner = (IFigure)siblings.get(0);
            if (this.isFocusEligible(nextFocusOwner)) {
                found = true;
                continue;
            }
            if (list.contains(nextFocusOwner)) {
                return null;
            }
            list.add(nextFocusOwner);
        }
        return nextFocusOwner;
    }

    public IFigure getPreviousFocusableFigureInSameOrder(IFigure root, IFigure focusOwner) {
        IFigure nextFocusOwner = focusOwner;
        if (focusOwner == null) {
            if (root.getChildren().size() != 0) {
                nextFocusOwner = this.findDeepestRightmostChildOf(root);
                if (this.isFocusEligible(nextFocusOwner)) {
                    return nextFocusOwner;
                }
            } else {
                return null;
            }
        }
        boolean found = false;
        ArrayList<IFigure> list = new ArrayList<IFigure>();
        while (!found) {
            IFigure parent = nextFocusOwner.getParent();
            if (parent == null) {
                return null;
            }
            List siblings = parent.getChildren();
            int siblingPos = siblings.indexOf(nextFocusOwner);
            if (siblingPos != 0) {
                nextFocusOwner = (IFigure)siblings.get(siblingPos - 1);
                list.add(nextFocusOwner);
                if (!this.isFocusEligible(nextFocusOwner)) continue;
                found = true;
                continue;
            }
            if (siblings.size() == 1) {
                nextFocusOwner = (IFigure)siblings.get(0);
                if (this.isFocusEligible(nextFocusOwner)) {
                    found = true;
                    continue;
                }
                return null;
            }
            nextFocusOwner = (IFigure)siblings.get(siblings.size() - 1);
            if (this.isFocusEligible(nextFocusOwner)) {
                found = true;
                continue;
            }
            if (list.contains(nextFocusOwner)) {
                return null;
            }
            list.add(nextFocusOwner);
        }
        return nextFocusOwner;
    }

    public IFigure getPreviousFocusableFigure(IFigure root, IFigure focusOwner) {
        IFigure nextFocusOwner = focusOwner;
        if (focusOwner == null) {
            if (root.getChildren().size() != 0) {
                nextFocusOwner = this.findDeepestRightmostChildOf(root);
                if (this.isFocusEligible(nextFocusOwner)) {
                    return nextFocusOwner;
                }
            } else {
                return null;
            }
        }
        boolean found = false;
        while (!found) {
            IFigure parent = nextFocusOwner.getParent();
            if (parent == null) {
                return null;
            }
            List siblings = parent.getChildren();
            int siblingPos = siblings.indexOf(nextFocusOwner);
            if (siblingPos != 0) {
                IFigure child = this.findDeepestRightmostChildOf((IFigure)siblings.get(siblingPos - 1));
                if (this.isFocusEligible(child)) {
                    found = true;
                    nextFocusOwner = child;
                    continue;
                }
                if (child.equals(nextFocusOwner)) {
                    if (!this.isFocusEligible(nextFocusOwner)) continue;
                    found = true;
                    continue;
                }
                nextFocusOwner = child;
                continue;
            }
            nextFocusOwner = parent;
            if (!this.isFocusEligible(nextFocusOwner)) continue;
            found = true;
        }
        return nextFocusOwner;
    }

    public boolean isFocusEligible(IFigure fig) {
        return fig != null && fig.isFocusTraversable() && fig.isShowing();
    }
}

