/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic;

import org.eclipse.birt.report.designer.util.ColorManager;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Polygon;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class ReportFigureUtilities {
    private static Polygon trianglePolygon = new Polygon();
    private static final Color[] BEVEL_COLOR = new Color[]{ColorManager.getColor((int)212, (int)208, (int)200), ColorManager.getColor((int)255, (int)255, (int)255), ColorManager.getColor((int)64, (int)64, (int)64), ColorManager.getColor((int)128, (int)128, (int)128)};
    private static final Color[] SHADOW_COLOR = new Color[]{ColorManager.getColor((int)195, (int)195, (int)195), ColorManager.getColor((int)210, (int)210, (int)210), ColorManager.getColor((int)225, (int)225, (int)225), ColorManager.getColor((int)240, (int)240, (int)240), ColorManager.getColor((int)207, (int)207, (int)207), ColorManager.getColor((int)219, (int)219, (int)219), ColorManager.getColor((int)231, (int)231, (int)231), ColorManager.getColor((int)243, (int)243, (int)243), ColorManager.getColor((int)219, (int)219, (int)219), ColorManager.getColor((int)228, (int)228, (int)228), ColorManager.getColor((int)237, (int)237, (int)237), ColorManager.getColor((int)246, (int)246, (int)246), ColorManager.getColor((int)231, (int)231, (int)231), ColorManager.getColor((int)237, (int)237, (int)237), ColorManager.getColor((int)243, (int)243, (int)243), ColorManager.getColor((int)249, (int)249, (int)249), ColorManager.getColor((int)243, (int)243, (int)243), ColorManager.getColor((int)246, (int)246, (int)246), ColorManager.getColor((int)249, (int)249, (int)249), ColorManager.getColor((int)252, (int)252, (int)252)};

    public static int[] getTrianglePoints(int triangleHeight, Point triangleCenter) {
        int[] points = new int[6];
        int xOff = (int)((double)(triangleHeight * 2) * Math.tan(0.5235987755982988));
        points[0] = triangleCenter.x - xOff;
        points[1] = triangleCenter.y - triangleHeight / 2;
        points[2] = triangleCenter.x + xOff;
        points[3] = triangleCenter.y - triangleHeight / 2;
        points[4] = triangleCenter.x;
        points[5] = triangleCenter.y + triangleHeight / 2;
        return points;
    }

    public static void paintTriangle(Graphics graphics, int triangleHeight, Point triangleCenter) {
        graphics.fillPolygon(ReportFigureUtilities.getTrianglePoints(triangleHeight, triangleCenter));
    }

    public static boolean isInTriangle(Point triangleCenter, int triangleHeight, Point pt) {
        trianglePolygon.setPoints(new PointList(ReportFigureUtilities.getTrianglePoints(triangleHeight, triangleCenter)));
        return trianglePolygon.containsPoint(pt);
    }

    public static void paintDoubleArrow(Graphics graphics, int height, Point center) {
        int[] points = new int[6];
        int xOff = (int)((double)height * Math.tan(0.7853981633974483) / 2.0);
        points[0] = center.x - xOff;
        points[1] = center.y - height / 2;
        points[2] = center.x;
        points[3] = center.y;
        points[4] = center.x - xOff;
        points[5] = center.y + height / 2;
        graphics.drawPolyline(points);
        ReportFigureUtilities.incXOffset(points, 1);
        graphics.drawPolyline(points);
        ReportFigureUtilities.incXOffset(points, 3);
        graphics.drawPolyline(points);
        ReportFigureUtilities.incXOffset(points, 1);
        graphics.drawPolyline(points);
    }

    public static void paintExpandHandle(Graphics graphics, int height, Point center, boolean collapsed) {
        graphics.drawRectangle(center.x - height / 2, center.y - height / 2, height, height);
        graphics.drawLine(center.x - height / 2 + 2, center.y, center.x + height / 2 - 2, center.y);
        if (collapsed) {
            graphics.drawLine(center.x, center.y - height / 2 + 2, center.x, center.y + height / 2 - 2);
        }
    }

    private static void incXOffset(int[] points, int offset) {
        for (int i = 0; i < points.length; i += 2) {
            int n = i;
            points[n] = points[n] + offset;
        }
    }

    public static void paintBevel(Graphics graphics, Rectangle area, boolean rised) {
        graphics.setForegroundColor(BEVEL_COLOR[rised ? 0 : 2]);
        graphics.drawLine(area.x, area.y, area.x, area.y + area.height - 2);
        graphics.drawLine(area.x, area.y, area.x + area.width - 2, area.y);
        graphics.setForegroundColor(BEVEL_COLOR[rised ? 1 : 3]);
        graphics.drawLine(area.x + 1, area.y + 1, area.x + 1, area.y + area.height - 3);
        graphics.drawLine(area.x + 1, area.y + 1, area.x + area.width - 3, area.y + 1);
        graphics.setForegroundColor(BEVEL_COLOR[rised ? 2 : 0]);
        graphics.drawLine(area.x, area.y + area.height - 1, area.x + area.width - 1, area.y + area.height - 1);
        graphics.drawLine(area.x + area.width - 1, area.y, area.x + area.width - 1, area.y + area.height - 1);
        graphics.setForegroundColor(BEVEL_COLOR[rised ? 3 : 1]);
        graphics.drawLine(area.x + 1, area.y + area.height - 2, area.x + area.width - 2, area.y + area.height - 2);
        graphics.drawLine(area.x + area.width - 2, area.y + 1, area.x + area.width - 2, area.y + area.height - 2);
    }

    public static void paintShadow(Graphics graphics, Rectangle area, boolean drawTopLeft) {
        int j;
        int i;
        int inc = 1;
        int xoff = 4;
        int yoff = 4;
        int xlpos = area.x - 1;
        int xpos = area.x + area.width + 1;
        int ylpos = area.y - 1;
        int ypos = area.y + area.height + 1;
        if (drawTopLeft) {
            inc = -1;
            xoff = -4;
            yoff = -4;
            xlpos = area.x + area.width + 1;
            xpos = area.x - 1;
            ylpos = area.y + area.height + 1;
            ypos = area.y - 1;
        }
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 4; ++j) {
                graphics.setForegroundColor(SHADOW_COLOR[i * 4 + 4 + j]);
                graphics.drawPoint(xpos + i * inc, ypos + j * inc);
            }
        }
        if (area.width > 4) {
            for (i = 0; i < 4; ++i) {
                for (j = 0; j < 4; ++j) {
                    graphics.setForegroundColor(SHADOW_COLOR[i * 4 + 4 + j]);
                    graphics.drawPoint(xlpos + 8 * inc - i * inc, ypos + j * inc);
                }
            }
            if (area.width > 8) {
                for (i = 0; i < 4; ++i) {
                    graphics.setForegroundColor(SHADOW_COLOR[i]);
                    graphics.drawLine(area.x + 4 + xoff, ypos + inc * i, area.x + area.width + xoff - 4, ypos + inc * i);
                }
            }
        }
        if (area.height > 4) {
            for (i = 0; i < 4; ++i) {
                for (j = 0; j < 4; ++j) {
                    graphics.setForegroundColor(SHADOW_COLOR[i * 4 + 4 + j]);
                    graphics.drawPoint(xpos + i * inc, ylpos + 8 * inc - j * inc);
                }
            }
            if (area.height > 8) {
                for (i = 0; i < 4; ++i) {
                    graphics.setForegroundColor(SHADOW_COLOR[i]);
                    graphics.drawLine(xpos + inc * i, area.y + 4 + yoff, xpos + inc * i, area.y + area.height + yoff - 4);
                }
            }
        }
    }
}

