/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions;

import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions.ContextSelectionAction;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.StyleBuilder;
import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.command.StyleException;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class AddStyleAction
extends ContextSelectionAction {
    private static final String STACK_MSG_ADD_STYLE = Messages.getString((String)"AddStyleAction.stackMsg.addStyle");
    private static final String ACTION_MSG_ADD_STYLE_RULE = Messages.getString((String)"AddStyleAction.actionMsg.addStyleRule");
    public static final String ID = "AddStyleAction";
    private ThemeHandle themeHandle;

    public AddStyleAction(IWorkbenchPart part) {
        super(part);
        this.setId(ID);
        this.setText(ACTION_MSG_ADD_STYLE_RULE);
    }

    protected boolean calculateEnabled() {
        return true;
    }

    public void run() {
        if (Policy.TRACING_ACTIONS) {
            System.out.println("Add Style rule action >> Run ...");
        }
        CommandStack stack = this.getActiveCommandStack();
        stack.startTrans(STACK_MSG_ADD_STYLE);
        ModuleHandle reportDesignHandle = SessionHandleAdapter.getInstance().getReportDesignHandle();
        SharedStyleHandle styleHandle = DesignElementFactory.getInstance(reportDesignHandle).newStyle(null);
        try {
            StyleBuilder dialog = new StyleBuilder(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (ReportElementHandle)styleHandle, StyleBuilder.DLG_TITLE_NEW);
            if (dialog.open() == 0) {
                if (this.themeHandle != null) {
                    this.themeHandle.getStyles().add((DesignElementHandle)styleHandle);
                } else {
                    reportDesignHandle.getStyles().add((DesignElementHandle)styleHandle);
                }
                if (!styleHandle.isPredefined()) {
                    this.applyStyle(styleHandle);
                }
                stack.commit();
            }
        }
        catch (Exception e) {
            stack.rollbackAll();
            ExceptionHandler.handle(e);
        }
    }

    private void applyStyle(SharedStyleHandle styleHandle) {
        List handles = this.getElementHandles();
        for (int i = 0; i < handles.size(); ++i) {
            try {
                if (!(handles.get(i) instanceof ReportElementHandle)) continue;
                ((DesignElementHandle)handles.get(i)).setStyle(styleHandle);
                continue;
            }
            catch (StyleException e) {
                e.printStackTrace();
            }
        }
    }

    public void setThemeHandle(ThemeHandle themeHandle) {
        this.themeHandle = themeHandle;
    }
}

