/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.actions;

import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.ListBandProxy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.DummyEditpart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.GridEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ListBandEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ListEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportElementEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableCellEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableEditPart;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.jface.action.Action;

abstract class InsertPositionGroupAction
extends Action {
    private static final String STACK_MSG_ADD_GROUP = Messages.getString((String)"AddGroupAction.stackMsg.addGroup");
    private Object currentModel;
    private List selection;
    protected static final int POSITION_TOP_LEVEL = 0;
    protected static final int POSITION_INNERMOST = -1;

    protected InsertPositionGroupAction(List selection, String text) {
        this.selection = selection;
        this.setText(text);
    }

    public void setSelection(List selection) {
        this.selection = selection;
        this.currentModel = null;
    }

    public boolean isEnabled() {
        boolean canContain = false;
        if (this.getTableEditPart() != null) {
            canContain = ((TableHandle)this.getTableEditPart().getModel()).canContain(1, "TableGroup");
        }
        if (this.getListEditPart() != null) {
            canContain = ((ListHandle)this.getListEditPart().getModel()).canContain(1, "ListGroup");
        }
        return canContain;
    }

    public void run() {
        if (Policy.TRACING_ACTIONS) {
            System.out.println("Insert group action >> Run ...");
        }
        CommandStack stack = this.getActiveCommandStack();
        stack.startTrans(STACK_MSG_ADD_GROUP);
        boolean retValue = false;
        retValue = this.getTableEditPart() != null ? this.getTableEditPart().insertGroup(this.getPosition()) : this.getListEditPart().insertGroup(this.getPosition());
        if (retValue) {
            stack.commit();
        } else {
            stack.rollbackAll();
        }
    }

    protected boolean isGroup() {
        if (this.getRowHandle() != null) {
            return this.getRowHandle().getContainer() instanceof GroupHandle;
        }
        if (this.getListBandProxy() != null) {
            return this.getListBandProxy().getElemtHandle() instanceof GroupHandle;
        }
        return false;
    }

    protected boolean isNotReverse() {
        return true;
    }

    protected TableEditPart getTableEditPart() {
        if (this.getSelection() == null || this.getSelection().isEmpty()) {
            return null;
        }
        List list = this.getSelection();
        int size = list.size();
        TableEditPart part = null;
        for (int i = 0; i < size; ++i) {
            Object obj = this.getSelection().get(i);
            if (i == 0 && obj instanceof ReportElementEditPart) {
                this.currentModel = ((ReportElementEditPart)((Object)obj)).getModel();
            }
            TableEditPart currentEditPart = null;
            if (obj instanceof TableEditPart) {
                currentEditPart = (TableEditPart)((Object)obj);
            } else if (obj instanceof TableCellEditPart) {
                currentEditPart = (TableEditPart)((TableCellEditPart)((Object)obj)).getParent();
            } else if (obj instanceof DummyEditpart) continue;
            if (part == null) {
                part = currentEditPart;
            }
            if (currentEditPart != null && (currentEditPart == null || part == currentEditPart)) continue;
            return null;
        }
        if (part instanceof GridEditPart) {
            return null;
        }
        return part;
    }

    protected ListEditPart getListEditPart() {
        if (this.getSelection() == null || this.getSelection().isEmpty()) {
            return null;
        }
        List list = this.getSelection();
        int size = list.size();
        ListEditPart part = null;
        for (int i = 0; i < size; ++i) {
            Object obj = this.getSelection().get(i);
            if (i == 0 && obj instanceof ReportElementEditPart) {
                this.currentModel = ((ReportElementEditPart)((Object)obj)).getModel();
            }
            ListEditPart currentEditPart = null;
            if (obj instanceof ListEditPart) {
                currentEditPart = (ListEditPart)((Object)obj);
            } else if (obj instanceof ListBandEditPart) {
                currentEditPart = (ListEditPart)((ListBandEditPart)((Object)obj)).getParent();
            }
            if (part == null) {
                part = currentEditPart;
            }
            if (currentEditPart != null && (currentEditPart == null || part == currentEditPart)) continue;
            return null;
        }
        return part;
    }

    public List getSelection() {
        return this.selection;
    }

    protected RowHandle getRowHandle() {
        if (this.currentModel instanceof RowHandle) {
            return (RowHandle)this.currentModel;
        }
        if (this.currentModel instanceof CellHandle) {
            return (RowHandle)((CellHandle)this.currentModel).getContainer();
        }
        return null;
    }

    protected ListBandProxy getListBandProxy() {
        if (this.currentModel instanceof ListBandProxy) {
            return (ListBandProxy)this.currentModel;
        }
        return null;
    }

    protected CommandStack getActiveCommandStack() {
        return SessionHandleAdapter.getInstance().getCommandStack();
    }

    protected int getCurrentPosition() {
        if (this.currentModel != null && this.isGroup()) {
            if (this.getRowHandle() != null) {
                DesignElementHandle group = this.getRowHandle().getContainer();
                TableHandle table = (TableHandle)group.getContainer();
                return DEUtil.findInsertPosition((DesignElementHandle)table.getGroups().getElementHandle(), (DesignElementHandle)group, (int)table.getGroups().getSlotID());
            }
            if (this.getListBandProxy() != null) {
                DesignElementHandle group = this.getListBandProxy().getElemtHandle();
                ListHandle list = (ListHandle)group.getContainer();
                return DEUtil.findInsertPosition((DesignElementHandle)list.getGroups().getElementHandle(), (DesignElementHandle)group, (int)list.getGroups().getSlotID());
            }
        }
        return -1;
    }

    protected abstract int getPosition();
}

