/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.border;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class BorderUtil {
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    private static final int[] DEFAULT_LINE_WIDTH = new int[]{1, 1, 1, 1};

    private static int getGap(int x, int y, int i) {
        if (x == 0) {
            return 0;
        }
        if (i < 0) {
            i = 0;
        }
        if (i > x) {
            i = x;
        }
        return y * i / x;
    }

    public static void drawDoubleLine(Graphics g, int side, int[] width, Rectangle r) {
        int blankWidth = width[side] / 3;
        int lineWidth = blankWidth++;
        if (width[side] % 3 != 1 && width[side] % 3 == 2) {
            ++lineWidth;
        }
        if (lineWidth == 0 && width[side] != 0) {
            BorderUtil.drawSingleLine(g, side, 1, width, 1, 0, r);
            return;
        }
        BorderUtil.drawSingleLine(g, side, 1, width, lineWidth, 0, r);
        BorderUtil.drawSingleLine(g, side, 1, width, lineWidth, lineWidth + blankWidth, r);
    }

    public static void drawDefaultLine(Graphics g, int side, Rectangle r) {
        BorderUtil.drawSingleLine(g, side, 1, DEFAULT_LINE_WIDTH, r);
    }

    public static void drawSingleLine(Graphics g, int side, int style, int[] width, Rectangle r) {
        BorderUtil.drawSingleLine(g, side, style, width, -1, 0, r);
    }

    private static void drawSingleLine(Graphics g, int side, int style, int[] width, int actualWidth, int startPos, Rectangle r) {
        g.setLineStyle(style);
        Rectangle oldClip = g.getClip(new Rectangle());
        Rectangle clip = new Rectangle();
        Point p2 = new Point();
        switch (side) {
            case 1: {
                if (actualWidth < 0) {
                    actualWidth = width[side];
                }
                for (int i = 0; i < actualWidth; ++i) {
                    clip.width = 0;
                    clip.height = 0;
                    clip.x = r.x + BorderUtil.getGap(width[1], width[2], i + startPos);
                    clip.y = r.y + r.height - i - startPos - 1;
                    p2.x = r.x + r.width - BorderUtil.getGap(width[1], width[3], i + startPos) - 1;
                    p2.y = r.y + r.height - i - startPos - 1;
                    clip.union(p2);
                    g.clipRect(clip);
                    g.drawLine(r.x, r.y + r.height - i - startPos - 1, r.x + r.width, r.y + r.height - i - startPos - 1);
                    g.setClip(oldClip);
                }
                break;
            }
            case 0: {
                if (actualWidth < 0) {
                    actualWidth = width[side];
                }
                for (int i = 0; i < actualWidth; ++i) {
                    clip.width = 0;
                    clip.height = 0;
                    clip.x = r.x + BorderUtil.getGap(width[0], width[2], i + startPos);
                    clip.y = r.y + i + startPos;
                    p2.x = r.x + r.width - BorderUtil.getGap(width[0], width[3], i + startPos) - 1;
                    p2.y = r.y + i + startPos;
                    clip.union(p2);
                    g.clipRect(clip);
                    g.drawLine(r.x, r.y + i + startPos, r.x + r.width, r.y + i + startPos);
                    g.setClip(oldClip);
                }
                break;
            }
            case 2: {
                if (actualWidth < 0) {
                    actualWidth = width[side];
                }
                for (int i = 0; i < actualWidth; ++i) {
                    clip.width = 0;
                    clip.height = 0;
                    clip.x = r.x + i + startPos;
                    clip.y = r.y + BorderUtil.getGap(width[2], width[0], i + startPos);
                    p2.x = r.x + i + startPos;
                    p2.y = r.y + r.height - BorderUtil.getGap(width[2], width[1], i + startPos) - 1;
                    clip.union(p2);
                    g.clipRect(clip);
                    g.drawLine(r.x + i + startPos, r.y, r.x + i + startPos, r.y + r.height);
                    g.setClip(oldClip);
                }
                break;
            }
            case 3: {
                if (actualWidth < 0) {
                    actualWidth = width[side];
                }
                for (int i = 0; i < actualWidth; ++i) {
                    clip.width = 0;
                    clip.height = 0;
                    clip.x = r.x + r.width - i - startPos - 1;
                    clip.y = r.y + BorderUtil.getGap(width[3], width[0], i + startPos);
                    p2.x = r.x + r.width - i - startPos - 1;
                    p2.y = r.y + r.height - BorderUtil.getGap(width[3], width[1], i + startPos) - 1;
                    clip.union(p2);
                    g.clipRect(clip);
                    g.drawLine(r.x + r.width - i - startPos - 1, r.y, r.x + r.width - i - startPos - 1, r.y + r.height);
                    g.setClip(oldClip);
                }
                break;
            }
        }
        g.setClip(oldClip);
    }
}

