/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.border;

import org.eclipse.birt.report.designer.internal.ui.editors.ReportColorConstants;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.BaseBorder;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.BorderUtil;
import org.eclipse.birt.report.designer.util.ColorManager;
import org.eclipse.birt.report.model.api.util.ColorUtil;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;

public class SectionBorder
extends BaseBorder {
    private static final Insets DEFAULTINSETS = new Insets(2, 1, 2, 2);
    private Insets insets = new Insets(this.getDefaultPaddingInsets());
    private Dimension indicatorDimension = new Dimension();
    protected String indicatorLabel = "";
    protected Image image;
    protected int gap = 0;
    protected Insets gapInsets = new Insets(2, 2, 2, 2);
    private Rectangle indicatorArea;

    public Insets getInsets(IFigure figure) {
        return this.getTrueBorderInsets().add(this.insets);
    }

    public Insets getBorderInsets() {
        return this.getTrueBorderInsets();
    }

    public Insets getTrueBorderInsets() {
        int t = 1;
        int b = 1;
        int l = 1;
        int r = 1;
        int style = 0;
        style = this.getBorderStyle(this.bottomStyle);
        if (style != 0) {
            b = this.getBorderWidth(this.bottomWidth);
        }
        if ((style = this.getBorderStyle(this.topStyle)) != 0) {
            t = this.getBorderWidth(this.topWidth);
        }
        if ((style = this.getBorderStyle(this.leftStyle)) != 0) {
            l = this.getBorderWidth(this.leftWidth);
        }
        if ((style = this.getBorderStyle(this.rightStyle)) != 0) {
            r = this.getBorderWidth(this.rightWidth);
        }
        return new Insets(t, l, b, r);
    }

    Insets getDefaultPaddingInsets() {
        return DEFAULTINSETS;
    }

    public void setPaddingInsets(Insets in) {
        if (in == null || in.left == 0 && in.right == 0 && in.top == 0 && in.bottom == 0) {
            this.insets = new Insets(this.getDefaultPaddingInsets());
            return;
        }
        this.insets.top = in.top > this.getDefaultPaddingInsets().top ? in.top : this.getDefaultPaddingInsets().top;
        this.insets.bottom = in.bottom > this.indicatorDimension.height && in.bottom > this.getDefaultPaddingInsets().bottom ? in.bottom : this.getDefaultPaddingInsets().bottom;
        this.insets.left = in.left > this.getDefaultPaddingInsets().left ? in.left : this.getDefaultPaddingInsets().left;
        this.insets.right = in.right > this.getDefaultPaddingInsets().right ? in.right : this.getDefaultPaddingInsets().right;
    }

    public void paint(IFigure figure, Graphics g, Insets in) {
        this.i_bottom_style = this.getBorderStyle(this.bottomStyle);
        this.i_bottom_width = this.getBorderWidth(this.bottomWidth);
        this.i_top_style = this.getBorderStyle(this.topStyle);
        this.i_top_width = this.getBorderWidth(this.topWidth);
        this.i_left_style = this.getBorderStyle(this.leftStyle);
        this.i_left_width = this.getBorderWidth(this.leftWidth);
        this.i_right_style = this.getBorderStyle(this.rightStyle);
        this.i_right_width = this.getBorderWidth(this.rightWidth);
        g.restoreState();
        this.drawBorder(figure, g, in, 0, this.i_top_style, new int[]{this.i_top_width, this.i_bottom_width, this.i_left_width, this.i_right_width}, this.topColor);
        this.drawBorder(figure, g, in, 1, this.i_bottom_style, new int[]{this.i_top_width, this.i_bottom_width, this.i_left_width, this.i_right_width}, this.bottomColor);
        this.drawBorder(figure, g, in, 2, this.i_left_style, new int[]{this.i_top_width, this.i_bottom_width, this.i_left_width, this.i_right_width}, this.leftColor);
        this.drawBorder(figure, g, in, 3, this.i_right_style, new int[]{this.i_top_width, this.i_bottom_width, this.i_left_width, this.i_right_width}, this.rightColor);
    }

    private void drawBorder(IFigure figure, Graphics g, Insets in, int side, int style, int[] width, String color) {
        Rectangle r = figure.getBounds().getCropped(in);
        if (style != 0) {
            g.setForegroundColor(ColorManager.getColor((int)ColorUtil.parseColor((String)color)));
            if (style == -2) {
                BorderUtil.drawDoubleLine(g, side, width, r);
            } else {
                BorderUtil.drawSingleLine(g, side, style, width, r);
            }
        } else {
            g.setForegroundColor(ReportColorConstants.ShadowLineColor);
            BorderUtil.drawDefaultLine(g, side, r);
        }
        g.restoreState();
    }

    public void setIndicatorLabel(String indicatorLabel) {
        if (indicatorLabel != null) {
            this.indicatorLabel = indicatorLabel;
        }
    }

    public void setIndicatorIcon(Image image) {
        this.image = image;
    }

    public Rectangle getIndicatorArea() {
        return this.indicatorArea;
    }
}

