/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.ReportColorConstants;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportElementEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.LabelDirectEditPolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ReportComponentEditPolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.LabelFigure;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.LabelCellEditorLocator;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.LabelEditManager;
import org.eclipse.birt.report.designer.internal.ui.util.ElementBuilderFactory;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionBuilder;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.TemplateElementHandle;
import org.eclipse.birt.report.model.api.TemplateReportItemHandle;
import org.eclipse.birt.report.model.api.TextDataHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class PlaceHolderEditPart
extends ReportElementEditPart {
    private DesignElementHandle copiedHandle;

    public PlaceHolderEditPart(Object model) {
        super(model);
    }

    public void elementChanged(DesignElementHandle arg0, NotificationEvent arg1) {
        this.markDirty(true);
        this.refreshVisuals();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ReportComponentEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new LabelDirectEditPolicy());
    }

    public void refreshFigure() {
        StyleHandle style = this.getDefaultHandle().getPrivateStyle();
        ((LabelFigure)this.getFigure()).setFont(this.getFont());
        ((LabelFigure)this.getFigure()).setImage(this.getImage());
        ((LabelFigure)this.getFigure()).setAlignment(8);
        ((LabelFigure)this.getFigure()).setText(this.getTemplateModel().getDisplayDescription());
        ((LabelFigure)this.getFigure()).setTextAlign("center");
        ((LabelFigure)this.getFigure()).setForegroundColor(ReportColorConstants.ShadowLineColor);
        ((LabelFigure)this.getFigure()).setDisplay(style.getDisplay());
        this.getFigure().setBorder((Border)new LineBorder(1));
    }

    protected Font getFont() {
        return this.getFont((ReportItemHandle)this.getDefaultHandle());
    }

    private Image getImage() {
        if (this.getDefaultHandle() instanceof LabelHandle) {
            return ReportPlatformUIImages.getImage("Label");
        }
        if (this.getDefaultHandle() instanceof TextItemHandle) {
            return ReportPlatformUIImages.getImage("Text");
        }
        if (this.getDefaultHandle() instanceof DataItemHandle) {
            return ReportPlatformUIImages.getImage("Data");
        }
        if (this.getDefaultHandle() instanceof TextDataHandle) {
            return ReportPlatformUIImages.getImage("TextData");
        }
        if (this.getDefaultHandle() instanceof ImageHandle) {
            return ReportPlatformUIImages.getImage("Image");
        }
        if (this.getDefaultHandle() instanceof TableHandle) {
            return ReportPlatformUIImages.getImage("Table");
        }
        if (this.getDefaultHandle() instanceof GridHandle) {
            return ReportPlatformUIImages.getImage("Grid");
        }
        if (this.getDefaultHandle() instanceof ListHandle) {
            return ReportPlatformUIImages.getImage("List");
        }
        if (this.getDefaultHandle() instanceof ExtendedItemHandle) {
            return ReportPlatformUIImages.getImage(this.getDefaultHandle());
        }
        return null;
    }

    protected IFigure createFigure() {
        LabelFigure label = new LabelFigure();
        return label;
    }

    public void performDirectEdit() {
        if (this.getModel() instanceof TemplateElementHandle) {
            Object builder = null;
            TemplateElementHandle handle = this.getTemplateModel();
            this.copiedHandle = handle.getDefaultElement().copy().getHandle(handle.getModule());
            this.getCommandStack().startTrans(Messages.getString((String)"PlaceHolderEditPart.Trans.TransferToElement"));
            if (handle.getDefaultElement() instanceof LabelHandle) {
                builder = new LabelEditManager((GraphicalEditPart)this, TextCellEditor.class, new LabelCellEditorLocator((Figure)this.getFigure()));
                ((LabelEditManager)((Object)builder)).setModel(this.copiedHandle);
                ((LabelEditManager)((Object)builder)).show();
            } else {
                if (!(this.copiedHandle instanceof DataItemHandle)) {
                    builder = ElementBuilderFactory.getInstance().createBuilder(this.copiedHandle);
                }
                if (builder == null) {
                    this.performTransfer();
                    this.getCommandStack().commit();
                    return;
                }
                if (((Dialog)builder).open() == 0) {
                    if (builder instanceof ExpressionBuilder) {
                        try {
                            if (this.copiedHandle instanceof TextDataHandle) {
                                ((TextDataHandle)this.copiedHandle).setValueExpr(((ExpressionBuilder)((Object)builder)).getResult());
                            }
                        }
                        catch (SemanticException e) {
                            this.getCommandStack().rollback();
                            return;
                        }
                    }
                    this.performTransfer();
                    this.getCommandStack().commit();
                    return;
                }
                this.getCommandStack().rollback();
                return;
            }
        }
    }

    private CommandStack getCommandStack() {
        return SessionHandleAdapter.getInstance().getCommandStack();
    }

    public Object getCopiedModel() {
        return this.copiedHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performTransfer() {
        if (this.getModel() instanceof TemplateElementHandle) {
            try {
                ((TemplateReportItemHandle)this.getModel()).transformToReportItem((ReportItemHandle)this.copiedHandle);
            }
            catch (SemanticException e) {
                SessionHandleAdapter.getInstance().getCommandStack().rollbackAll();
            }
            finally {
                this.copiedHandle = null;
            }
        }
    }

    public void perfrormLabelEdit(boolean changed) {
        if (changed) {
            this.performTransfer();
            this.getCommandStack().commit();
        } else {
            this.getCommandStack().rollbackAll();
        }
    }

    private DesignElementHandle getDefaultHandle() {
        return this.getTemplateModel().getDefaultElement();
    }

    private TemplateElementHandle getTemplateModel() {
        return (TemplateElementHandle)this.getModel();
    }
}

