/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.ReportDesignHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.ReportDesignMarginBorder;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportElementEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ReportContainerEditPolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ReportFlowLayoutEditPolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.ReportRootFigure;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.RootDragTracker;
import org.eclipse.birt.report.designer.internal.ui.layout.AbstractPageFlowLayout;
import org.eclipse.birt.report.designer.internal.ui.layout.ReportDesignLayout;
import org.eclipse.birt.report.designer.util.ColorManager;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gef.tools.DeselectAllTracker;

public class ReportDesignEditPart
extends ReportElementEditPart {
    protected boolean showMargin = true;

    public ReportDesignEditPart(Object obj) {
        super(obj);
    }

    protected IFigure createFigure() {
        ReportRootFigure figure = new ReportRootFigure();
        figure.setOpaque(true);
        figure.setShowMargin(this.showMargin);
        ReportDesignLayout layout = new ReportDesignLayout((GraphicalEditPart)this);
        SlotHandle slotHandle = ((ModuleHandle)this.getModel()).getMasterPages();
        Iterator iter = slotHandle.iterator();
        SimpleMasterPageHandle masterPageHandle = (SimpleMasterPageHandle)iter.next();
        Dimension size = this.getMasterPageSize((DesignElementHandle)masterPageHandle);
        Rectangle bounds = new Rectangle(0, 0, size.width - 1, size.height - 1);
        layout.setInitSize(bounds);
        figure.setLayoutManager((LayoutManager)layout);
        figure.setBorder((Border)new ReportDesignMarginBorder(this.getMasterPageInsets((DesignElementHandle)masterPageHandle)));
        figure.setBounds(bounds.getCopy());
        return figure;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ReportFlowLayoutEditPolicy());
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new ReportContainerEditPolicy());
    }

    protected List getModelChildren() {
        return HandleAdapterFactory.getInstance().getReportDesignHandleAdapter(this.getModel()).getChildren();
    }

    public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
        switch (ev.getEventType()) {
            case 0: 
            case 6: {
                this.refresh();
                break;
            }
            case 5: 
            case 15: 
            case 17: {
                this.refresh();
                this.markDirty(true);
                break;
            }
            case 19: {
                this.reloadTheChildren();
            }
        }
    }

    public DragTracker getDragTracker(Request req) {
        if (req instanceof SelectionRequest && ((SelectionRequest)req).getLastButtonPressed() == 3) {
            return new DeselectAllTracker((EditPart)this);
        }
        return new RootDragTracker();
    }

    public void refreshFigure() {
        SlotHandle slotHandle = ((ModuleHandle)this.getModel()).getMasterPages();
        Iterator iter = slotHandle.iterator();
        SimpleMasterPageHandle masterPageHandle = (SimpleMasterPageHandle)iter.next();
        Dimension size = this.getMasterPageSize((DesignElementHandle)masterPageHandle);
        Rectangle bounds = new Rectangle(0, 0, size.width - 1, size.height - 1);
        ReportRootFigure figure = (ReportRootFigure)this.getFigure();
        figure.setShowMargin(this.showMargin);
        if (!this.showMargin) {
            Insets mg = this.getMasterPageInsets((DesignElementHandle)masterPageHandle);
            bounds.width -= mg.getWidth();
            bounds.height -= mg.getHeight();
        }
        ((AbstractPageFlowLayout)this.getFigure().getLayoutManager()).setInitSize(bounds);
        ReportDesignMarginBorder reportDesignMarginBorder = new ReportDesignMarginBorder(this.getMasterPageInsets((DesignElementHandle)masterPageHandle));
        reportDesignMarginBorder.setBackgroundColor(masterPageHandle.getProperty("backgroundColor"));
        this.getFigure().setBorder((Border)reportDesignMarginBorder);
        int color = this.getBackgroundColor((DesignElementHandle)masterPageHandle);
        this.getFigure().setBackgroundColor(ColorManager.getColor((int)color));
        this.refreshBackground((DesignElementHandle)masterPageHandle);
    }

    protected void notifyChildrenDirty(boolean bool) {
        super.notifyChildrenDirty(bool);
        this.refreshVisuals();
    }

    public void activate() {
        super.activate();
        if (((ReportDesignHandleAdapter)this.getModelAdapter()).getMasterPage() != null) {
            ((ReportDesignHandleAdapter)this.getModelAdapter()).getMasterPage().addListener((Listener)this);
        }
        this.getFigure().setFocusTraversable(false);
        this.getViewer().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("Property Margin Visibility".equals(evt.getPropertyName())) {
                    ReportDesignEditPart.this.showMargin = (Boolean)evt.getNewValue();
                    ReportDesignEditPart.this.refresh();
                    ReportDesignEditPart.this.markDirty(true);
                }
            }
        });
    }

    public void deactivate() {
        super.deactivate();
        if (((ReportDesignHandleAdapter)this.getModelAdapter()).getMasterPage() != null) {
            ((ReportDesignHandleAdapter)this.getModelAdapter()).getMasterPage().removeListener((Listener)this);
        }
    }
}

