/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures;

import org.eclipse.birt.report.designer.internal.ui.editors.ReportColorConstants;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.ReportElementFigure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;

public class ReportRootFigure
extends ReportElementFigure {
    private static final Insets DEFAULT_MARGIN = new Insets(3, 3, 3, 3);
    private static final Point PRIVATE_POINT = new Point();
    private static final Insets DEFAULT_CROP = new Insets(-3, -3, -2, -2);
    private boolean showMargin;

    protected void paintBorder(Graphics graphics) {
    }

    public Insets getInsets() {
        if (this.showMargin) {
            if (this.getBorder() != null) {
                return this.getBorder().getInsets((IFigure)this);
            }
            return NO_INSETS;
        }
        return DEFAULT_MARGIN;
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        graphics.setForegroundColor(ReportColorConstants.MarginBorderColor);
        graphics.drawRectangle(this.getBounds().getCopy().crop(this.getInsets()).crop(DEFAULT_CROP));
    }

    protected void paintChildren(Graphics graphics) {
        for (int i = 0; i < this.getChildren().size(); ++i) {
            IFigure child = (IFigure)this.getChildren().get(i);
            if (!child.isVisible()) continue;
            graphics.setClip(this.getBounds().getCopy().intersect(child.getBounds()));
            child.paint(graphics);
            graphics.restoreState();
        }
    }

    protected IFigure findDescendantAtExcluding(int x, int y, TreeSearch search) {
        PRIVATE_POINT.setLocation(x, y);
        this.translateFromParent((Translatable)PRIVATE_POINT);
        if (!this.getBounds().contains(PRIVATE_POINT)) {
            return null;
        }
        int i = this.getChildren().size();
        while (i > 0) {
            IFigure fig = (IFigure)this.getChildren().get(--i);
            if (!fig.isVisible() || (fig = fig.findFigureAt(ReportRootFigure.PRIVATE_POINT.x, ReportRootFigure.PRIVATE_POINT.y, search)) == null) continue;
            return fig;
        }
        return null;
    }

    public boolean isShowMargin() {
        return this.showMargin;
    }

    public void setShowMargin(boolean showMargin) {
        this.showMargin = showMargin;
    }
}

