/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures;

import java.lang.reflect.Field;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.FlowBoxWrapper;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.text.FlowBox;
import org.eclipse.draw2d.text.TextFragmentBox;

public class TextFlow
extends org.eclipse.draw2d.text.TextFlow {
    static int LINE_FACTOR;
    static String ELLIPSIS;
    static Field TRUNCATED;
    private String textUnderline = "none";
    private String textLineThrough = "none";
    private String textOverline = "none";
    private String textAlign = "left";
    private String verticalAlign = "top";
    static final /* synthetic */ boolean $assertionsDisabled;

    public void paintTo(Graphics g, Point translationPoint) {
        this.paintTo(g, translationPoint.x, translationPoint.y);
    }

    public void paintTo(Graphics g, int xoff, int yoff) {
        FlowBoxWrapper wrapper;
        int i;
        List fragments = this.getFragments();
        if (!$assertionsDisabled && this.getFont().getFontData().length <= 0) {
            throw new AssertionError();
        }
        int lineWidth = this.getFont().getFontData()[0].getHeight() / LINE_FACTOR + 1;
        int totalHeight = 0;
        for (i = 0; i < fragments.size(); ++i) {
            wrapper = new FlowBoxWrapper((FlowBox)fragments.get(i));
            totalHeight += wrapper.getHeight();
        }
        for (i = 0; i < fragments.size(); ++i) {
            TextFragmentBox frag = (TextFragmentBox)fragments.get(i);
            wrapper = new FlowBoxWrapper((FlowBox)frag);
            String draw = null;
            try {
                draw = TRUNCATED != null && TRUNCATED.getBoolean(frag) ? this.getText().substring(frag.offset, frag.offset + frag.length) + ELLIPSIS : this.getText().substring(frag.offset, frag.offset + frag.length);
            }
            catch (IllegalArgumentException e) {
                ExceptionHandler.handle(e);
            }
            catch (IllegalAccessException e) {
                ExceptionHandler.handle(e);
            }
            int left = this.calculateLeft(this.getSize().width, frag.getWidth());
            int top = this.calculateTop(this.getSize().height, totalHeight);
            int realX = wrapper.getX() + left + xoff;
            int realY = wrapper.getY() + top + yoff;
            if (!this.isEnabled()) {
                g.setForegroundColor(ColorConstants.buttonLightest);
                g.drawString(draw, realX + 1, realY + 1);
                g.setForegroundColor(ColorConstants.buttonDarker);
                g.drawString(draw, realX, realY);
            } else {
                g.drawString(draw, realX, realY);
            }
            if (frag.getWidth() > 1) {
                g.setLineWidth(lineWidth);
                if (this.textUnderline.equals("underline")) {
                    g.drawLine(realX, realY + wrapper.getHeight() - 1, realX + frag.getWidth(), realY + wrapper.getHeight() - 1);
                }
                if (this.textLineThrough.equals("line-through")) {
                    g.drawLine(realX, realY + (wrapper.getHeight() - lineWidth) / 2, realX + frag.getWidth(), realY + (wrapper.getHeight() - lineWidth) / 2);
                }
                if (this.textOverline.equals("overline")) {
                    g.drawLine(realX, realY + 1, realX + frag.getWidth(), realY + 1);
                }
            }
            g.restoreState();
        }
    }

    protected void paintFigure(Graphics g) {
        this.paintTo(g, 0, 0);
    }

    protected int calculateLeft(int compWidth, int textWidth) {
        int rlt = 0;
        if (this.textAlign.equals("left") || this.textAlign.equals("justify")) {
            rlt = 0;
        } else if (this.textAlign.equals("center")) {
            rlt = (compWidth - textWidth) / 2;
        } else if (this.textAlign.equals("right")) {
            rlt = compWidth - textWidth;
        }
        return rlt;
    }

    protected int calculateTop(int compHeight, int textHeight) {
        int rlt = 0;
        if (this.verticalAlign.equals("top") || this.verticalAlign.equals("baseline")) {
            rlt = 0;
        } else if (this.verticalAlign.equals("middle")) {
            rlt = (compHeight - textHeight) / 2;
        } else if (this.verticalAlign.equals("bottom")) {
            rlt = compHeight - textHeight;
        }
        return rlt;
    }

    public void setTextAlign(String textAlign) {
        this.textAlign = textAlign;
    }

    public String getTextAlign() {
        return this.textAlign;
    }

    public void setTextOverline(String textOverline) {
        this.textOverline = textOverline;
    }

    public void setTextLineThrough(String textLineThrough) {
        this.textLineThrough = textLineThrough;
    }

    public void setTextUnderline(String textUnderline) {
        this.textUnderline = textUnderline;
    }

    public void setVerticalAlign(String verticalAlign) {
        this.verticalAlign = verticalAlign;
    }

    static {
        $assertionsDisabled = !TextFlow.class.desiredAssertionStatus();
        LINE_FACTOR = 24;
        ELLIPSIS = "...";
        try {
            Field ellipsis = org.eclipse.draw2d.text.TextFlow.class.getDeclaredField("ELLIPSIS");
            ellipsis.setAccessible(true);
            ELLIPSIS = (String)ellipsis.get(new org.eclipse.draw2d.text.TextFlow());
        }
        catch (SecurityException e) {
            ExceptionHandler.handle(e);
        }
        catch (NoSuchFieldException e) {
            ExceptionHandler.handle(e);
        }
        catch (IllegalArgumentException e) {
            ExceptionHandler.handle(e);
        }
        catch (IllegalAccessException e) {
            ExceptionHandler.handle(e);
        }
        try {
            TRUNCATED = TextFragmentBox.class.getDeclaredField("truncated");
            TRUNCATED.setAccessible(true);
        }
        catch (SecurityException e) {
            ExceptionHandler.handle(e);
        }
        catch (NoSuchFieldException e) {
            ExceptionHandler.handle(e);
        }
    }
}

