/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles;

import org.eclipse.birt.report.designer.internal.ui.editors.ReportColorConstants;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles.AbstractGuideHandle;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gef.handles.MoveHandleLocator;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class TableGuideHandle
extends AbstractGuideHandle {
    protected Image image;
    protected String indicatorLabel = "  ";
    private static final Dimension DEFAULT_VALUE = new Dimension(40, 20);
    protected Insets gapInsets = new Insets(3, 3, 3, 3);
    int gap;

    public TableGuideHandle(GraphicalEditPart owner) {
        super(owner, (Locator)new TableGuideHandleLocator(owner));
    }

    public void paintFigure(Graphics graphics) {
        Dimension rect = this.calculateIndicatorDimension(graphics, 1);
        int width = 1;
        if (!this.getBounds().getSize().equals((Object)rect)) {
            this.setSize(rect);
        }
        Rectangle bounds = this.getBounds().getCopy();
        bounds.y += 2;
        graphics.setBackgroundColor(ReportColorConstants.TableGuideFillColor);
        graphics.fillRectangle(bounds);
        graphics.setForegroundColor(ReportColorConstants.ShadowLineColor);
        bounds = this.getBounds().getCopy();
        graphics.drawLine(bounds.x, bounds.y, bounds.x, bounds.y + bounds.height);
        graphics.drawLine(bounds.x, bounds.y + bounds.height - 1, bounds.x + bounds.width, bounds.y + bounds.height - 1);
        graphics.drawLine(bounds.x + bounds.width - 1, bounds.y, bounds.x + bounds.width - 1, bounds.y + bounds.height);
        graphics.setForegroundColor(ReportColorConstants.TableGuideFillColor);
        graphics.drawLine(bounds.x, bounds.y, bounds.x + bounds.width - 1, bounds.y);
        int x = this.getBounds().x + this.gapInsets.left;
        if (this.image != null) {
            graphics.drawImage(this.image, x, bounds.y + this.gapInsets.top);
            x += this.image.getBounds().width + this.gap;
        }
        graphics.setForegroundColor(ReportColorConstants.TableGuideTextColor);
        graphics.drawString(this.indicatorLabel, x + 2 * width, bounds.y + 2 + this.gapInsets.top - width);
    }

    private Dimension calculateIndicatorDimension(Graphics g, int width) {
        this.gap = 0;
        Dimension iconDimension = new Dimension();
        if (this.image != null) {
            iconDimension = new Dimension(this.image);
            this.gap = 2;
        }
        Dimension d = FigureUtilities.getTextExtents((String)this.indicatorLabel, (Font)g.getFont());
        int incheight = 0;
        if (iconDimension.height > d.height) {
            incheight = iconDimension.height - d.height;
        }
        d.expand(iconDimension.width + this.gap + this.gapInsets.left + this.gapInsets.right + 2 * width + 2, incheight + this.gapInsets.top + this.gapInsets.bottom);
        return d;
    }

    public void setIndicatorLabel(String indicatorLabel) {
        if (indicatorLabel != null) {
            this.indicatorLabel = indicatorLabel;
        }
    }

    public void setIndicatorIcon(Image image) {
        this.image = image;
    }

    private static class TableGuideHandleLocator
    extends MoveHandleLocator {
        private GraphicalEditPart owner;

        public TableGuideHandleLocator(GraphicalEditPart part) {
            super(part.getFigure());
            this.setOwner(part);
        }

        public void relocate(IFigure target) {
            Rectangle bounds = this.getReference() instanceof HandleBounds ? ((HandleBounds)this.getReference()).getHandleBounds() : this.getReference().getBounds();
            bounds = new PrecisionRectangle(new Rectangle(bounds.x, bounds.y + bounds.height, DEFAULT_VALUE.width, DEFAULT_VALUE.height));
            this.getReference().translateToAbsolute((Translatable)bounds);
            target.translateToRelative((Translatable)bounds);
            target.setBounds(bounds);
        }

        public GraphicalEditPart getOwner() {
            return this.owner;
        }

        public void setOwner(GraphicalEditPart owner) {
            this.owner = owner;
        }
    }
}

