/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.internal.ui.layout.ListData;
import org.eclipse.draw2d.AbstractHintLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class ListLayout
extends AbstractHintLayout {
    protected Map constraints = new HashMap();
    private static final int verticalSpan = 2;

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        Dimension dim = container.getClientArea().getCopy().getSize();
        List list = container.getChildren();
        int size = list.size();
        int height = 0;
        for (int i = 0; i < size; ++i) {
            IFigure figure = (IFigure)list.get(i);
            height += figure.getPreferredSize((int)dim.width, (int)hHint).height;
        }
        if (height > 0) {
            dim.height = height + container.getInsets().getHeight() + (size - 1) * 2;
        }
        if (wHint > 0) {
            dim.width = wHint;
        }
        return dim;
    }

    public void layout(IFigure parent) {
        Object data;
        Rectangle bounds = parent.getClientArea().getCopy();
        List list = parent.getChildren();
        int size = list.size();
        ArrayList<ListLayoutWorkingData> datas = new ArrayList<ListLayoutWorkingData>();
        for (int i = 0; i < size; ++i) {
            IFigure figure = (IFigure)list.get(i);
            data = (ListData)this.getConstraint(figure);
            ListLayoutWorkingData workingData = new ListLayoutWorkingData(figure, ((ListData)data).order);
            datas.add(workingData);
        }
        Collections.sort(datas, new ListDataComparator());
        int height = 0;
        for (int i = 0; i < size; ++i) {
            data = (ListLayoutWorkingData)datas.get(i);
            IFigure figure = ((ListLayoutWorkingData)data).child;
            Dimension dim = figure.getPreferredSize(bounds.width, -1);
            ((ListLayoutWorkingData)data).bounds = new Rectangle(0, height, dim.width, dim.height);
            height = height + dim.height + 2;
            this.setBoundsOfChild(parent, figure, ((ListLayoutWorkingData)data).bounds);
        }
    }

    protected void setBoundsOfChild(IFigure parent, IFigure child, Rectangle bounds) {
        parent.getClientArea(Rectangle.SINGLETON);
        bounds.translate(Rectangle.SINGLETON.x, Rectangle.SINGLETON.y);
        if (!bounds.equals((Object)child.getBounds())) {
            child.setBounds(bounds);
        }
    }

    public Object getConstraint(IFigure figure) {
        return this.constraints.get(figure);
    }

    public void remove(IFigure figure) {
        super.remove(figure);
        this.constraints.remove(figure);
    }

    public void setConstraint(IFigure figure, Object newConstraint) {
        super.setConstraint(figure, newConstraint);
        if (newConstraint != null) {
            this.constraints.put(figure, newConstraint);
        }
    }

    protected Dimension calculateMinimumSize(IFigure container, int wHint, int hHint) {
        Dimension dim = new Dimension();
        List list = container.getChildren();
        int size = list.size();
        int height = 0;
        int width = 0;
        for (int i = 0; i < size; ++i) {
            IFigure figure = (IFigure)list.get(i);
            Dimension min = figure.getMinimumSize(wHint, hHint);
            height += min.height;
            if (min.width <= width) continue;
            width = min.width;
        }
        if (height > 0) {
            dim.height = height + container.getInsets().getHeight() + (size - 1) * 2;
        }
        dim.width = width + container.getInsets().getWidth();
        return dim;
    }

    private static class ListDataComparator
    implements Comparator {
        private ListDataComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof ListLayoutWorkingData && o2 instanceof ListLayoutWorkingData) {
                return ((ListLayoutWorkingData)o1).order - ((ListLayoutWorkingData)o2).order;
            }
            return 0;
        }
    }

    static class ListLayoutWorkingData {
        public IFigure child;
        public int order;
        public Rectangle bounds;

        public ListLayoutWorkingData(IFigure child, int order) {
            this.child = child;
            this.order = order;
        }

        public Rectangle getBounds() {
            return this.bounds;
        }

        public void setBounds(Rectangle bounds) {
            this.bounds = bounds;
        }
    }
}

