/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.util;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ScriptOrFnNode;

public class ExpressionUtility {
    private static final String STRING_ROW = "row";
    private static final int EXPR_CACHE_SIZE = 50;
    private static Map compiledExprCache;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isColumnExpression(String expression) {
        ScriptOrFnNode tree;
        boolean isColumn = false;
        if (expression == null || expression.trim().length() == 0) {
            return isColumn;
        }
        if (compiledExprCache.containsKey(expression)) {
            return (Boolean)compiledExprCache.get(expression);
        }
        Context context = Context.enter();
        try {
            CompilerEnvirons m_compilerEnv = new CompilerEnvirons();
            m_compilerEnv.initFromContext(context);
            Parser p = new Parser(m_compilerEnv, context.getErrorReporter());
            tree = p.parse(expression, null, 0);
        }
        catch (Exception e) {
            compiledExprCache.put(expression, false);
            boolean p = false;
            return p;
        }
        finally {
            Context.exit();
        }
        if (tree.getFirstChild() == tree.getLastChild()) {
            if (tree.getFirstChild().getType() != 130 && tree.getFirstChild().getType() != 129 && tree.getFirstChild().getType() != 125) {
                isColumn = false;
            }
            Node exprNode = tree.getFirstChild();
            Node child = exprNode.getFirstChild();
            if (!$assertionsDisabled && child == null) {
                throw new AssertionError();
            }
            isColumn = child.getType() == 35 || child.getType() == 33 ? ExpressionUtility.getDirectColRefExpr(child) : false;
        } else {
            isColumn = false;
        }
        compiledExprCache.put(expression, isColumn);
        return isColumn;
    }

    public static String getReplacedColRefExpr(String columnStr) {
        if (ExpressionUtility.isColumnExpression(columnStr)) {
            return columnStr.replaceFirst("\\Qrow\\E", "dataSetRow");
        }
        return columnStr;
    }

    private static boolean getDirectColRefExpr(Node refNode) {
        if (!$assertionsDisabled && refNode.getType() != 33 && refNode.getType() != 35) {
            throw new AssertionError();
        }
        Node rowName = refNode.getFirstChild();
        if (!$assertionsDisabled && rowName == null) {
            throw new AssertionError();
        }
        if (rowName.getType() != 38) {
            return false;
        }
        String str = rowName.getString();
        if (!$assertionsDisabled && str == null) {
            throw new AssertionError();
        }
        if (!str.equals(STRING_ROW)) {
            return false;
        }
        Node rowColumn = rowName.getNext();
        if (!$assertionsDisabled && rowColumn == null) {
            throw new AssertionError();
        }
        if (refNode.getType() == 33 && rowColumn.getType() == 40) {
            return true;
        }
        return refNode.getType() == 35 && (rowColumn.getType() == 39 || rowColumn.getType() == 40);
    }

    static {
        $assertionsDisabled = !ExpressionUtility.class.desiredAssertionStatus();
        compiledExprCache = Collections.synchronizedMap(new LinkedHashMap(50, 0.75f, true){
            private static final long serialVersionUID = 54331232145454L;

            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > 50;
            }
        });
    }
}

