/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.Bidi;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.regex.Pattern;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.runtime.GUIException;
import org.eclipse.birt.report.designer.internal.ui.dialogs.ImportLibraryDialog;
import org.eclipse.birt.report.designer.internal.ui.editors.IReportEditor;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.DeferredGraphicalViewer;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.DummyEditpart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.GridEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ListBandEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ListEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableCellEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableEditPart;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.dialogs.GroupDialog;
import org.eclipse.birt.report.designer.ui.editors.AbstractMultiPageEditor;
import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.ColumnLayout;
import org.eclipse.ui.forms.widgets.ILayoutExtension;
import org.osgi.framework.Bundle;

public class UIUtil {
    private static final String MSG_DIALOG_TITLE = Messages.getString((String)"ImportLibraryAction.Title.ImportSuccessfully");
    private static final String MSG_DIALOG_MSG = Messages.getString((String)"ImportLibraryAction.Message.ImportSuccessfully");
    static Pattern punctuation = Pattern.compile("\\p{Punct}||\\p{Blank}||\\p{Space}");
    public static Object listArea;

    public static int getStringWidth(String string, Control control) {
        int width = 0;
        GC gc = new GC((Drawable)control);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            width += gc.getAdvanceWidth(c);
        }
        gc.dispose();
        return width;
    }

    public static String AddQuote(String string) {
        if (!(string == null || string.startsWith("\"") && string.endsWith("\""))) {
            return "\"" + string + "\"";
        }
        return string;
    }

    public static String RemoveQuote(String string) {
        if (string != null && string.length() >= 2 && string.startsWith("\"") && string.endsWith("\"")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static int getMaxStringWidth(String[] strArray, Control control) {
        int maxWidth = 0;
        for (int i = 0; i < strArray.length; ++i) {
            int width = UIUtil.getStringWidth(strArray[i], control);
            maxWidth = maxWidth >= width ? maxWidth : width;
        }
        return maxWidth;
    }

    public static boolean isReportEditorActivated() {
        return UIUtil.getActiveReportEditor() != null;
    }

    public static FormEditor getActiveReportEditor() {
        return UIUtil.getActiveReportEditor(true);
    }

    public static FormEditor getActiveReportEditor(boolean activePageOnly) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            if (activePageOnly) {
                IEditorPart editor;
                IWorkbenchPage pg = window.getActivePage();
                if (pg != null && (editor = pg.getActiveEditor()) != null) {
                    if (editor instanceof IReportEditor) {
                        IEditorPart part = ((IReportEditor)editor).getEditorPart();
                        if (part instanceof FormEditor) {
                            return (FormEditor)part;
                        }
                    } else if (editor instanceof FormEditor) {
                        return (FormEditor)editor;
                    }
                }
            } else {
                IWorkbenchPage[] pgs = window.getPages();
                for (int i = 0; i < pgs.length; ++i) {
                    IWorkbenchPage pg = pgs[i];
                    if (pg == null) continue;
                    IEditorPart editor = pg.getActiveEditor();
                    if (editor instanceof IReportEditor) {
                        IEditorPart part = ((IReportEditor)editor).getEditorPart();
                        if (!(part instanceof FormEditor)) continue;
                        return (FormEditor)part;
                    }
                    if (!(editor instanceof FormEditor)) continue;
                    return (FormEditor)editor;
                }
            }
        }
        return null;
    }

    public static IEditorPart getActiveEditor(boolean activePageOnly) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            if (activePageOnly) {
                IWorkbenchPage pg = window.getActivePage();
                if (pg != null) {
                    return pg.getActiveEditor();
                }
            } else {
                IWorkbenchPage[] pgs = window.getPages();
                for (int i = 0; i < pgs.length; ++i) {
                    IEditorPart editor;
                    IWorkbenchPage pg = pgs[i];
                    if (pg == null || (editor = pg.getActiveEditor()) == null) continue;
                    return editor;
                }
            }
        }
        return null;
    }

    public static IProject getDefaultProject() {
        IResource resource;
        IWorkbenchWindow benchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPart part = benchWindow.getPartService().getActivePart();
        Object selection = null;
        if (part instanceof IEditorPart) {
            selection = ((IEditorPart)part).getEditorInput();
        } else {
            ISelection sel = benchWindow.getSelectionService().getSelection();
            if (sel != null && sel instanceof IStructuredSelection) {
                selection = ((IStructuredSelection)sel).getFirstElement();
            }
        }
        if (selection instanceof IAdaptable && (resource = (IResource)((IAdaptable)selection).getAdapter(IResource.class)) != null && resource.getProject() != null && resource.getProject().isAccessible()) {
            return resource.getProject();
        }
        IProject[] pjs = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        for (int i = 0; i < pjs.length; ++i) {
            if (!pjs[i].isAccessible()) continue;
            return pjs[i];
        }
        return null;
    }

    public static Shell getDefaultShell() {
        Shell shell = null;
        try {
            shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
            if (shell == null) {
                shell = Display.getCurrent().getActiveShell();
            }
            if (shell == null) {
                shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (shell == null) {
            return new Shell();
        }
        return shell;
    }

    public static ElementFactory getElementFactory() {
        return SessionHandleAdapter.getInstance().getReportDesignHandle().getElementFactory();
    }

    public static boolean createGroup(DesignElementHandle parent) {
        Assert.isNotNull((Object)parent);
        try {
            return UIUtil.addGroup(parent, -1);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
            return false;
        }
    }

    public static boolean createGroup(DesignElementHandle parent, int position) {
        Assert.isNotNull((Object)parent);
        try {
            return UIUtil.addGroup(parent, position);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
            return false;
        }
    }

    private static boolean addGroup(DesignElementHandle parent, int position) throws SemanticException {
        TableGroupHandle groupHandle = null;
        SlotHandle slotHandle = null;
        DesignElementFactory factory = DesignElementFactory.getInstance(parent.getModuleHandle());
        if (parent instanceof TableHandle) {
            groupHandle = factory.newTableGroup();
            slotHandle = ((TableHandle)parent).getGroups();
            int columnCount = ((TableHandle)parent).getColumnCount();
            groupHandle.getHeader().add((DesignElementHandle)factory.newTableRow(columnCount));
            groupHandle.getFooter().add((DesignElementHandle)factory.newTableRow(columnCount));
        } else if (parent instanceof ListHandle) {
            groupHandle = factory.newListGroup();
            slotHandle = ((ListHandle)parent).getGroups();
        }
        if (groupHandle != null && slotHandle != null) {
            slotHandle.add((DesignElementHandle)groupHandle, position);
            GroupDialog dialog = new GroupDialog(UIUtil.getDefaultShell(), GroupDialog.GROUP_DLG_TITLE_NEW);
            dialog.setInput(groupHandle);
            return dialog.open() != 1;
        }
        return false;
    }

    public static EditPart getCurrentEditPart() {
        EditPartViewer viewer = UIUtil.getLayoutEditPartViewer();
        if (viewer == null) {
            return null;
        }
        IStructuredSelection targets = (IStructuredSelection)viewer.getSelection();
        if (targets.isEmpty()) {
            return null;
        }
        return (EditPart)targets.getFirstElement();
    }

    public static EditPartViewer getLayoutEditPartViewer() {
        IEditorPart activeEditor;
        IEditorPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        AbstractMultiPageEditor reportEditor = null;
        if (part instanceof AbstractMultiPageEditor) {
            reportEditor = (AbstractMultiPageEditor)part;
        } else if (part instanceof IReportEditor && (activeEditor = ((IReportEditor)part).getEditorPart()) instanceof AbstractMultiPageEditor) {
            reportEditor = (AbstractMultiPageEditor)activeEditor;
        }
        if (reportEditor == null || !(reportEditor.getActivePageInstance() instanceof GraphicalEditorWithFlyoutPalette)) {
            return null;
        }
        return ((GraphicalEditorWithFlyoutPalette)reportEditor.getActivePageInstance()).getGraphicalViewer();
    }

    public static GridLayout createGridLayoutWithoutMargin() {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        return layout;
    }

    public static GridLayout createGridLayoutWithoutMargin(int numsColumn, boolean makeColumnsEqualWidth) {
        GridLayout layout = new GridLayout(numsColumn, makeColumnsEqualWidth);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        return layout;
    }

    public static String convertToGUIString(String string) {
        if (string == null) {
            string = "";
        }
        return string;
    }

    public static String convertToModelString(String string, boolean trim) {
        if (string == null) {
            return null;
        }
        if (trim) {
            string = string.trim();
        }
        if (string.length() == 0) {
            string = null;
        }
        return string;
    }

    public static int getWidthHint(int wHint, Control c) {
        boolean wrap = UIUtil.isWrapControl(c);
        return wrap ? wHint : -1;
    }

    public static int getHeightHint(int hHint, Control c) {
        Layout layout;
        if (c instanceof Composite && (layout = ((Composite)c).getLayout()) instanceof ColumnLayout) {
            return hHint;
        }
        return -1;
    }

    public static void updatePageIncrement(ScrolledComposite scomp) {
        ScrollBar vbar = scomp.getVerticalBar();
        if (vbar != null) {
            Rectangle clientArea = scomp.getClientArea();
            int increment = clientArea.height - 5;
            vbar.setPageIncrement(increment);
        }
    }

    private static boolean isWrapControl(Control c) {
        if (c instanceof Composite) {
            return ((Composite)c).getLayout() instanceof ILayoutExtension;
        }
        return (c.getStyle() & 0x40) != 0;
    }

    public static TableEditPart getTableEditPart(List editParts) {
        if (editParts == null || editParts.isEmpty()) {
            return null;
        }
        int size = editParts.size();
        TableEditPart part = null;
        for (int i = 0; i < size; ++i) {
            Object obj = editParts.get(i);
            TableEditPart currentEditPart = null;
            if (obj instanceof TableEditPart) {
                currentEditPart = (TableEditPart)((Object)obj);
            } else if (obj instanceof TableCellEditPart) {
                currentEditPart = (TableEditPart)((TableCellEditPart)((Object)obj)).getParent();
            } else if (obj instanceof DummyEditpart) continue;
            if (part == null) {
                part = currentEditPart;
            }
            if (currentEditPart != null && (currentEditPart == null || part == currentEditPart)) continue;
            return null;
        }
        if (part instanceof GridEditPart) {
            return null;
        }
        return part;
    }

    public static ListEditPart getListEditPart(List editParts) {
        if (editParts == null || editParts.isEmpty()) {
            return null;
        }
        int size = editParts.size();
        ListEditPart part = null;
        for (int i = 0; i < size; ++i) {
            Object obj = editParts.get(i);
            ListEditPart currentEditPart = null;
            if (obj instanceof ListEditPart) {
                currentEditPart = (ListEditPart)((Object)obj);
            } else if (obj instanceof ListBandEditPart) {
                currentEditPart = (ListEditPart)((ListBandEditPart)((Object)obj)).getParent();
            }
            if (part == null) {
                part = currentEditPart;
            }
            if (currentEditPart != null && (currentEditPart == null || part == currentEditPart)) continue;
            return null;
        }
        return part;
    }

    public static boolean containElement(AbstractTreeViewer treeViewer, Object element) {
        ITreeContentProvider provider = (ITreeContentProvider)treeViewer.getContentProvider();
        Object input = treeViewer.getInput();
        if (input instanceof Object[]) {
            Object[] inputs = (Object[])input;
            for (int i = 0; i < inputs.length; ++i) {
                if (!UIUtil.containElement(inputs[i], provider, element)) continue;
                return true;
            }
            return false;
        }
        return UIUtil.containElement(input, provider, element);
    }

    private static boolean containElement(Object parent, ITreeContentProvider provider, Object element) {
        if (parent == null) {
            return false;
        }
        if (parent == element || parent.equals(element)) {
            return true;
        }
        if (provider == null) {
            return false;
        }
        Object[] children = provider.getChildren(parent);
        for (int i = 0; i < children.length; ++i) {
            if (!UIUtil.containElement(children[i], provider, element)) continue;
            return true;
        }
        return false;
    }

    public static String getPluginProvider(String pluginId) {
        return UIUtil.getBundleValue(pluginId, "Bundle-Vendor");
    }

    public static String getPluginName(String pluginId) {
        return UIUtil.getBundleValue(pluginId, "Bundle-Name");
    }

    public static String getPluginVersion(String pluginId) {
        return UIUtil.getBundleValue(pluginId, "Bundle-Version");
    }

    private static String getBundleValue(String pluginId, String key) {
        Assert.isNotNull((Object)pluginId);
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle != null) {
            return (String)bundle.getHeaders().get(key);
        }
        return null;
    }

    public static void resetViewSelection(EditPartViewer viewer, boolean notofyToMedia) {
        ArrayList list = new ArrayList(((StructuredSelection)viewer.getSelection()).toList());
        boolean hasColumnOrRow = false;
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof TableEditPart.DummyRowEditPart) && !(list.get(i) instanceof TableEditPart.DummyColumnEditPart)) continue;
            hasColumnOrRow = true;
            break;
        }
        if (hasColumnOrRow) {
            boolean selectionType = false;
            TableEditPart part = null;
            int[] selectContents = new int[]{};
            for (int i = 0; i < list.size(); ++i) {
                Object obj = list.get(i);
                int number = -1;
                if (obj instanceof TableEditPart.DummyRowEditPart) {
                    selectionType = false;
                    number = ((TableEditPart.DummyRowEditPart)((Object)obj)).getRowNumber();
                } else if (obj instanceof TableEditPart.DummyColumnEditPart) {
                    selectionType = true;
                    number = ((TableEditPart.DummyColumnEditPart)((Object)obj)).getColumnNumber();
                } else if (obj instanceof TableCellEditPart) {
                    part = (TableEditPart)((TableCellEditPart)((Object)obj)).getParent();
                }
                if (number == -1) continue;
                int lenegth = selectContents.length;
                int[] temp = new int[lenegth + 1];
                System.arraycopy(selectContents, 0, temp, 0, lenegth);
                temp[lenegth] = number;
                selectContents = temp;
            }
            if (part == null || selectContents.length == 0 || !viewer.getControl().isVisible()) {
                return;
            }
            if (!selectionType) {
                part.selectRow(selectContents, notofyToMedia);
            } else if (selectionType) {
                part.selectColumn(selectContents, notofyToMedia);
            }
        } else if (viewer.getControl().isVisible() && viewer instanceof DeferredGraphicalViewer) {
            ((DeferredGraphicalViewer)viewer).setSelection((ISelection)new StructuredSelection(list), notofyToMedia);
        }
    }

    public static void createFolder(IFolder folderHandle, IProgressMonitor monitor) throws CoreException {
        try {
            if (!folderHandle.exists()) {
                IPath path = folderHandle.getFullPath();
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                int numSegments = path.segmentCount();
                if (numSegments > 2 && !root.getFolder(path.removeLastSegments(1)).exists()) {
                    for (int i = numSegments - 2; i > 0; --i) {
                        IFolder folder = root.getFolder(path.removeLastSegments(i));
                        if (folder.exists()) continue;
                        folder.create(false, true, monitor);
                    }
                }
                folderHandle.create(false, true, monitor);
            }
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 374) {
                folderHandle.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 500));
            }
            throw e;
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public static String getHomeDirectory() {
        URL url = ReportPlugin.getDefault().getBundle().getEntry("/");
        String home = null;
        try {
            home = Platform.resolve((URL)url).getPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return home;
    }

    public static Label createBlankLabel(Composite parent) {
        Label label = new Label(parent, 0);
        label.setVisible(false);
        return label;
    }

    public static boolean includeLibrary(ModuleHandle moduleHandle, String libraryPath) throws DesignFileException, SemanticException {
        String namespace = UIUtil.getLibraryNamespace(moduleHandle, libraryPath);
        if (namespace != null) {
            moduleHandle.includeLibrary(DEUtil.getRelativedPath((String)ReportPlugin.getDefault().getResourcePreference(), (String)libraryPath), namespace);
            return true;
        }
        return false;
    }

    public static boolean includeLibrary(ModuleHandle moduleHandle, LibraryHandle libraryHandle) throws DesignFileException, SemanticException {
        if (moduleHandle != libraryHandle && !moduleHandle.isInclude(libraryHandle)) {
            return UIUtil.includeLibrary(moduleHandle, libraryHandle.getFileName());
        }
        return true;
    }

    public static boolean includeLibrary(LibraryHandle libraryHandle) throws DesignFileException, SemanticException {
        return UIUtil.includeLibrary(SessionHandleAdapter.getInstance().getReportDesignHandle(), libraryHandle);
    }

    public static String getSimpleFileName(String filePath) {
        return new File(filePath).getName();
    }

    private static String getLibraryNamespace(ModuleHandle handle, String libraryPath) {
        String namespace = UIUtil.getSimpleFileName(libraryPath).split("\\.")[0];
        if (handle.getLibrary(namespace) != null) {
            ImportLibraryDialog dialog = new ImportLibraryDialog(namespace);
            namespace = dialog.open() == 0 ? (String)dialog.getResult() : null;
        }
        return namespace;
    }

    public static ThemeHandle themeInModuleHandle(ThemeHandle handle, ModuleHandle moduleHandle) {
        String themeName = handle.getName().trim();
        String themeFileName = handle.getModuleHandle().getFileName();
        LibraryHandle libHandle = moduleHandle.findLibrary(themeFileName);
        if (libHandle == null) {
            return null;
        }
        Iterator iterator = moduleHandle.getVisibleThemes(1).iterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                ReportElementHandle elementHandle = (ReportElementHandle)iterator.next();
                if (!elementHandle.getName().trim().equals(themeName) || elementHandle.getRoot() != libHandle) continue;
                return (ThemeHandle)elementHandle;
            }
        }
        return null;
    }

    public static ThemeHandle applyTheme(ThemeHandle handle, ModuleHandle moduleHandle, LibraryHandle library) {
        if (handle.getRoot() == moduleHandle) {
            try {
                moduleHandle.setTheme(handle);
            }
            catch (SemanticException e) {
                e.printStackTrace();
            }
            return handle;
        }
        ThemeHandle applyThemeHandle = UIUtil.themeInModuleHandle(handle, moduleHandle);
        if (applyThemeHandle != null) {
            try {
                moduleHandle.setTheme(applyThemeHandle);
            }
            catch (SemanticException e) {
                GUIException exception = GUIException.createGUIException((String)"org.eclipse.birt.report.designer.ui", (Throwable)e, (String)"Library.DND.messages.cannotApplyTheme");
                ExceptionHandler.handle((Throwable)exception);
                e.printStackTrace();
            }
        }
        return applyThemeHandle;
    }

    public static int[] getExpressionBidiSegments(String lineText) {
        if (lineText == null || "".equals(lineText)) {
            return null;
        }
        int[] level = UIUtil.getExpressionBidiLevel(lineText);
        int[] segments = new int[level.length];
        int j = 0;
        segments[j++] = 0;
        for (int i = 1; i < level.length; ++i) {
            if (level[i] == level[i - 1]) continue;
            segments[j++] = i;
        }
        if (j < segments.length) {
            int[] result = new int[j];
            System.arraycopy(segments, 0, result, 0, j);
            segments = result;
        }
        return segments;
    }

    public static int[] getExpressionBidiLevel(String message) {
        Bidi bidi = new Bidi(message, -2);
        int[] level = new int[message.length()];
        boolean bidiStart = false;
        Stack<Character> bracket = new Stack<Character>();
        for (int i = 0; i < message.length(); ++i) {
            char c = message.charAt(i);
            if (UIUtil.isNeutral(c)) {
                if (c == '\'' || c == '\"') {
                    if (bracket.empty()) {
                        bracket.add(new Character(c));
                    } else if (((Character)bracket.peek()).charValue() == c) {
                        bracket.pop();
                        bidiStart = false;
                    } else {
                        bracket.add(new Character(c));
                    }
                }
                level[i] = bidiStart && !bracket.empty() ? 1 : 0;
                continue;
            }
            level[i] = bidi.getLevelAt(i);
            if (level[i] % 2 != 1) continue;
            bidiStart = true;
        }
        return level;
    }

    private static boolean isNeutral(char c) {
        boolean match = punctuation.matcher(new StringBuffer(0).append(c)).matches();
        return match;
    }

    public static void bindHelp(Control control, String contextId) {
        try {
            IWorkbench workbench = PlatformUI.getWorkbench();
            workbench.getHelpSystem().setHelp(control, contextId);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public static IViewPart getView(String id) {
        IWorkbenchPage tPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewReference[] v = tPage.getViewReferences();
        for (int i = 0; i < v.length; ++i) {
            if (!v[i].getId().equals(id)) continue;
            return (IViewPart)v[i].getPart(true);
        }
        return null;
    }

    public static boolean needAddQuote(String elementName, String property, String value) {
        IChoice[] choices = ChoiceSetFactory.getElementChoiceSet(elementName, property).getChoices();
        for (int i = 0; i < choices.length; ++i) {
            if (!choices[i].getValue().equals(value)) continue;
            return false;
        }
        return true;
    }
}

