/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.EmbeddedImageHandle;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class RenameInlineTool {
    private TreeItem selectedItem;
    private Tree tree;
    private TreeEditor treeEditor;
    private Composite textEditorParent;
    private Text textEditor = null;
    private String originalName;
    private static RenameInlineTool activeInstance = null;
    private static final String ERROR_TITLE = Messages.getString((String)"RenameInlineTool.DialogTitle.RenameFailed");
    private static final String TRANS_LABEL = Messages.getString((String)"RenameInlineTool.TransLabel.Rename");
    private boolean isDispatching = false;

    public RenameInlineTool(TreeItem item) {
        this.selectedItem = item;
        this.tree = item.getParent();
    }

    public void doRename() {
        if (activeInstance != null && activeInstance != this) {
            return;
        }
        if (this.textEditor == null && !this.tree.isFocusControl()) {
            return;
        }
        if (this.selectedItem.getData() instanceof DesignElementHandle || this.selectedItem.getData() instanceof EmbeddedImageHandle) {
            if (this.textEditor == null) {
                this.initOriginalName();
                this.createTextEditor();
                activeInstance = this;
            }
            this.textEditor.setText(this.originalName);
            this.computeTextSize();
            this.textEditorParent.setVisible(true);
            this.textEditor.selectAll();
            this.textEditor.setFocus();
        }
    }

    private void initOriginalName() {
        if (this.selectedItem.getData() instanceof DesignElementHandle) {
            this.originalName = ((DesignElementHandle)this.selectedItem.getData()).getQualifiedName();
        }
        if (this.selectedItem.getData() instanceof EmbeddedImageHandle) {
            this.originalName = ((EmbeddedImageHandle)this.selectedItem.getData()).getQualifiedName();
        }
        if (this.originalName == null) {
            this.originalName = "";
        }
    }

    private void createTextEditor() {
        this.treeEditor = new TreeEditor(this.tree);
        this.treeEditor.horizontalAlignment = 16384;
        this.treeEditor.grabHorizontal = true;
        this.treeEditor.minimumWidth = 40;
        this.textEditorParent = new Composite((Composite)this.tree, 0);
        this.textEditorParent.setVisible(false);
        this.treeEditor.setEditor((Control)this.textEditorParent, this.selectedItem);
        int inset = this.getCellEditorInset((Control)this.textEditorParent);
        if (inset > 0) {
            this.textEditorParent.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    Point textSize = RenameInlineTool.this.textEditor.getSize();
                    Point parentSize = RenameInlineTool.this.textEditorParent.getSize();
                    e.gc.drawRectangle(0, 0, Math.min(textSize.x + 4, parentSize.x - 1), parentSize.y - 1);
                }
            });
        }
        this.textEditor = new Text(this.textEditorParent, 0);
        this.textEditor.setFont(this.selectedItem.getFont());
        this.textEditorParent.setBackground(this.textEditor.getBackground());
        this.textEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RenameInlineTool.this.computeTextSize();
            }
        });
        this.textEditor.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                switch (e.detail) {
                    case 2: {
                        RenameInlineTool.this.close();
                        e.doit = true;
                        e.detail = 0;
                        if (RenameInlineTool.this.tree == null) break;
                        RenameInlineTool.this.tree.setFocus();
                        break;
                    }
                    case 4: {
                        RenameInlineTool.this.saveChangesAndClose();
                        e.doit = true;
                        e.detail = 0;
                        if (RenameInlineTool.this.tree == null) break;
                        RenameInlineTool.this.tree.setFocus();
                    }
                }
            }
        });
        this.textEditor.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent fe) {
                RenameInlineTool.this.saveChangesAndClose();
            }
        });
    }

    public void close() {
        if (this.textEditorParent != null) {
            this.textEditorParent.dispose();
            this.textEditorParent = null;
            this.textEditor = null;
            this.treeEditor.setEditor(null, null);
            activeInstance = null;
        }
    }

    public static void cancelActiveInstance() {
        if (activeInstance != null) {
            activeInstance.close();
        }
    }

    private void saveChangesAndClose() {
        if (this.textEditor == null || this.isDispatching) {
            return;
        }
        this.isDispatching = true;
        String newName = this.textEditor.getText().trim();
        if (!newName.equals(this.originalName) && !this.rename(this.selectedItem.getData(), newName)) {
            this.doRename();
            this.isDispatching = false;
            return;
        }
        this.close();
        this.isDispatching = false;
    }

    private boolean rename(Object handle, String newName) {
        if (newName.length() == 0) {
            newName = null;
        }
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        stack.startTrans(TRANS_LABEL + " " + DEUtil.getDisplayLabel((Object)handle));
        try {
            if (handle instanceof DesignElementHandle) {
                ((DesignElementHandle)handle).setName(newName);
            }
            if (handle instanceof EmbeddedImageHandle) {
                ((EmbeddedImageHandle)handle).setName(newName);
            }
            stack.commit();
        }
        catch (NameException e) {
            ExceptionHandler.handle(e, ERROR_TITLE, e.getLocalizedMessage());
            stack.rollback();
            return false;
        }
        return true;
    }

    private int getCellEditorInset(Control c) {
        if ("carbon".equals(SWT.getPlatform()) && (System.getProperty("org.eclipse.swt.internal.carbon.noFocusRing") == null || c.getShell().getParent() != null)) {
            return -2;
        }
        return 1;
    }

    private void computeTextSize() {
        int inset = this.getCellEditorInset((Control)this.textEditorParent);
        Point textSize = this.textEditor.computeSize(-1, -1);
        textSize.x += textSize.y;
        textSize.x = textSize.x < 20 || this.textEditor.getCharCount() == 0 ? 40 : (textSize.x += 20);
        Point parentSize = this.textEditorParent.getSize();
        this.textEditor.setBounds(2, inset, Math.min(textSize.x, parentSize.x - 4), parentSize.y - 2 * inset);
        this.textEditorParent.redraw();
    }
}

