/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.actions;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.internal.ui.views.actions.AbstractViewAction;
import org.eclipse.birt.report.model.api.CommandStack;

public abstract class AbstractElementAction
extends AbstractViewAction {
    public AbstractElementAction(Object selectedObject) {
        super(selectedObject);
    }

    public AbstractElementAction(Object selectedObject, String text) {
        super(selectedObject, text);
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        CommandStack stack = this.getCommandStack();
        stack.startTrans(this.getTransactionLabel());
        try {
            if (Policy.TRACING_ACTIONS) {
                String[] result = ((Object)((Object)this)).getClass().getName().split("\\.");
                System.out.println("Element Actions >> " + result[result.length - 1] + " runs with " + this.getSelection() + " selected");
            }
            if (this.doAction()) {
                if (Policy.TRACING_ACTIONS) {
                    System.out.println("Element  Actions >> " + ((Object)((Object)this)).getClass().getName() + " finished ");
                }
                stack.commit();
            } else {
                if (Policy.TRACING_ACTIONS) {
                    System.out.println("Element Actions >> " + ((Object)((Object)this)).getClass().getName() + " cancelled ");
                }
                stack.rollbackAll();
            }
        }
        catch (Exception e) {
            if (Policy.TRACING_ACTIONS) {
                System.out.println(" Actions >> " + ((Object)((Object)this)).getClass().getName() + " failed ");
            }
            stack.rollbackAll();
            this.handleException(e);
        }
    }

    protected CommandStack getCommandStack() {
        return SessionHandleAdapter.getInstance().getCommandStack();
    }

    protected String getTransactionLabel() {
        return this.getText();
    }

    protected abstract boolean doAction() throws Exception;

    protected void handleException(Exception e) {
        ExceptionHandler.handle(e);
    }
}

