/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.actions;

import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.internal.ui.views.actions.AbstractViewAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.DeleteAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.DNDUtil;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class CutAction
extends AbstractViewAction {
    private static final String DEFAULT_TEXT = Messages.getString((String)"CutAction.text");

    public CutAction(Object selectedObject) {
        this(selectedObject, DEFAULT_TEXT);
    }

    public CutAction(Object selectedObject, String text) {
        super(selectedObject, text);
        ISharedImages shareImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(shareImages.getImageDescriptor("IMG_TOOL_CUT"));
        this.setDisabledImageDescriptor(shareImages.getImageDescriptor("IMG_TOOL_CUT_DISABLED"));
        this.setAccelerator(262232);
    }

    public boolean isEnabled() {
        return DNDUtil.handleValidateDragInOutline((Object)this.getSelection()) && this.createDeleteAction(this.getSelection()).isEnabled();
    }

    public void run() {
        if (Policy.TRACING_ACTIONS) {
            System.out.println("Cut action >> Cut " + this.getSelection());
        }
        Object cloneElements = DNDUtil.cloneSource((Object)this.getSelection());
        DeleteAction action = this.createDeleteAction(this.getSelection());
        action.run();
        if (action.hasExecuted()) {
            Clipboard.getDefault().setContents(cloneElements);
        }
    }

    protected DeleteAction createDeleteAction(final Object objects) {
        return new DeleteAction(objects){

            protected String getTransactionLabel() {
                if (objects instanceof IStructuredSelection) {
                    return Messages.getString((String)"CutAction.trans");
                }
                return DEFAULT_TEXT + " " + DEUtil.getDisplayLabel((Object)objects);
            }
        };
    }
}

