/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.actions;

import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.internal.ui.views.actions.AbstractViewAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DNDUtil;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class PasteAction
extends AbstractViewAction {
    private static final String DEFAULT_TEXT = Messages.getString((String)"PasteAction.text");

    public PasteAction(Object selectedObject) {
        this(selectedObject, DEFAULT_TEXT);
    }

    public PasteAction(Object selectedObject, String text) {
        super(selectedObject, text);
        ISharedImages shareImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(shareImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.setDisabledImageDescriptor(shareImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        this.setAccelerator(262230);
    }

    public void run() {
        if (Policy.TRACING_ACTIONS) {
            System.out.println("Paste action >> Paste " + this.getClipBoardContents());
        }
        DNDUtil.copyHandles((Object)this.getClipBoardContents(), (Object)this.getSelection());
    }

    public boolean isEnabled() {
        return DNDUtil.handleValidateTargetCanContain((Object)this.getSelection(), (Object)this.getClipBoardContents()) && DNDUtil.handleValidateTargetCanContainMore((Object)this.getSelection(), (int)DNDUtil.getObjectLength((Object)this.getClipBoardContents()));
    }

    protected Object getClipBoardContents() {
        return Clipboard.getDefault().getContents();
    }

    public Object getSelection() {
        Object selection = super.getSelection();
        if (selection instanceof StructuredSelection) {
            selection = ((StructuredSelection)selection).getFirstElement();
        }
        return selection;
    }
}

