/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.actions;

import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.internal.ui.views.RenameInlineTool;
import org.eclipse.birt.report.designer.internal.ui.views.actions.AbstractViewerAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.EmbeddedImageHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.jface.viewers.TreeViewer;

public class RenameAction
extends AbstractViewerAction {
    public static final String TEXT = Messages.getString((String)"RenameAction.text");
    private RenameInlineTool tool = null;

    public RenameAction(TreeViewer sourceViewer) {
        this(sourceViewer, TEXT);
    }

    public RenameAction(TreeViewer sourceViewer, String text) {
        super(sourceViewer, text);
        this.setAccelerator(0x100000B);
        if (this.isEnabled()) {
            this.tool = new RenameInlineTool(this.getSelectedItems()[0]);
        }
    }

    public boolean isEnabled() {
        if (this.getSelectedObjects().size() != 1) {
            return false;
        }
        Object obj = super.getSelectedObjects().getFirstElement();
        if (obj instanceof EmbeddedImageHandle) {
            return true;
        }
        if (obj instanceof ReportElementHandle) {
            if (obj instanceof GroupHandle) {
                return true;
            }
            return ((ReportElementHandle)obj).getDefn().getNameOption() != 0 && ((ReportElementHandle)obj).canEdit();
        }
        return false;
    }

    public void run() {
        if (Policy.TRACING_ACTIONS) {
            System.out.println("Rename action >> Runs with " + DEUtil.getDisplayLabel((Object)this.getSelectedObjects().getFirstElement()));
        }
        if (this.tool != null) {
            this.tool.doRename();
        }
    }
}

