/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.page;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.AttributePage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.FilterHandleProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.GroupHandleProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IFormHandleProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class FormPage
extends AttributePage {
    public static final int SIMPLE_FUNCTION = 1;
    public static final int NORMAL_FUNCTION = 2;
    public static final int FULL_FUNCTION = 3;
    private int style;
    private boolean bAddWithDialog;
    private Label title;
    protected Button btnUp;
    protected Button btnDown;
    protected Button btnAdd;
    protected Button btnDel;
    protected Button btnEdit;
    private Table table;
    private TableViewer tableViewer;
    private IFormHandleProvider provider;
    private int selectIndex;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FormPage(Composite parent, int style, IFormHandleProvider provider, boolean bAddWithDialog) {
        super(parent, 0);
        if (!$assertionsDisabled && provider == null) {
            throw new AssertionError();
        }
        this.provider = provider;
        this.style = style;
        this.bAddWithDialog = bAddWithDialog;
        this.createControl();
    }

    protected TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public FormPage(Composite parent, int style, IFormHandleProvider provider) {
        this(parent, style, provider, false);
    }

    private void enableUI(boolean enabled) {
        if (this.tableViewer != null) {
            this.table.setEnabled(enabled);
            if (this.style != 1) {
                this.btnUp.setEnabled(enabled);
                this.btnDown.setEnabled(enabled);
            }
            this.btnAdd.setEnabled(enabled);
            this.btnDel.setEnabled(enabled);
            if (this.style == 3) {
                this.btnEdit.setEnabled(enabled);
            }
            if (enabled) {
                this.updateArraw();
            }
        }
    }

    public void setInput(List elements) {
        if (elements.size() != 1) {
            this.enableUI(false);
            return;
        }
        this.enableUI(true);
        super.setInput(elements);
        this.tableViewer.setInput((Object)elements);
        this.updateArraw();
        this.updateBindingParameters();
    }

    protected void createControl() {
        this.title = new Label((Composite)this, 0);
        this.title.setText(this.provider.getTitle());
        this.table = new Table((Composite)this, 68356);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        String[] columnNames = this.provider.getColumnNames();
        for (int i = 0; i < columnNames.length; ++i) {
            TableColumn column = new TableColumn(this.table, 16384);
            column.setText(columnNames[i]);
            column.setWidth(this.provider.getColumnWidths()[i]);
        }
        this.table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    int itemCount = FormPage.this.table.getItemCount();
                    int pos = FormPage.this.table.getSelectionIndex();
                    if (FormPage.this.selectIndex == itemCount - 1) {
                        FormPage.this.selectIndex--;
                    }
                    try {
                        FormPage.this.provider.doDeleteItem(pos);
                    }
                    catch (Exception e1) {
                        WidgetUtil.processError(FormPage.this.getShell(), e1);
                    }
                }
            }
        });
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormPage.this.selectIndex = FormPage.this.table.getSelectionIndex();
                FormPage.this.updateArraw();
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (FormPage.this.style == 3) {
                    FormPage.this.edit();
                }
            }
        });
        this.createTableViewer();
        this.btnDel = new Button((Composite)this, 2048);
        this.btnDel.setText(Messages.getString((String)"FormPage.Button.Delete"));
        this.btnDel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int pos;
                if (FormPage.this.tableViewer.isCellEditorActive()) {
                    FormPage.this.tableViewer.cancelEditing();
                }
                if ((pos = FormPage.this.table.getSelectionIndex()) == -1) {
                    FormPage.this.table.setFocus();
                    return;
                }
                FormPage.this.selectIndex = pos;
                int itemCount = FormPage.this.table.getItemCount();
                if (FormPage.this.selectIndex == itemCount - 1) {
                    FormPage.this.selectIndex--;
                }
                try {
                    FormPage.this.provider.doDeleteItem(pos);
                }
                catch (Exception e1) {
                    WidgetUtil.processError(FormPage.this.getShell(), e1);
                }
                FormPage.this.updateArraw();
            }
        });
        this.btnAdd = new Button((Composite)this, 2048);
        if (this.bAddWithDialog) {
            this.btnAdd.setText(Messages.getString((String)"FormPage.Button.AddWithDialog"));
        } else {
            this.btnAdd.setText(Messages.getString((String)"FormPage.Button.Add"));
        }
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommandStack stack = FormPage.this.getActionStack();
                stack.startTrans(Messages.getString((String)"FormPage.Menu.ModifyProperty"));
                int pos = FormPage.this.table.getSelectionIndex();
                boolean sucess = false;
                try {
                    sucess = FormPage.this.provider.doAddItem(pos);
                }
                catch (Exception e1) {
                    stack.rollback();
                    WidgetUtil.processError(FormPage.this.getShell(), e1);
                    return;
                }
                if (sucess) {
                    stack.commit();
                } else {
                    stack.rollback();
                }
                FormPage.this.table.setSelection(FormPage.this.table.getItemCount() - 1);
                FormPage.this.updateArraw();
            }
        });
        if (this.style == 3) {
            this.btnEdit = new Button((Composite)this, 2048);
            if (this.bAddWithDialog) {
                this.btnEdit.setText(Messages.getString((String)"FormPage.Button.EditWithDialog"));
            } else {
                this.btnEdit.setText(Messages.getString((String)"FormPage.Button.Edit"));
            }
            this.btnEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FormPage.this.edit();
                }
            });
        }
        if (this.style != 1) {
            this.btnUp = new Button((Composite)this, 2048);
            this.btnUp.setText(Messages.getString((String)"FormPage.Button.Up"));
            this.btnUp.setToolTipText(Messages.getString((String)"FormPage.toolTipText.Up"));
            this.btnUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (FormPage.this.tableViewer.isCellEditorActive()) {
                        FormPage.this.tableViewer.cancelEditing();
                    }
                    int oldPos = FormPage.this.table.getSelectionIndex();
                    FormPage.this.selectIndex = oldPos - 1;
                    FormPage.this.moveItem(oldPos, oldPos - 1);
                    FormPage.this.updateArraw();
                }
            });
            this.btnDown = new Button((Composite)this, 2048);
            this.btnDown.setText(Messages.getString((String)"FormPage.Button.Down"));
            this.btnDown.setToolTipText(Messages.getString((String)"FormPage.toolTipText.Down"));
            this.btnDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (FormPage.this.tableViewer.isCellEditorActive()) {
                        FormPage.this.tableViewer.cancelEditing();
                    }
                    int oldPos = FormPage.this.table.getSelectionIndex();
                    FormPage.this.selectIndex = oldPos + 1;
                    FormPage.this.moveItem(oldPos, oldPos + 1);
                    FormPage.this.updateArraw();
                }
            });
        }
        switch (this.style) {
            case 1: {
                this.simpleLayout();
                break;
            }
            case 2: {
                this.normallLayout();
                break;
            }
            case 3: {
                this.fullLayout();
            }
        }
    }

    private void edit() {
        int pos = this.table.getSelectionIndex();
        if (pos == -1) {
            this.table.setFocus();
            return;
        }
        CommandStack stack = this.getActionStack();
        stack.startTrans(Messages.getString((String)"FormPage.Menu.ModifyProperty"));
        if (!this.provider.doEditItem(pos)) {
            stack.rollback();
            return;
        }
        stack.commit();
        this.table.setSelection(pos);
    }

    private void updateArraw() {
        if (this.style == 1) {
            return;
        }
        int selectIndex = this.table.getSelectionIndex();
        int min = 0;
        int max = this.table.getItemCount() - 1;
        if (selectIndex <= 0) {
            this.btnUp.setEnabled(false);
        } else {
            this.btnUp.setEnabled(true);
        }
        if (selectIndex >= max || selectIndex == -1) {
            this.btnDown.setEnabled(false);
            if (selectIndex > max) {
                this.btnUp.setEnabled(false);
            }
        } else {
            this.btnDown.setEnabled(true);
        }
        if (min <= selectIndex && selectIndex <= max) {
            this.btnDel.setEnabled(true);
            if (this.btnEdit != null) {
                this.btnEdit.setEnabled(true);
            }
        } else {
            this.btnDel.setEnabled(false);
            if (this.btnEdit != null) {
                this.btnEdit.setEnabled(false);
            }
        }
    }

    private void updateBindingParameters() {
        if (this.provider instanceof FilterHandleProvider) {
            ParamBindingHandle[] bindingParams = null;
            if (this.input.get(0) instanceof ReportItemHandle) {
                ReportItemHandle inputHandle = (ReportItemHandle)this.input.get(0);
                ArrayList<ParamBindingHandle> list = new ArrayList<ParamBindingHandle>();
                Iterator iterator = inputHandle.paramBindingsIterator();
                while (iterator.hasNext()) {
                    ParamBindingHandle handle = (ParamBindingHandle)iterator.next();
                    list.add(handle);
                }
                bindingParams = new ParamBindingHandle[list.size()];
                list.toArray(bindingParams);
            }
            ((FilterHandleProvider)this.provider).setBindingParams(bindingParams);
        }
    }

    private void moveItem(int oldPos, int newPos) {
        try {
            this.provider.doMoveItem(oldPos, newPos);
        }
        catch (Exception e) {
            WidgetUtil.processError(this.getShell(), e);
        }
    }

    private void createTableViewer() {
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setColumnProperties(this.provider.getColumnNames());
        this.tableViewer.setCellEditors(this.provider.getEditors(this.table));
        this.tableViewer.setContentProvider((IContentProvider)new FormContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new FormLabelProvider());
        this.tableViewer.setCellModifier((ICellModifier)new FormCellModifier());
    }

    protected void simpleLayout() {
        FormLayout layout = new FormLayout();
        layout.marginHeight = 7;
        layout.marginWidth = 7;
        layout.spacing = 7;
        this.setLayout((Layout)layout);
        FormData data = new FormData();
        data.left = new FormAttachment((Control)this.title, 50, 131072);
        this.btnAdd.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this.btnAdd, 0, 131072);
        this.btnDel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.btnAdd, 0, 1024);
        data.left = new FormAttachment((Control)this.title, 0, 16384);
        int[] width = this.provider.getColumnWidths();
        int dataWidth = 0;
        for (int i = 0; i < width.length; ++i) {
            dataWidth += width[i];
        }
        data.right = new FormAttachment((Control)this.title, dataWidth + 15, 16384);
        data.bottom = new FormAttachment(100);
        this.table.setLayoutData((Object)data);
    }

    protected void normallLayout() {
        FormLayout layout = new FormLayout();
        layout.marginHeight = 7;
        layout.marginWidth = 7;
        layout.spacing = 7;
        this.setLayout((Layout)layout);
        FormData data = new FormData();
        data.right = new FormAttachment(100);
        this.btnDown.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment((Control)this.btnDown, 0, 16384);
        this.btnUp.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment((Control)this.btnUp, 0, 16384);
        this.btnDel.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment((Control)this.btnDel, 0, 16384);
        this.btnAdd.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.btnUp, 0, 1024);
        data.left = new FormAttachment((Control)this.title, 0, 16384);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        this.table.setLayoutData((Object)data);
    }

    protected void fullLayout() {
        FormLayout layout = new FormLayout();
        layout.marginHeight = 7;
        layout.marginWidth = 7;
        layout.spacing = 7;
        this.setLayout((Layout)layout);
        int btnWidth = 60;
        int height = QUICK_BUTTON_HEIGHT - 2;
        FormData data = new FormData();
        data.right = new FormAttachment(90);
        data.top = new FormAttachment(0, height + 14);
        data.width = Math.max(btnWidth, this.btnAdd.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.btnAdd.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.btnAdd, 0, 1024);
        data.left = new FormAttachment((Control)this.btnAdd, 0, 16384);
        data.width = Math.max(btnWidth, this.btnEdit.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.btnEdit.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.btnEdit, 0, 1024);
        data.left = new FormAttachment((Control)this.btnEdit, 0, 16384);
        data.width = Math.max(btnWidth, this.btnDel.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.btnDel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.btnDel, 0, 1024);
        data.left = new FormAttachment((Control)this.btnDel, 0, 16384);
        data.width = Math.max(btnWidth, this.btnUp.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.btnUp.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.btnUp, 0, 1024);
        data.left = new FormAttachment((Control)this.btnUp, 0, 16384);
        data.width = Math.max(btnWidth, this.btnDown.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.btnDown.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.btnAdd, 0, 128);
        data.bottom = new FormAttachment(100);
        data.left = new FormAttachment((Control)this.title, 0, 16384);
        data.right = new FormAttachment((Control)this.btnAdd, 0, 16384);
        this.table.setLayoutData((Object)data);
    }

    public void elementChanged(DesignElementHandle arg0, NotificationEvent event) {
        if (this.provider.needRefreshed(event)) {
            this.tableViewer.refresh();
            this.table.select(this.selectIndex);
            this.table.setFocus();
            this.updateArraw();
            this.updateBindingParameters();
        }
    }

    protected void buildUI() {
    }

    private CommandStack getActionStack() {
        return SessionHandleAdapter.getInstance().getCommandStack();
    }

    static {
        $assertionsDisabled = !FormPage.class.desiredAssertionStatus();
    }

    private class FormCellModifier
    implements ICellModifier {
        private FormCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return FormPage.this.provider.canModify(element, property);
        }

        public Object getValue(Object element, String property) {
            return FormPage.this.provider.getValue(element, property);
        }

        public void modify(Object element, String property, Object value) {
            CommandStack stack = FormPage.this.getActionStack();
            TableItem item = (TableItem)element;
            stack.startTrans(Messages.getString((String)"FormPage.Menu.ModifyProperty"));
            try {
                FormPage.this.provider.modify(item.getData(), property, value);
                stack.commit();
            }
            catch (Exception e) {
                stack.rollback();
                WidgetUtil.processError(FormPage.this.getShell(), e);
            }
        }
    }

    private class FormContentProvider
    implements IStructuredContentProvider {
        private FormContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] elements = FormPage.this.provider.getElements(inputElement);
            for (int i = 0; i < elements.length; ++i) {
                if (!(elements[i] instanceof DesignElementHandle)) continue;
                DesignElementHandle element = (DesignElementHandle)elements[i];
                element.removeListener((Listener)FormPage.this);
                element.addListener((Listener)FormPage.this);
            }
            return elements;
        }

        public void dispose() {
            if (!(FormPage.this.provider instanceof GroupHandleProvider)) {
                return;
            }
            Object[] elements = FormPage.this.provider.getElements(FormPage.this.input);
            if (elements == null) {
                return;
            }
            for (int i = 0; i < elements.length; ++i) {
                if (!(elements[i] instanceof DesignElementHandle)) continue;
                DesignElementHandle element = (DesignElementHandle)elements[i];
                element.removeListener((Listener)FormPage.this);
            }
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class FormLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private FormLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return FormPage.this.provider.getColumnText(element, columnIndex);
        }
    }
}

