/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.page;

import java.util.Map;
import java.util.Set;
import org.eclipse.birt.report.designer.internal.ui.dialogs.resource.NewResourceFileDialog;
import org.eclipse.birt.report.designer.internal.ui.dialogs.resource.ResourceFileContentProvider;
import org.eclipse.birt.report.designer.internal.ui.dialogs.resource.ResourceFileLabelProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.AttributePage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.IReportGraphicConstants;
import org.eclipse.birt.report.designer.ui.views.attributes.IPropertyDescriptor;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ModulePage
extends AttributePage {
    private Text path;

    public ModulePage(Composite parent, int style) {
        super(parent, style);
    }

    protected void buildUI() {
        this.setLayout((Layout)WidgetUtil.createGridLayout(4));
        int comboxWidth = Platform.getOS().equals("linux") ? 500 : 480;
        WidgetUtil.buildGridControl((Composite)this, (Map)this.propertiesMap, "Module", "author", 2, 500);
        WidgetUtil.createGridPlaceholder(this, 1, true);
        WidgetUtil.buildGridControl((Composite)this, (Map)this.propertiesMap, "Module", "createdBy", 2, 500);
        WidgetUtil.createGridPlaceholder(this, 1, true);
        new Label((Composite)this, 0).setText(Messages.getString((String)"ModulePage.text.Path"));
        this.path = new Text((Composite)this, 2056);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        gd.widthHint = 500;
        this.path.setLayoutData((Object)gd);
        WidgetUtil.createGridPlaceholder(this, 1, true);
        WidgetUtil.buildGridControl((Composite)this, (Map)this.propertiesMap, "Module", "title", 2, 500);
        WidgetUtil.createGridPlaceholder(this, 1, true);
        WidgetUtil.buildGridControl((Composite)this, (Map)this.propertiesMap, "Module", "units", 2, comboxWidth);
        WidgetUtil.createGridPlaceholder(this, 1, true);
        WidgetUtil.buildGridControl((Composite)this, (Map)this.propertiesMap, "Module", "includeResource", 2, 500);
        final Text resourceText = (Text)((IPropertyDescriptor)this.propertiesMap.get("includeResource")).getControl();
        Button btn = new Button((Composite)this, 8);
        btn.setText(Messages.getString((String)"ReportPage.text.Add"));
        GridData data = new GridData();
        data.widthHint = Math.max(btn.computeSize((int)-1, (int)-1).x, 60);
        btn.setLayoutData((Object)data);
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceFileLabelProvider labelProvider = new ResourceFileLabelProvider();
                ResourceFileContentProvider contentProvider = new ResourceFileContentProvider(new String[]{".properties"});
                NewResourceFileDialog dialog = new NewResourceFileDialog(ModulePage.this.getShell(), (ILabelProvider)labelProvider, contentProvider);
                dialog.setAllowMultiple(false);
                dialog.setTitle(Messages.getString((String)"ModulePage.Resourcefile.Dialog.Title"));
                dialog.setMessage(Messages.getString((String)"ModulePage.Resourcefile.Dialog.Message"));
                if (dialog.open() == 0) {
                    resourceText.setText(dialog.getPath().substring(0, dialog.getPath().lastIndexOf(".")));
                    resourceText.setFocus();
                }
            }
        });
        WidgetUtil.createHorizontalLine(this, 4);
        WidgetUtil.buildGridControl((Composite)this, (Map)this.propertiesMap, "Module", "theme", 2, comboxWidth + 4);
        WidgetUtil.createGridPlaceholder(this, 1, true);
        WidgetUtil.buildGridControl((Composite)this, (Map)this.propertiesMap, "ReportDesign", "displayName", 2, 500);
        WidgetUtil.createGridPlaceholder(this, 1, true);
        WidgetUtil.buildGridControl((Composite)this, (Map)this.propertiesMap, "ReportDesign", "iconFile", 2, 500);
        final Text prvImageText = (Text)((IPropertyDescriptor)this.propertiesMap.get("iconFile")).getControl();
        Button browse = new Button((Composite)this, 8);
        browse.setText(Messages.getString((String)"ReportPage.text.Browse"));
        data = new GridData();
        data.widthHint = Math.max(browse.computeSize((int)-1, (int)-1).x, 60);
        browse.setLayoutData((Object)data);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dlg = new FileDialog(ModulePage.this.getShell());
                dlg.setText(Messages.getString((String)"ReportPage.title.setPrewImg"));
                dlg.setFilterNames(IReportGraphicConstants.IMAGE_FILTER_NAMES);
                dlg.setFilterExtensions(IReportGraphicConstants.IMAGE_FILTER_EXTS);
                try {
                    String fileName = dlg.open();
                    if (fileName == null) {
                        return;
                    }
                    prvImageText.setText(fileName);
                    prvImageText.setFocus();
                }
                catch (Exception e1) {
                    return;
                }
            }
        });
    }

    protected void refreshValues(Set propertiesSet) {
        super.refreshValues(propertiesSet);
        ModuleHandle handle = (ModuleHandle)this.input.get(0);
        this.path.setText(handle.getFileName());
    }
}

