/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.page;

import java.util.Map;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.PropertyDescriptorFactory;
import org.eclipse.birt.report.designer.ui.views.attributes.IPropertyDescriptor;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.PropertyProcessor;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class WidgetUtil {
    public static final int TEXT_HEIGHT = 12;
    public static final int TEXT_WIDTH = 40;
    public static final int COMBO_HEIGHT = 8;
    public static final int COMBO_WIDTH = 18;
    public static final int SPACING = 7;
    public static final int MARGIN_HEIGHT = 7;
    public static final int MARGIN_WIDTH = 7;
    public static final int MIN_TEXT_WIDTH = 80;

    public static GridLayout createGridLayout(int columns) {
        GridLayout layout = new GridLayout(columns, false);
        layout.marginHeight = 7;
        layout.marginWidth = 7;
        layout.horizontalSpacing = 7;
        layout.verticalSpacing = 7;
        return layout;
    }

    public static GridLayout createSpaceGridLayout(int columns, int space) {
        GridLayout layout = new GridLayout(columns, false);
        layout.marginHeight = space;
        layout.marginWidth = space;
        layout.horizontalSpacing = space;
        layout.verticalSpacing = space;
        return layout;
    }

    public static FormLayout createFormLayout() {
        FormLayout layout = new FormLayout();
        layout.marginHeight = 7;
        layout.marginWidth = 7;
        layout.spacing = 7;
        return layout;
    }

    public static FormLayout createSpaceFormLayout(int space) {
        FormLayout layout = new FormLayout();
        layout.marginHeight = space;
        layout.marginWidth = space;
        layout.spacing = space;
        return layout;
    }

    public static Control buildGridControl(Composite parent, Map propertiesMap, String elementName, String property, int hSpan, boolean grabSpace) {
        IPropertyDescriptor descriptor = PropertyDescriptorFactory.getPropertyDescriptor(elementName, property);
        propertiesMap.put(property, descriptor);
        Label label = new Label(parent, 0);
        label.setText(WidgetUtil.getDisplayName(descriptor));
        Control control = descriptor.createControl(parent);
        GridData data = new GridData();
        data.horizontalSpan = hSpan;
        data.grabExcessHorizontalSpace = grabSpace;
        if (control instanceof Text || control instanceof Combo) {
            data.widthHint = 80;
        }
        data.horizontalAlignment = 4;
        control.setLayoutData((Object)data);
        return control;
    }

    public static Control buildGridControl(Composite parent, Map propertiesMap, String elementName, String property, int hSpan, int width) {
        IPropertyDescriptor descriptor = PropertyDescriptorFactory.getPropertyDescriptor(elementName, property);
        propertiesMap.put(property, descriptor);
        Label label = new Label(parent, 0);
        label.setText(WidgetUtil.getDisplayName(descriptor));
        Control control = descriptor.createControl(parent);
        GridData data = new GridData();
        data.horizontalSpan = hSpan;
        data.widthHint = width;
        control.setLayoutData((Object)data);
        return control;
    }

    public static Composite buildGridComposite(Composite parent, int hSpan, boolean grabSpace) {
        Composite composite = new Composite(parent, 0);
        GridData data = new GridData(768);
        data.horizontalSpan = hSpan;
        data.grabExcessHorizontalSpace = grabSpace;
        composite.setLayoutData((Object)data);
        return composite;
    }

    private static String getDisplayName(IPropertyDescriptor descriptor) {
        String name = null;
        PropertyProcessor processor = null;
        if (descriptor != null) {
            processor = descriptor.getPropertyProcessor();
        }
        if (processor != null) {
            name = processor.getDisplayName();
        }
        return name == null ? "" : name;
    }

    public static Composite buildFontStyleUI(Composite parent, Map propertiesMap) {
        Composite container = new Composite(parent, 0);
        RowLayout layout = new RowLayout(256);
        layout.marginBottom = 0;
        layout.marginHeight = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = 0;
        layout.marginWidth = 0;
        layout.spacing = 0;
        container.setLayout((Layout)layout);
        String[] properties = new String[]{"fontWeight", "fontStyle", "textUnderline", "textLineThrough"};
        for (int i = 0; i < properties.length; ++i) {
            IPropertyDescriptor descriptor = PropertyDescriptorFactory.getPropertyDescriptor("Style", properties[i]);
            propertiesMap.put(properties[i], descriptor);
            descriptor.createControl(container);
        }
        return container;
    }

    public static Label createGridPlaceholder(Composite parent, int hSpan, boolean grabSpace) {
        Label label = new Label(parent, 0);
        GridData data = new GridData();
        data.horizontalSpan = hSpan;
        data.grabExcessHorizontalSpace = grabSpace;
        label.setLayoutData((Object)data);
        return label;
    }

    public static Label createHorizontalLine(Composite parent, int hSpan) {
        Label label = new Label(parent, 258);
        GridData data = new GridData();
        data.horizontalSpan = hSpan;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    public static void processError(Shell shell, Exception e) {
        ExceptionHandler.handle(e);
    }
}

