/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IFormHandleProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.GroupDialog;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.GroupModelProvider;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentEvent;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;

public class GroupHandleProvider
implements IFormHandleProvider {
    private List input;
    private String[] columnKeys = new String[]{"groupName", "keyExpr"};
    private static int[] columnWidth = new int[]{250, 250};
    private GroupModelProvider modelAdapter = new GroupModelProvider();
    private String[] columnNames;
    private TextCellEditor[] editors;

    public String[] getColumnNames() {
        if (this.columnNames == null) {
            this.columnNames = this.modelAdapter.getColumnNames(this.columnKeys);
        }
        return this.columnNames;
    }

    public String getTitle() {
        return Messages.getString((String)"GroupHandleProvider.Label.Groups");
    }

    public CellEditor[] getEditors(Table table) {
        if (this.editors == null) {
            this.editors = new TextCellEditor[this.columnKeys.length];
            this.editors[0] = new TextCellEditor((Composite)table);
            this.editors[1] = new TextCellEditor((Composite)table);
        }
        return null;
    }

    public boolean doMoveItem(int oldPos, int newPos) throws SemanticException {
        return this.modelAdapter.moveItem(this.input.get(0), oldPos, newPos);
    }

    public boolean doDeleteItem(int pos) throws SemanticException {
        return this.modelAdapter.deleteItem(this.input.get(0), pos);
    }

    public boolean doAddItem(int pos) {
        return UIUtil.createGroup((DesignElementHandle)this.input.get(0));
    }

    public boolean doEditItem(int pos) {
        ListingHandle listingHandle = (ListingHandle)this.input.get(0);
        GroupHandle groupHandle = (GroupHandle)listingHandle.getGroups().get(pos);
        GroupDialog dialog = new GroupDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), GroupDialog.GROUP_DLG_TITLE_EDIT);
        dialog.setInput(groupHandle);
        return dialog.open() == 0;
    }

    public String getColumnText(Object element, int columnIndex) {
        String key = this.columnKeys[columnIndex];
        return this.modelAdapter.getText(element, key);
    }

    public String getImagePath(Object element, int columnIndex) {
        return null;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof List) {
            this.input = (List)inputElement;
        } else {
            this.input = new ArrayList();
            this.input.add(inputElement);
        }
        return this.modelAdapter.getElements(this.input);
    }

    public boolean canModify(Object element, String property) {
        return true;
    }

    public Object getValue(Object element, String property) {
        int index = Arrays.asList(this.columnNames).indexOf(property);
        String columnText = this.getColumnText(element, index);
        return columnText;
    }

    public boolean modify(Object data, String property, Object value) throws NameException, SemanticException {
        String strValue;
        int index = Arrays.asList(this.columnNames).indexOf(property);
        String key = this.columnKeys[index];
        if (value instanceof Integer) {
            int intValue = (Integer)value;
            if (intValue == -1) {
                CCombo combo = (CCombo)this.editors[index].getControl();
                strValue = combo.getText();
            } else {
                String[] choices = this.modelAdapter.getChoiceSet(this.input.get(0), this.columnKeys[index]);
                strValue = choices[intValue];
            }
        } else {
            strValue = (String)value;
        }
        return this.modelAdapter.setStringValue(this.input.get(0), data, key, strValue);
    }

    public int[] getColumnWidths() {
        return columnWidth;
    }

    public boolean needRefreshed(NotificationEvent event) {
        String propertyName;
        if (event instanceof ContentEvent) {
            return true;
        }
        return event instanceof PropertyEvent && ("groupName".equals(propertyName = ((PropertyEvent)event).getPropertyName()) || "keyExpr".equals(propertyName));
    }
}

