/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IFormHandleProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.ComboBoxCellEditor;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.ComboBoxExpressionCellEditor;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.SortingModelProvider;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

public class SortingHandleProvider
implements IFormHandleProvider {
    private List input;
    private String[] columnKeys = new String[]{"key", "direction"};
    private static int[] columnWidth = new int[]{250, 250};
    private SortingModelProvider modelAdapter = new SortingModelProvider();
    private String[] columnNames;
    private CellEditor[] editors;
    private List columnList = new ArrayList();

    private void getDataSetColumns(Object obj) {
        if (obj instanceof DesignElementHandle) {
            this.columnList = new ArrayList();
            String[] columns = this.modelAdapter.getChoiceSet(obj, "key");
            if (columns != null) {
                this.columnList.addAll(Arrays.asList(columns));
            }
            this.setDataList(obj);
        }
    }

    private void setDataList(Object obj) {
        ComboBoxExpressionCellEditor editor = (ComboBoxExpressionCellEditor)this.editors[0];
        editor.setExpressionProvider(new ExpressionProvider((DesignElementHandle)obj));
    }

    public String[] getColumnNames() {
        if (this.columnNames == null) {
            this.columnNames = this.modelAdapter.getColumnNames(this.columnKeys);
        }
        return this.columnNames;
    }

    public String getTitle() {
        return Messages.getString((String)"SortingHandleProvider.Label.SortOn");
    }

    public CellEditor[] getEditors(Table table) {
        if (this.editors == null) {
            this.editors = new CellEditor[this.columnKeys.length];
            this.editors[0] = new ComboBoxExpressionCellEditor((Composite)table);
            this.editors[1] = new ComboBoxCellEditor((Composite)table, new String[0], 8);
        }
        return this.editors;
    }

    public boolean doMoveItem(int oldPos, int newPos) throws PropertyValueException {
        return this.modelAdapter.moveItem(this.input.get(0), oldPos, newPos);
    }

    public boolean doDeleteItem(int pos) throws PropertyValueException {
        return this.modelAdapter.deleteItem(this.input.get(0), pos);
    }

    public boolean doAddItem(int pos) throws SemanticException {
        return this.modelAdapter.doAddItem(this.input.get(0), pos);
    }

    public boolean doEditItem(int pos) {
        return true;
    }

    public String getColumnText(Object element, int columnIndex) {
        String key = this.columnKeys[columnIndex];
        return this.modelAdapter.getText(element, key);
    }

    public String getImagePath(Object element, int columnIndex) {
        return null;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof List) {
            this.input = (List)inputElement;
        } else {
            this.input = new ArrayList();
            this.input.add(inputElement);
        }
        this.getDataSetColumns(this.input.get(0));
        ((ComboBoxExpressionCellEditor)this.editors[0]).setItems(this.columnList.toArray(new String[this.columnList.size()]));
        ((ComboBoxCellEditor)this.editors[1]).setItems(this.modelAdapter.getChoiceSet(this.input.get(0), this.columnKeys[1]));
        Object[] elements = this.modelAdapter.getElements(this.input);
        return elements;
    }

    public boolean canModify(Object element, String property) {
        return true;
    }

    public Object getValue(Object element, String property) {
        int index = Arrays.asList(this.columnNames).indexOf(property);
        String columnText = this.getColumnText(element, index);
        return columnText;
    }

    public boolean modify(Object data, String property, Object value) throws NameException, SemanticException {
        String strValue;
        int index = Arrays.asList(this.columnNames).indexOf(property);
        String key = this.columnKeys[index];
        if (value instanceof Integer) {
            int intValue = (Integer)value;
            if (intValue == -1) {
                CCombo combo = (CCombo)this.editors[index].getControl();
                strValue = combo.getText();
            } else {
                String[] choices = this.modelAdapter.getChoiceSet(this.input.get(0), this.columnKeys[index]);
                strValue = choices[intValue];
            }
        } else {
            strValue = (String)value;
        }
        return this.modelAdapter.setStringValue(this.input.get(0), data, key, strValue);
    }

    public int[] getColumnWidths() {
        return columnWidth;
    }

    public boolean needRefreshed(NotificationEvent event) {
        if (event instanceof PropertyEvent) {
            String propertyName = ((PropertyEvent)event).getPropertyName();
            if ("boundDataColumns".equals(propertyName)) {
                this.getDataSetColumns(this.input.get(0));
                ((ComboBoxExpressionCellEditor)this.editors[0]).setItems(this.columnList.toArray(new String[this.columnList.size()]));
            }
            if ("sort".equals(propertyName)) {
                return true;
            }
        }
        return false;
    }
}

