/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.AbstractPropertyDescriptor;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.ColorBuilder;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.PropertyProcessor;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.util.ColorUtil;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ColorPropertyDescriptor
extends AbstractPropertyDescriptor {
    private ColorBuilder builder;

    public ColorPropertyDescriptor(PropertyProcessor propertyProcessor) {
        super(propertyProcessor);
    }

    public void resetUIData() {
        boolean stateFlag;
        String strValue = this.getPropertyProcessor().getStringValue(this.getModelList());
        this.builder.getRGB();
        boolean bl = stateFlag = strValue == null == this.builder.getEnabled();
        if (stateFlag) {
            this.builder.setEnabled(strValue != null);
        }
        this.builder.setColorValue(strValue);
    }

    public Control getControl() {
        return this.builder;
    }

    public Control createControl(Composite parent) {
        this.builder = new ColorBuilder(parent, 0);
        String name = this.getPropertyProcessor().getElementName();
        String propertyName = this.getPropertyProcessor().getProperty();
        this.builder.setChoiceSet(ChoiceSetFactory.getElementChoiceSet(name, propertyName));
        this.builder.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                ColorPropertyDescriptor.this.processAction();
            }
        });
        return this.builder;
    }

    private void processAction() {
        int oldValue = ColorUtil.parseColor((String)this.getPropertyProcessor().getStringValue(this.getModelList()));
        ColorUtil.getRGBs((int)oldValue);
        RGB rgb = this.builder.getRGB();
        int colorValue = -1;
        if (rgb != null) {
            colorValue = ColorUtil.formRGB((int)rgb.red, (int)rgb.green, (int)rgb.blue);
        }
        if (oldValue == colorValue) {
            return;
        }
        String value = this.builder.getPredefinedColor();
        if (value == null && rgb != null) {
            value = ColorUtil.format((int)colorValue, (int)0);
        }
        try {
            this.getPropertyProcessor().setStringValue(value, this.getModelList());
        }
        catch (SemanticException e) {
            WidgetUtil.processError(this.builder.getShell(), (Exception)((Object)e));
        }
        if (rgb == null) {
            String colorString = this.getPropertyProcessor().getStringValue(this.getModelList());
            this.builder.setColorValue(colorString);
        }
    }
}

