/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import java.util.Arrays;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.CCombo;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ComboBoxCellEditor
extends CellEditor {
    private String[] items;
    int selection;
    CCombo comboBox;
    private static final int defaultStyle = 0;
    private Object value;
    private int inProcessing = 0;

    public ComboBoxCellEditor() {
        this.setStyle(0);
    }

    public ComboBoxCellEditor(Composite parent, String[] items) {
        this(parent, items, 0);
    }

    public ComboBoxCellEditor(Composite parent, String[] items, int style) {
        super(parent, style);
        this.setItems(items);
    }

    protected Object doGetValue() {
        CCombo comboBox = (CCombo)super.getControl();
        if (this.selection != -1) {
            return comboBox.getItem(this.selection);
        }
        return comboBox.getText();
    }

    protected void doSetValue(Object value) {
        CCombo comboBox = (CCombo)super.getControl();
        Assert.isTrue((comboBox != null ? 1 : 0) != 0);
        if (value instanceof Integer) {
            this.selection = (Integer)value;
            comboBox.select(this.selection);
        } else {
            comboBox.setText((String)value);
            this.value = value;
            this.selection = Arrays.asList(comboBox.getItems()).indexOf(value);
        }
    }

    public String[] getItems() {
        return this.items;
    }

    public void setItems(String[] items) {
        Assert.isNotNull((Object)items);
        this.items = items;
        this.populateComboBoxItems();
    }

    protected Control createControl(Composite parent) {
        this.comboBox = new CCombo(parent, this.getStyle());
        this.comboBox.setFont(parent.getFont());
        this.comboBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                ComboBoxCellEditor.this.keyReleaseOccured(e);
            }
        });
        this.comboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                ComboBoxCellEditor.this.markDirty();
                ComboBoxCellEditor.this.applyEditorValueAndDeactivate();
            }

            public void widgetSelected(SelectionEvent event) {
                ComboBoxCellEditor.this.applyEditorValueAndDeactivate();
            }
        });
        this.comboBox.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.comboBox.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ComboBoxCellEditor.this.focusLost();
            }
        });
        return this.comboBox;
    }

    protected void doSetFocus() {
        this.comboBox.setFocus();
    }

    public CellEditor.LayoutData getLayoutData() {
        CellEditor.LayoutData layoutData = super.getLayoutData();
        if (this.comboBox == null || this.comboBox.isDisposed()) {
            layoutData.minimumWidth = 60;
        } else {
            GC gc = new GC((Drawable)this.comboBox);
            layoutData.minimumWidth = gc.getFontMetrics().getAverageCharWidth() * 10 + 10;
            gc.dispose();
        }
        return layoutData;
    }

    private void populateComboBoxItems() {
        if (this.comboBox != null && this.items != null) {
            this.comboBox.removeAll();
            for (int i = 0; i < this.items.length; ++i) {
                this.comboBox.add(this.items[i], i);
            }
            this.setValueValid(true);
            this.selection = 0;
        }
    }

    void applyEditorValueAndDeactivate() {
        this.inProcessing = 1;
        if (this.selection != this.comboBox.getSelectionIndex()) {
            this.markDirty();
        }
        this.selection = this.comboBox.getSelectionIndex();
        String newValue = null;
        newValue = this.selection == -1 ? this.comboBox.getText() : this.comboBox.getItem(this.selection);
        this.doSetValue(newValue);
        boolean isValid = this.isCorrect(newValue);
        this.setValueValid(isValid);
        this.fireApplyEditorValue();
        this.deactivate();
        this.inProcessing = 0;
    }

    protected void focusLost() {
        if (this.inProcessing == 1) {
            return;
        }
        if (!this.comboBox.getText().equals(this.value)) {
            this.markDirty();
        }
        if (this.isActivated()) {
            this.applyEditorValueAndDeactivate();
        }
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\u001b') {
            this.fireCancelEditor();
        } else if (keyEvent.character == '\t') {
            this.applyEditorValueAndDeactivate();
        } else if (keyEvent.character == '\r') {
            this.markDirty();
            this.applyEditorValueAndDeactivate();
        }
    }
}

