/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.AbstractPropertyDescriptor;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.PropertyProcessor;
import org.eclipse.birt.report.designer.util.AlphabeticallyComparator;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ComboPropertyDescriptor
extends AbstractPropertyDescriptor {
    protected Combo combo;
    protected IChoiceSet choiceSet;
    protected String oldValue;

    public ComboPropertyDescriptor(PropertyProcessor propertyProcessor) {
        super(propertyProcessor);
    }

    public void resetUIData() {
        boolean stateFlag;
        if (this.choiceSet == null) {
            this.choiceSet = ChoiceSetFactory.getElementChoiceSet(this.getPropertyProcessor().getElementName(), this.getPropertyProcessor().getProperty());
            String[] displayNames = ChoiceSetFactory.getDisplayNamefromChoiceSet(this.choiceSet, (Comparator)new AlphabeticallyComparator());
            if (this.getPropertyProcessor().getProperty().equals("fontFamily")) {
                String[] sysFont = DEUtil.getSystemFontNames();
                String[] items = new String[displayNames.length + sysFont.length + 1];
                items[0] = ChoiceSetFactory.CHOICE_AUTO;
                System.arraycopy(displayNames, 0, items, 1, displayNames.length);
                System.arraycopy(sysFont, 0, items, displayNames.length + 1, sysFont.length);
                for (int i = 0; i < items.length; ++i) {
                    UIUtil.RemoveQuote(items[i]);
                }
                this.combo.setItems(items);
            } else if ("textAlign".equals(this.getPropertyProcessor().getProperty()) || "verticalAlign".equals(this.getPropertyProcessor().getProperty())) {
                String[] items = new String[displayNames.length + 1];
                items[0] = ChoiceSetFactory.CHOICE_AUTO;
                System.arraycopy(displayNames, 0, items, 1, displayNames.length);
                this.combo.setItems(items);
            } else {
                this.combo.setItems(displayNames);
            }
        }
        this.oldValue = this.getPropertyProcessor().getStringValue(this.getModelList());
        if (this.getPropertyProcessor().getProperty().equals("fontFamily")) {
            this.oldValue = UIUtil.RemoveQuote(this.oldValue);
        }
        boolean bl = stateFlag = this.oldValue == null == this.combo.getEnabled();
        if (stateFlag) {
            this.combo.setEnabled(this.oldValue != null);
        }
        if (this.getPropertyProcessor().isReadOnly(this.getModelList())) {
            this.combo.setEnabled(false);
        }
        IChoice choice = null;
        if (this.choiceSet != null) {
            choice = this.choiceSet.findChoice(this.oldValue);
        }
        if (choice == null) {
            this.combo.deselectAll();
            if (this.oldValue != null) {
                this.combo.setText(this.oldValue);
            }
            return;
        }
        this.oldValue = choice.getDisplayName();
        this.combo.select(Arrays.asList(this.combo.getItems()).indexOf(this.oldValue));
    }

    public Control getControl() {
        return this.combo;
    }

    public Control createControl(Composite parent) {
        this.combo = new Combo(parent, 2056);
        this.combo.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
                ComboPropertyDescriptor.this.combo.clearSelection();
            }

            public void controlResized(ControlEvent e) {
                ComboPropertyDescriptor.this.combo.clearSelection();
            }
        });
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ComboPropertyDescriptor.this.processAction();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ComboPropertyDescriptor.this.processAction();
            }
        });
        this.combo.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
            }
        });
        return this.combo;
    }

    private void processAction() {
        String newValue = this.combo.getText();
        if ("".equals(newValue)) {
            newValue = null;
        }
        String pName = this.getPropertyProcessor().getProperty();
        if (ChoiceSetFactory.CHOICE_AUTO.equals(newValue) && ("fontFamily".equals(pName) || "textAlign".equals(pName) || "verticalAlign".equals(pName))) {
            newValue = null;
        }
        if (ChoiceSetFactory.CHOICE_NONE.equals(newValue) && "includeResource".equals(pName)) {
            newValue = null;
        }
        try {
            if ("fontFamily".equals(pName) && this.needAddQuote(newValue)) {
                this.getPropertyProcessor().setStringValue(UIUtil.AddQuote(newValue), this.getModelList());
            } else {
                this.getPropertyProcessor().setStringValue(newValue, this.getModelList());
            }
        }
        catch (SemanticException e) {
            this.combo.setText(this.oldValue);
            WidgetUtil.processError(this.combo.getShell(), (Exception)((Object)e));
        }
    }

    private boolean needAddQuote(String value) {
        IChoiceSet choice = ChoiceSetFactory.getElementChoiceSet(this.getPropertyProcessor().getElementName(), this.getPropertyProcessor().getProperty());
        String[] displayNames = ChoiceSetFactory.getDisplayNamefromChoiceSet(choice, (Comparator)new AlphabeticallyComparator());
        for (int i = 0; i < displayNames.length; ++i) {
            if (!displayNames[i].equals(value)) continue;
            return false;
        }
        return true;
    }
}

