/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.ResourceEditDialog;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.AbstractPropertyDescriptor;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.PropertyProcessor;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ResourceKeyDescriptor
extends AbstractPropertyDescriptor {
    private Text text;
    private Button btnBrowse;
    private Button btnReset;
    private String oldValue;

    public ResourceKeyDescriptor(PropertyProcessor propertyProcessor) {
        super(propertyProcessor);
    }

    public void resetUIData() {
        this.oldValue = this.getPropertyProcessor().getStringValue(this.getModelList());
        String baseName = SessionHandleAdapter.getInstance().getReportDesignHandle().getIncludeResource();
        this.btnBrowse.setEnabled(baseName != null);
        this.text.setEnabled(baseName != null);
        this.text.setText(DEUtil.resolveNull((String)this.oldValue));
    }

    public Control createControl(Composite parent) {
        Composite innerParent = new Composite(parent, 0);
        innerParent.setLayout((Layout)new GridLayout(3, false));
        this.text = new Text(innerParent, 2056);
        this.text.setLayoutData((Object)new GridData(768));
        this.btnBrowse = new Button(innerParent, 8);
        this.btnBrowse.setText("...");
        this.btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String baseName = SessionHandleAdapter.getInstance().getReportDesignHandle().getIncludeResource();
                String designFileName = SessionHandleAdapter.getInstance().getReportDesignHandle().getFileName();
                String designFilePath = ReportPlugin.getDefault().getResourcePreference();
                ResourceEditDialog dlg = new ResourceEditDialog(ResourceKeyDescriptor.this.btnBrowse.getShell(), Messages.getString((String)"ResourceKeyDescriptor.title.SelectKey"));
                dlg.setBaseName(baseName);
                dlg.setDesignFolder(designFilePath);
                if (dlg.open() == 0) {
                    ResourceKeyDescriptor.this.processAction((String)dlg.getResult());
                }
            }
        });
        this.btnReset = new Button(innerParent, 8);
        this.btnReset.setText(Messages.getString((String)"ResourceKeyDescriptor.text.Reset"));
        this.btnReset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceKeyDescriptor.this.processAction(null);
            }
        });
        return innerParent;
    }

    private void processAction(String newValue) {
        if ("".equals(newValue)) {
            newValue = null;
        }
        try {
            this.getPropertyProcessor().setStringValue(newValue, this.getModelList());
            this.text.setText(DEUtil.resolveNull((String)newValue));
        }
        catch (SemanticException e) {
            this.text.setText(DEUtil.resolveNull((String)this.oldValue));
            WidgetUtil.processError(this.text.getShell(), (Exception)((Object)e));
        }
    }
}

