/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.AbstractPropertyDescriptor;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.PropertyProcessor;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class TextAlignPropertyDescriptor
extends AbstractPropertyDescriptor {
    protected Button right;
    protected Button left;
    protected Button justify;
    protected Button center;
    protected Composite container;
    protected SelectionListener listener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (e.widget != TextAlignPropertyDescriptor.this.right) {
                TextAlignPropertyDescriptor.this.right.setSelection(false);
            }
            if (e.widget != TextAlignPropertyDescriptor.this.left) {
                TextAlignPropertyDescriptor.this.left.setSelection(false);
            }
            if (e.widget != TextAlignPropertyDescriptor.this.center) {
                TextAlignPropertyDescriptor.this.center.setSelection(false);
            }
            if (e.widget != TextAlignPropertyDescriptor.this.justify) {
                TextAlignPropertyDescriptor.this.justify.setSelection(false);
            }
            if (!(TextAlignPropertyDescriptor.this.right.getSelection() || TextAlignPropertyDescriptor.this.left.getSelection() || TextAlignPropertyDescriptor.this.center.getSelection() || TextAlignPropertyDescriptor.this.justify.getSelection())) {
                Button btn = (Button)e.widget;
                btn.setSelection(true);
                return;
            }
            String value = (String)e.widget.getData();
            try {
                TextAlignPropertyDescriptor.this.getPropertyProcessor().setStringValue(value, TextAlignPropertyDescriptor.this.getModelList());
            }
            catch (SemanticException e1) {
                WidgetUtil.processError(TextAlignPropertyDescriptor.this.right.getShell(), (Exception)((Object)e1));
            }
        }
    };

    public TextAlignPropertyDescriptor(PropertyProcessor propertyProcessor) {
        super(propertyProcessor);
    }

    public void resetUIData() {
        String value = this.getPropertyProcessor().getStringValue(this.getModelList());
        Button[] btns = new Button[]{this.left, this.right, this.center, this.justify};
        boolean stateFlag = value == null == btns[0].getEnabled();
        for (int i = 0; i < btns.length; ++i) {
            if (btns[i].getData().equals(value)) {
                btns[i].setSelection(true);
            } else {
                btns[i].setSelection(false);
            }
            if (!stateFlag) continue;
            btns[i].setEnabled(value != null);
        }
        String[] values = new String[]{"left", "right", "center", "justify"};
        for (int i = 0; i < values.length; ++i) {
            String imageName = values[i];
            if (!btns[i].isEnabled()) {
                imageName = imageName + "DIS";
            }
            btns[i].setImage(ReportPlatformUIImages.getImage(imageName));
        }
    }

    public Control getControl() {
        return this.container;
    }

    public Control createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        RowLayout layout = new RowLayout(256);
        layout.marginBottom = 0;
        layout.marginHeight = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = 0;
        layout.marginWidth = 0;
        layout.spacing = 0;
        this.container.setLayout((Layout)layout);
        this.left = new Button(this.container, 2);
        this.left.setToolTipText(Messages.getString((String)"TextAlignPropertyDescriptor.0"));
        this.center = new Button(this.container, 2);
        this.center.setToolTipText(Messages.getString((String)"TextAlignPropertyDescriptor.1"));
        this.right = new Button(this.container, 2);
        this.right.setToolTipText(Messages.getString((String)"TextAlignPropertyDescriptor.2"));
        this.justify = new Button(this.container, 2);
        this.justify.setToolTipText(Messages.getString((String)"TextAlignPropertyDescriptor.3"));
        Button[] btns = new Button[]{this.left, this.center, this.right, this.justify};
        String[] values = new String[]{"left", "center", "right", "justify"};
        for (int i = 0; i < btns.length; ++i) {
            btns[i].setData((Object)values[i]);
            btns[i].addSelectionListener(this.listener);
        }
        return this.container;
    }
}

