/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import java.util.Arrays;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.AbstractPropertyDescriptor;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.PropertyProcessor;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class UnitPropertyDescriptor
extends AbstractPropertyDescriptor {
    private static final String ERROR_MESSAGE = Messages.getString((String)"UnitPropertyDescriptor.error.message");
    private static final String ERROR_BOX_TITLE = Messages.getString((String)"UnitPropertyDescriptor.error.title");
    protected Text text;
    protected Combo combo;
    protected Composite container;
    protected IChoiceSet choiceSet;
    protected String deMeasureValue;
    protected String deUnitValue;
    private boolean hasError = false;

    public UnitPropertyDescriptor(PropertyProcessor propertyProcessor) {
        super(propertyProcessor);
    }

    public void resetUIData() {
        boolean stateFlag;
        String value = this.getPropertyProcessor().getStringValue(this.getModelList());
        boolean bl = stateFlag = value == null == this.text.getEnabled();
        if (stateFlag) {
            this.text.setEnabled(value != null);
            this.combo.setEnabled(value != null);
        }
        this.deMeasureValue = this.getPropertyProcessor().getMeasureValue(this.getModelList());
        if (this.deMeasureValue == null) {
            this.deMeasureValue = "";
        }
        if (!this.deMeasureValue.equals(this.text.getText())) {
            this.text.setText(this.deMeasureValue);
        }
        String[] displayNames = null;
        if (this.choiceSet == null) {
            this.choiceSet = ChoiceSetFactory.getElementChoiceSet(this.getPropertyProcessor().getElementName(), this.getPropertyProcessor().getProperty());
            displayNames = ChoiceSetFactory.getDisplayNamefromChoiceSet(this.choiceSet);
            this.combo.setItems(displayNames);
        }
        if (displayNames == null) {
            displayNames = ChoiceSetFactory.getDisplayNamefromChoiceSet(this.choiceSet);
        }
        this.deUnitValue = this.getPropertyProcessor().getUnit(this.getModelList());
        IChoice choice = this.choiceSet.findChoice(this.deUnitValue);
        if (choice == null) {
            this.combo.deselectAll();
            return;
        }
        if (!choice.getDisplayName().equals(this.combo.getText())) {
            this.combo.select(Arrays.asList(displayNames).indexOf(choice.getDisplayName()));
        }
    }

    public Control getControl() {
        return this.container;
    }

    public Control createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.spacing = 0;
        this.container.setLayout((Layout)layout);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UnitPropertyDescriptor.this.processAction();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                UnitPropertyDescriptor.this.processAction();
            }
        };
        this.text = new Text(this.container, 133120);
        this.text.addSelectionListener(listener);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (UnitPropertyDescriptor.this.combo.getItemCount() > 0 && (UnitPropertyDescriptor.this.combo.getText() == null || UnitPropertyDescriptor.this.combo.getText().length() == 0)) {
                    String unit = UnitPropertyDescriptor.this.getPropertyProcessor().getDefaultUnit(UnitPropertyDescriptor.this.getModelList());
                    if (unit != null) {
                        if (!StringUtil.isBlank((String)unit)) {
                            unit = UnitPropertyDescriptor.this.getUnitChoiceSet().findChoice(unit).getDisplayName();
                        }
                        UnitPropertyDescriptor.this.combo.setText(unit);
                    } else {
                        UnitPropertyDescriptor.this.combo.setText(UnitPropertyDescriptor.this.combo.getItem(0));
                    }
                }
            }
        });
        this.text.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (!UnitPropertyDescriptor.this.hasError) {
                    UnitPropertyDescriptor.this.processAction();
                }
            }
        });
        this.combo = new Combo(this.container, 2056);
        this.combo.addSelectionListener(listener);
        FormData data = new FormData();
        data.left = new FormAttachment(60);
        data.right = new FormAttachment(100);
        this.combo.setLayoutData((Object)data);
        data = new FormData();
        data.bottom = new FormAttachment((Control)this.combo, 0, 1024);
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(60);
        this.text.setLayoutData((Object)data);
        return this.container;
    }

    protected boolean validateDimensionValue() {
        if (this.combo.isEnabled() && this.combo.getSelectionIndex() != -1) {
            String value = this.text.getText();
            String unit = this.getUnitChoiceSet().findChoiceByDisplayName(this.combo.getText()).getName();
            boolean val = true;
            try {
                val = this.getPropertyProcessor().validateDimensionValue(value + unit, this.getModelList());
            }
            catch (PropertyValueException e1) {
                // empty catch block
            }
            return val;
        }
        return true;
    }

    private void processAction() {
        if (!this.validateDimensionValue()) {
            this.setError();
            ExceptionHandler.openErrorMessageBox(ERROR_BOX_TITLE, ERROR_MESSAGE);
            this.resetUIData();
            this.clearError();
            return;
        }
        String value = this.text.getText().trim();
        if (value.equals("")) {
            value = null;
        } else {
            IChoice choice;
            if (this.choiceSet != null && (choice = this.choiceSet.findChoiceByDisplayName(this.combo.getText())) != null) {
                value = value + choice.getName();
            }
            if (value.equals(this.deMeasureValue + this.deUnitValue)) {
                return;
            }
        }
        try {
            this.getPropertyProcessor().setStringValue(value, this.getModelList());
        }
        catch (SemanticException e) {
            this.text.setText(this.deMeasureValue);
            WidgetUtil.processError(this.combo.getShell(), (Exception)((Object)e));
        }
    }

    private void setError() {
        this.hasError = true;
    }

    private void clearError() {
        this.hasError = false;
    }
}

