/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.data.providers;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetEditor;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetUIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.DefaultNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.actions.RefreshAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.actions.ShowPropertyAction;
import org.eclipse.birt.report.designer.ui.odadatasource.wizards.WizardUtil;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CachedMetaDataHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSetParameterHandle;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DataSetNodeProvider
extends DefaultNodeProvider {
    public void createContextMenu(TreeViewer sourceViewer, Object object, IMenuManager menu) {
        super.createContextMenu(sourceViewer, object, menu);
        if (((DataSetHandle)object).canEdit()) {
            WizardUtil.createEditDataSetMenu(menu, object);
        }
        menu.insertBefore("additions-refresh", (IAction)new ShowPropertyAction(object));
        menu.insertAfter("additions-refresh", (IContributionItem)new Separator());
        menu.insertAfter("additions-refresh", (IAction)new RefreshAction(sourceViewer));
    }

    public String getNodeDisplayName(Object model) {
        return DEUtil.getDisplayLabel((Object)model, (boolean)false);
    }

    public Image getNodeIcon(Object model) {
        DataSetHandle handle = (DataSetHandle)model;
        if (!(handle instanceof JointDataSetHandle) && handle.getDataSource() == null) {
            return ReportPlatformUIImages.getImage("IMG_OBJS_ERROR_TSK");
        }
        return super.getNodeIcon(model);
    }

    public Object[] getChildren(Object object) {
        PropertyHandle parameters;
        Iterator iter;
        DataSetHandle handle = (DataSetHandle)object;
        ArrayList params = new ArrayList(10);
        CachedMetaDataHandle cmdh = null;
        try {
            cmdh = DataSetUIUtil.getCachedMetaDataHandle(handle);
        }
        catch (SemanticException e) {
            // empty catch block
        }
        ArrayList<ResultSetColumnHandle> columns = new ArrayList<ResultSetColumnHandle>(10);
        if (cmdh != null) {
            Iterator iterator = cmdh.getResultSet().iterator();
            while (iterator.hasNext()) {
                ResultSetColumnHandle element = (ResultSetColumnHandle)iterator.next();
                columns.add(element);
            }
        }
        if ((iter = (parameters = handle.getPropertyHandle("parameters")).iterator()) != null) {
            while (iter.hasNext()) {
                Object dataSetParameter = iter.next();
                if (!((DataSetParameterHandle)dataSetParameter).isOutput()) continue;
                params.add(dataSetParameter);
            }
        }
        Object[] parametersArray = params.toArray();
        Object[] both = new Object[columns.toArray().length + parametersArray.length];
        System.arraycopy(columns.toArray(), 0, both, 0, columns.toArray().length);
        System.arraycopy(parametersArray, 0, both, columns.toArray().length, parametersArray.length);
        return both;
    }

    public boolean hasChildren(Object object) {
        return true;
    }

    protected boolean performEdit(ReportElementHandle handle) {
        DataSetHandle dsHandle = (DataSetHandle)handle;
        if (!(dsHandle instanceof JointDataSetHandle) && dsHandle.getDataSource() == null) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.getString((String)"dataset.error.title.noDataSources"), (String)Messages.getString((String)"dataset.error.dataSourceMissing"));
            return false;
        }
        DataSetEditor dialog = new DataSetEditor(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (DataSetHandle)handle, false);
        return dialog.open() == 0;
    }
}

