/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.data.providers;

import org.eclipse.birt.report.designer.internal.ui.views.DefaultNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.actions.EditAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.CascadingParametersDialog;
import org.eclipse.birt.report.designer.ui.dialogs.ParameterDialog;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CascadingParameterGroupHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.PlatformUI;

public class ParameterNodeProvider
extends DefaultNodeProvider {
    public void createContextMenu(TreeViewer sourceViewer, Object object, IMenuManager menu) {
        super.createContextMenu(sourceViewer, object, menu);
        menu.insertAfter("additions", (IAction)new EditAction(object, Messages.getString((String)"ParameterNodeProvider.menu.text.edit")));
    }

    public String getNodeDisplayName(Object model) {
        return DEUtil.getDisplayLabel((Object)model, (boolean)false);
    }

    protected boolean performEdit(ReportElementHandle handle) {
        if (handle instanceof ScalarParameterHandle) {
            ScalarParameterHandle param = (ScalarParameterHandle)handle;
            if (param.getContainer() instanceof CascadingParameterGroupHandle) {
                CascadingParametersDialog dialog = new CascadingParametersDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.getString((String)"ParameterNodeProvider.dial.title.editCascading"));
                dialog.setInput(param.getContainer());
                return dialog.open() == 0;
            }
            ParameterDialog dialog = new ParameterDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.getString((String)"ParameterNodeProvider.dial.title.editScalar"));
            dialog.setInput(handle);
            return dialog.open() == 0;
        }
        return true;
    }
}

