/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.property.widgets;

import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class DimensionBuilderDialog
extends SelectionStatusDialog {
    private static String TITLE = Messages.getString((String)"DimensionBuilderDialog.Title");
    private static String LABEL_MEASURE = Messages.getString((String)"DimensionBuilderDialog.LabelMeasure");
    private static String LABEL_UNIT = Messages.getString((String)"DimensionBuilderDialog.LabelUnit");
    private Button[] units = new Button[0];
    private String[] unitNames;
    private Text measure = null;
    private Object measureData = "";
    private int unitData;

    public DimensionBuilderDialog(Shell parent) {
        super(parent);
        this.setTitle(TITLE);
    }

    protected void computeResult() {
        this.measureData = this.measure.getText();
        for (int i = 0; i < this.units.length; ++i) {
            if (!this.units[i].getSelection()) continue;
            this.unitData = i;
            break;
        }
    }

    protected Control createDialogArea(Composite parent) {
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.DimensionBuilderDialog_ID");
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        this.createMeasureField(composite);
        this.createUnitGroup(composite);
        return composite;
    }

    private void createMeasureField(Composite composite) {
        new Label(composite, 0).setText(LABEL_MEASURE);
        this.measure = new Text(composite, 2052);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        this.measure.setLayoutData((Object)gridData);
        this.measure.setFont(composite.getFont());
        if (this.measureData != null) {
            this.measure.setText(this.measureData.toString());
        }
    }

    private void createUnitGroup(Composite composite) {
        Label unitLabel = new Label(composite, 0);
        unitLabel.setText(LABEL_UNIT);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        unitLabel.setLayoutData((Object)gridData);
        this.units = new Button[this.unitNames.length];
        for (int i = 0; i < this.units.length; ++i) {
            this.units[i] = new Button(composite, 16);
            this.units[i].setText(this.unitNames[i]);
            if (i == this.unitData) {
                this.units[i].setSelection(true);
                continue;
            }
            this.units[i].setSelection(false);
        }
    }

    public void setMeasureData(Object measureData) {
        if (measureData != null) {
            this.measureData = measureData;
        }
    }

    public void setUnitNames(String[] unitNames) {
        this.unitNames = unitNames;
    }

    public void setUnitData(int unit) {
        this.unitData = unit;
    }

    public Object getMeasureData() {
        return this.measureData;
    }

    public String getUnitName() {
        if (this.unitData > this.unitNames.length - 1 || this.unitData < 0) {
            return "";
        }
        return this.unitNames[this.unitData];
    }
}

