/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.wizards;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.wizards.WizardLibrarySettingPage;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class PublishLibraryWizard
extends Wizard {
    LibraryHandle handle;
    private static String windowTitle = Messages.getString((String)"PublishLibraryDialog.ShellText");
    private static String PAGE_TITLE = Messages.getString((String)"PublishLibraryDialog.TitleArea");
    private static String PAGE_DESC = Messages.getString((String)"PublishLibraryDialog.Message");
    private static String addLibraryTitle = Messages.getString((String)"PublishLibraryDialog.AddLibrary");
    private String filePath;
    private String fileName;
    private String folderName;
    private WizardLibrarySettingPage page;
    public static int HAVE_HANDLE = 1;
    public static int HAVE_NO_HANDLE = 0;
    int type;

    public PublishLibraryWizard(LibraryHandle handle, String fileName, String folderName) {
        this.setWindowTitle(windowTitle);
        this.fileName = fileName;
        this.folderName = folderName;
        this.handle = handle;
        this.filePath = SessionHandleAdapter.getInstance().getReportDesignHandle().getFileName();
        this.type = HAVE_HANDLE;
    }

    public PublishLibraryWizard(String folderName) {
        this.setWindowTitle(addLibraryTitle);
        this.fileName = null;
        this.folderName = folderName;
        this.handle = null;
        this.type = HAVE_NO_HANDLE;
    }

    public void addPages() {
        this.page = new WizardLibrarySettingPage(this.type);
        if (this.type == HAVE_HANDLE) {
            this.page.setTitle(PAGE_TITLE);
            this.page.setMessage(PAGE_DESC);
            this.page.setFileName(this.fileName);
            this.page.setfolderName(this.folderName);
        } else if (this.type == HAVE_NO_HANDLE) {
            this.page.setTitle(Messages.getString((String)"PublishLibraryDialog.AddText"));
            this.page.setMessage(Messages.getString((String)"PublishLibraryDialog.AddMessage"));
            this.page.setfolderName(this.folderName);
        }
        this.page.setType(this.type);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        this.fileName = this.page.getFileName();
        this.folderName = this.page.getFolder();
        if (this.type == HAVE_NO_HANDLE) {
            this.filePath = this.page.getSourceFileName();
        }
        return this.publishiLibrary();
    }

    public boolean canFinish() {
        return this.page.canFinish();
    }

    private boolean publishiLibrary() {
        File targetFile;
        File targetFolder = new File(this.folderName);
        if (targetFolder.exists() && !targetFolder.isDirectory()) {
            ExceptionHandler.openErrorMessageBox(Messages.getString((String)"PublishLibraryAction.wizard.errorTitle"), Messages.getString((String)"PublishLibraryAction.wizard.notvalidfolder"));
            return true;
        }
        if (!targetFolder.exists()) {
            targetFolder.mkdirs();
        }
        if (new File(this.filePath).compareTo(targetFile = new File(targetFolder, this.fileName)) == 0) {
            ExceptionHandler.openErrorMessageBox(Messages.getString((String)"PublishLibraryAction.wizard.errorTitle"), Messages.getString((String)"PublishLibraryAction.wizard.message"));
            return false;
        }
        int overwrite = 0;
        try {
            if (targetFile.exists()) {
                String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
                String question = Messages.getFormattedString((String)"SaveAsDialog.overwriteQuestion", (Object[])new Object[]{targetFile.getAbsolutePath()});
                MessageDialog d = new MessageDialog(UIUtil.getDefaultShell(), Messages.getString((String)"SaveAsDialog.Question"), null, question, 3, buttons, 0);
                overwrite = d.open();
            }
            if (overwrite == 0 && (targetFile.exists() || !targetFile.exists() && targetFile.createNewFile())) {
                this.copyFile(this.filePath, targetFile);
            }
        }
        catch (IOException e) {
            ExceptionHandler.handle(e);
        }
        return overwrite != 1;
    }

    private void copyFile(String in, File targetFile) throws IOException {
        FileInputStream fis = new FileInputStream(in);
        FileOutputStream fos = new FileOutputStream(targetFile);
        byte[] buf = new byte[1024];
        int i = 0;
        while ((i = fis.read(buf)) != -1) {
            fos.write(buf, 0, i);
        }
        fis.close();
        fos.close();
    }
}

