/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import com.ibm.icu.util.ULocale;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.core.format.StringFormatter;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetUIUtil;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.ComboBoxCellEditor;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.FormatBuilder;
import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CachedMetaDataHandle;
import org.eclipse.birt.report.model.api.CascadingParameterGroupHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class CascadingParametersDialog
extends BaseDialog {
    private static final String LABEL_PARAMTER_PROMPT_TEXT = Messages.getString((String)"CascadingParametersDialog.Label.parameterPromptText");
    private static final String LABEL_VALUES = Messages.getString((String)"CascadingParametersDialog.Label.values");
    private static final String LABEL_GROUP_GENERAL = Messages.getString((String)"CascadingParametersDialog.Label.group.general");
    private static final String LABEL_CASCADING_PARAMETER_NAME = Messages.getString((String)"CascadingParametersDialog.Label.cascadingParam.name");
    private static final String LABEL_GROUP_PROMPT_TEXT = Messages.getString((String)"CascadingParametersDialog.Label.groupPromptText");
    private static final String LABEL_PARAMETERS = Messages.getString((String)"CascadingParametersDialog.Label.parameters");
    private static final String LABEL_GROUP_PROPERTIES = Messages.getString((String)"CascadingParametersDialog.Label.group.properties");
    private static final String LABEL_PARAM_NAME = Messages.getString((String)"CascadingParametersDialog.Label.param.name");
    private static final String LABEL_LIST_LIMIT = Messages.getString((String)"CascadingParametersDialog.Label.listLimit");
    private static final String LABEL_DATA_TYPE = Messages.getString((String)"CascadingParametersDialog.Label.dataType");
    private static final String LABEL_DISPLAY_TYPE = Messages.getString((String)"CascadingParametersDialog.Label.displayType");
    private static final String LABEL_DEFAULT_VALUE = Messages.getString((String)"CascadingParametersDialog.Label.defaultValue");
    private static final String LABEL_GROUP_MORE_OPTIONS = Messages.getString((String)"CascadingParametersDialog.Label.group.moreOptions");
    private static final String LABEL_HELP_TEXT = Messages.getString((String)"CascadingParametersDialog.Label.helpText");
    private static final String LABEL_FORMAT_AS = Messages.getString((String)"CascadingParametersDialog.Label.formatAs");
    private static final String LABEL_CHANGE_FORMAT_BUTTON = Messages.getString((String)"CascadingParametersDialog.Label.button.changeFormat");
    private static final String LABEL_PREVIEW_WITH_FORMAT = Messages.getString((String)"CascadingParametersDialog.Label.preview");
    private static final String LABEL_CREATE_NEW_PARAMETER = Messages.getString((String)"CascadingParametersDialog.Label.createNewParam");
    private static final String LABEL_SELECT_DATA_SET = Messages.getString((String)"CascadingParametersDialog.Label.selectDataSet");
    private static final String LABEL_SELECT_DISPLAY_COLUMN = Messages.getString((String)"CascadingParametersDialog.Label.selectDisplayColumn");
    private static final String LABEL_SELECT_VALUE_COLUMN = Messages.getString((String)"CascadingParametersDialog.Label.selectValueColumn");
    private static final String LABEL_NO_COLUMN_AVAILABLE = Messages.getString((String)"CascadingParametersDialog.Label.NoColumnAvailable");
    private static final String BUTTON_ALLOW_NULL_VALUE = Messages.getString((String)"CascadingParametersDialog.Button.AllowNull");
    private static final String LABEL_SELECT_DATA_SET_MODE = Messages.getString((String)"CascadingParametersDialog.Label.SelectDataSetMode");
    private static final String RADIO_SINGLE = Messages.getString((String)"CascadingParametersDialog.Radio.Single");
    private static final String RADIO_MULTIPLE = Messages.getString((String)"CascadingParametersDialog.Radio.Mutli");
    private static final String COLUMN_NAME = Messages.getString((String)"CascadingParametersDialog.Label.column.name");
    private static final String COLUMN_DATA_SET = Messages.getString((String)"CascadingParametersDialog.Label.column.dataSet");
    private static final String COLUMN_VALUE = Messages.getString((String)"CascadingParametersDialog.Label.column.value");
    private static final String COLUMN_DISPLAY_TEXT = Messages.getString((String)"CascadingParametersDialog.Label.column.displayText");
    private static final String PARAM_CONTROL_LIST = "list-box/List";
    private static final String PARAM_CONTROL_COMBO = "list-box/Combo";
    private static final String DISPLAY_NAME_CONTROL_LIST = Messages.getString((String)"CascadingParametersDialog.display.controlType.listBox");
    private static final String DISPLAY_NAME_CONTROL_COMBO = Messages.getString((String)"CascadingParametersDialog.display.controlType.comboBox");
    private static final double DEFAULT_PREVIEW_NUMBER = Double.parseDouble("1234.56");
    private static final String DEFAULT_PREVIEW_STRING = Messages.getString((String)"CascadingParametersDialog.default.preview.string");
    private static final String ERROR_TITLE_INVALID_LIST_LIMIT = Messages.getString((String)"ParameterDialog.ErrorTitle.InvalidListLimit");
    private static final String ERROR_MSG_INVALID_LIST_LIMIT = Messages.getString((String)"ParameterDialog.ErrorMessage.InvalidListLimit");
    private Group optionsGroup;
    private Group propertiesGroup;
    private Text cascadingNameEditor;
    private Text promptTextEditor;
    private Text paramNameEditor;
    private Text helpTextEditor;
    private Text defaultValueEditor;
    private Text formatField;
    private Text listLimit;
    private Text promptText;
    private Combo dataTypeChooser;
    private Combo displayTypeChooser;
    private Button changeFormat;
    private Button singleDataSet;
    private Button multiDataSet;
    private Label previewLable;
    private Table table;
    private TableViewer valueTable;
    private CellEditor[] cellEditors;
    private static IChoiceSet dataType = DesignEngine.getMetaDataDictionary().getChoiceSet("paramType");
    private CascadingParameterGroupHandle inputParameterGroup;
    private ScalarParameterHandle selectedParameter;
    protected ScalarParameterHandle newParameter = null;
    private String defaultValue;
    private String formatPattern;
    private String formatCategroy;
    private boolean loading = true;
    private Button allowNull;
    private int maxStrLengthProperty;
    private int maxStrLengthOption;
    private String[] PROPERTY_LABEL_STRING = new String[]{LABEL_PARAM_NAME, LABEL_GROUP_PROMPT_TEXT, LABEL_PARAMTER_PROMPT_TEXT, LABEL_DATA_TYPE, LABEL_DISPLAY_TYPE, LABEL_DEFAULT_VALUE};
    private String[] OPTION_LABEL_STRING = new String[]{LABEL_HELP_TEXT, LABEL_FORMAT_AS, LABEL_LIST_LIMIT};
    private IStructuredContentProvider contentProvider = new IStructuredContentProvider(){

        public Object[] getElements(Object inputElement) {
            ArrayList<ScalarParameterHandle> elementsList = new ArrayList<ScalarParameterHandle>(CascadingParametersDialog.this.inputParameterGroup.getParameters().getContents());
            Iterator iter = elementsList.iterator();
            while (iter.hasNext()) {
                ScalarParameterHandle handle = (ScalarParameterHandle)iter.next();
                String[] columns = CascadingParametersDialog.this.getDataSetColumns(handle, false);
                boolean found = false;
                for (int i = 0; i < columns.length; ++i) {
                    if (!DEUtil.getColumnExpression((String)columns[i]).equals(handle.getValueExpr())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                try {
                    handle.setValueExpr(null);
                }
                catch (SemanticException e) {
                    ExceptionHandler.handle(e);
                }
            }
            if (CascadingParametersDialog.this.newParameter == null) {
                CascadingParametersDialog.this.newParameter = DesignElementFactory.getInstance().newScalarParameter(null);
                try {
                    CascadingParametersDialog.this.newParameter.setControlType("list-box");
                    CascadingParametersDialog.this.newParameter.setValueType("dynamic");
                }
                catch (SemanticException e) {
                    ExceptionHandler.handle(e);
                }
            }
            elementsList.add(CascadingParametersDialog.this.newParameter);
            return elementsList.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    };
    private ITableLabelProvider labelProvider = new ITableLabelProvider(){

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String value = null;
            ScalarParameterHandle paramHandle = null;
            if (element instanceof ScalarParameterHandle) {
                paramHandle = (ScalarParameterHandle)element;
            }
            if (paramHandle == CascadingParametersDialog.this.newParameter) {
                if (columnIndex == 0) {
                    value = LABEL_CREATE_NEW_PARAMETER;
                } else if (columnIndex == 1) {
                    if (!CascadingParametersDialog.this.isSingle() || paramHandle == CascadingParametersDialog.this.getFirstParameter()) {
                        value = LABEL_SELECT_DATA_SET;
                    }
                } else if (columnIndex == 2 && CascadingParametersDialog.this.isSingle() && paramHandle != CascadingParametersDialog.this.getFirstParameter()) {
                    value = LABEL_SELECT_VALUE_COLUMN;
                }
            } else {
                switch (columnIndex) {
                    case 0: {
                        if (paramHandle == CascadingParametersDialog.this.newParameter) break;
                        String paramName = paramHandle != CascadingParametersDialog.this.selectedParameter ? paramHandle.getName() : CascadingParametersDialog.this.paramNameEditor.getText().trim();
                        value = this.getDummyText(paramHandle) + paramName;
                        break;
                    }
                    case 1: {
                        DataSetHandle dataSet = null;
                        if (CascadingParametersDialog.this.isSingle()) {
                            if (paramHandle != CascadingParametersDialog.this.getFirstParameter()) break;
                            dataSet = CascadingParametersDialog.this.inputParameterGroup.getDataSet();
                        } else {
                            dataSet = CascadingParametersDialog.this.getDataSet(paramHandle);
                        }
                        if (dataSet == null) {
                            value = LABEL_SELECT_DATA_SET;
                            break;
                        }
                        value = dataSet.getName();
                        break;
                    }
                    case 2: {
                        if (paramHandle.getValueExpr() != null) {
                            value = CascadingParametersDialog.this.getColumnName(paramHandle, COLUMN_VALUE);
                            break;
                        }
                        if (CascadingParametersDialog.this.getDataSetColumns(paramHandle, true).length > 0) {
                            value = LABEL_SELECT_VALUE_COLUMN;
                            break;
                        }
                        value = LABEL_NO_COLUMN_AVAILABLE;
                        break;
                    }
                    case 3: {
                        value = CascadingParametersDialog.this.getColumnName(paramHandle, COLUMN_DISPLAY_TEXT);
                        if (value != null) break;
                        value = CascadingParametersDialog.this.getDataSetColumns(paramHandle, false).length > 0 ? LABEL_SELECT_DISPLAY_COLUMN : LABEL_NO_COLUMN_AVAILABLE;
                    }
                }
            }
            if (value == null) {
                value = "";
            }
            return value;
        }

        private String getDummyText(Object element) {
            String dummyText = "";
            int index = CascadingParametersDialog.this.getTableIndex(element);
            for (int i = 0; i < index; ++i) {
                dummyText = dummyText + "    ";
            }
            return dummyText;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    };
    private ICellModifier cellModifier = new ICellModifier(){

        public boolean canModify(Object element, String property) {
            if (element != CascadingParametersDialog.this.selectedParameter || property.equals(COLUMN_NAME)) {
                return false;
            }
            if (COLUMN_DATA_SET.equals(property) && CascadingParametersDialog.this.isSingle() && CascadingParametersDialog.this.getFirstParameter() != element) {
                return false;
            }
            if (element == CascadingParametersDialog.this.newParameter && (CascadingParametersDialog.this.isSingle() ? (element == CascadingParametersDialog.this.getFirstParameter() ? !COLUMN_DATA_SET.equals(property) : !COLUMN_VALUE.equals(property)) : !COLUMN_DATA_SET.equals(property))) {
                return false;
            }
            if (COLUMN_VALUE.equals(property) && CascadingParametersDialog.this.getDataSetColumns((ScalarParameterHandle)element, true).length == 0) {
                return false;
            }
            CascadingParametersDialog.this.setCellEditorItems();
            return true;
        }

        public Object getValue(Object element, String property) {
            if (element instanceof ScalarParameterHandle) {
                ScalarParameterHandle parameter = (ScalarParameterHandle)element;
                String value = null;
                if (COLUMN_NAME.equals(property)) {
                    value = element == CascadingParametersDialog.this.newParameter ? "" : parameter.getName();
                } else if (COLUMN_DATA_SET.equals(property)) {
                    if (CascadingParametersDialog.this.isSingle() && CascadingParametersDialog.this.inputParameterGroup.getDataSet() != null) {
                        value = CascadingParametersDialog.this.inputParameterGroup.getDataSet().getName();
                    } else if (CascadingParametersDialog.this.getDataSet(parameter) != null) {
                        value = CascadingParametersDialog.this.getDataSet(parameter).getName();
                    }
                } else if (COLUMN_VALUE.equals(property)) {
                    value = CascadingParametersDialog.this.getColumnName(parameter, COLUMN_VALUE);
                } else if (COLUMN_DISPLAY_TEXT.equals(property)) {
                    value = CascadingParametersDialog.this.getColumnName(parameter, COLUMN_DISPLAY_TEXT);
                }
                if (value == null) {
                    value = "";
                }
                return value;
            }
            return "";
        }

        public void modify(Object element, String property, Object value) {
            Object actualElement;
            block22: {
                actualElement = ((TableItem)element).getData();
                try {
                    CascadingParametersDialog.this.saveParameterProperties();
                }
                catch (SemanticException e1) {
                    e1.printStackTrace();
                }
                if (COLUMN_NAME.equals(property)) {
                    try {
                        if (actualElement == CascadingParametersDialog.this.newParameter) {
                            ((ScalarParameterHandle)actualElement).setName(CascadingParametersDialog.this.newParameter.getName());
                        } else {
                            ((ScalarParameterHandle)actualElement).setName((String)value);
                        }
                    }
                    catch (NameException e) {
                        ExceptionHandler.handle(e);
                    }
                }
                if (COLUMN_DATA_SET.equals(property)) {
                    try {
                        if (CascadingParametersDialog.this.isSingle()) {
                            CascadingParametersDialog.this.inputParameterGroup.setDataSet(CascadingParametersDialog.this.getDataSet((String)value));
                            break block22;
                        }
                        ((ScalarParameterHandle)actualElement).setDataSetName((String)value);
                    }
                    catch (SemanticException e) {
                        ExceptionHandler.handle(e);
                    }
                } else if (COLUMN_VALUE.equals(property)) {
                    try {
                        ((ScalarParameterHandle)actualElement).setValueExpr(DEUtil.getColumnExpression((String)((String)value)));
                    }
                    catch (SemanticException e) {
                        ExceptionHandler.handle(e);
                    }
                } else if (COLUMN_DISPLAY_TEXT.equals(property)) {
                    try {
                        ((ScalarParameterHandle)actualElement).setLabelExpr(DEUtil.getColumnExpression((String)((String)value)));
                    }
                    catch (SemanticException e) {
                        ExceptionHandler.handle(e);
                    }
                }
            }
            if (actualElement == CascadingParametersDialog.this.newParameter && (CascadingParametersDialog.this.isSingle() || CascadingParametersDialog.this.newParameter.getDataSetName() != null)) {
                try {
                    CascadingParametersDialog.this.inputParameterGroup.getParameters().add((DesignElementHandle)CascadingParametersDialog.this.newParameter);
                }
                catch (SemanticException e) {
                    ExceptionHandler.handle(e);
                    return;
                }
                CascadingParametersDialog.this.clearNewParameter();
            }
            CascadingParametersDialog.this.refreshValueTable();
            CascadingParametersDialog.this.refreshParameterProperties();
            CascadingParametersDialog.this.updateButtons();
        }
    };

    protected int getMaxStrLength(String[] string, Control control) {
        int len = UIUtil.getMaxStringWidth(string, control);
        return len;
    }

    public CascadingParametersDialog(Shell parentShell, String title) {
        super(parentShell, title);
    }

    public CascadingParametersDialog(String title) {
        super(title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.CascadingParametersDialog_ID");
        GridData data = new GridData();
        data.widthHint = 600;
        this.maxStrLengthProperty = this.getMaxStrLength(this.PROPERTY_LABEL_STRING, (Control)composite);
        this.maxStrLengthOption = this.getMaxStrLength(this.OPTION_LABEL_STRING, (Control)composite);
        composite.setLayoutData((Object)data);
        this.createGeneralPart(composite);
        this.createChoicePart(composite);
        this.createDynamicParamsPart(composite);
        this.createPropertiesPart(composite);
        this.createOptionsPart(composite);
        return composite;
    }

    private void createGeneralPart(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(LABEL_GROUP_GENERAL);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(768));
        new Label((Composite)group, 0).setText(LABEL_CASCADING_PARAMETER_NAME);
        this.cascadingNameEditor = new Text((Composite)group, 2048);
        this.cascadingNameEditor.setLayoutData((Object)new GridData(768));
        new Label((Composite)group, 0).setText(LABEL_GROUP_PROMPT_TEXT);
        this.promptTextEditor = new Text((Composite)group, 2048);
        this.promptTextEditor.setLayoutData((Object)new GridData(768));
    }

    private void createChoicePart(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        composite.setLayout((Layout)new GridLayout(3, true));
        new Label(composite, 0).setText(LABEL_SELECT_DATA_SET_MODE);
        this.singleDataSet = new Button(composite, 16);
        this.singleDataSet.setText(RADIO_SINGLE);
        this.singleDataSet.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CascadingParametersDialog.this.refreshValueTable();
                CascadingParametersDialog.this.updateButtons();
            }
        });
        this.multiDataSet = new Button(composite, 16);
        this.multiDataSet.setText(RADIO_MULTIPLE);
        this.multiDataSet.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CascadingParametersDialog.this.refreshValueTable();
                CascadingParametersDialog.this.updateButtons();
            }
        });
    }

    private void createDynamicParamsPart(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin());
        comp.setLayoutData((Object)new GridData(768));
        Label label = new Label(comp, 0);
        label.setText(LABEL_PARAMETERS);
        this.table = new Table(comp, 100352);
        GridData data = new GridData(768);
        data.heightHint = 100;
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    CascadingParametersDialog.this.deleteRow();
                }
            }
        });
        int[] columnWidths = new int[]{160, 115, 135, 145};
        String[] columns = new String[]{COLUMN_NAME, COLUMN_DATA_SET, COLUMN_VALUE, COLUMN_DISPLAY_TEXT};
        this.cellEditors = new CellEditor[]{new TextCellEditor((Composite)this.table), new ComboBoxCellEditor((Composite)this.table, ChoiceSetFactory.getDataSets(), 8), new ComboBoxCellEditor((Composite)this.table, new String[0], 8), new ComboBoxCellEditor((Composite)this.table, new String[0], 8)};
        for (int i = 0; i < columns.length; ++i) {
            TableColumn column = new TableColumn(this.table, 16384);
            column.setResizable(true);
            column.setText(columns[i]);
            column.setWidth(columnWidths[i]);
        }
        this.table.setLayoutData((Object)data);
        this.valueTable = new TableViewer(this.table);
        this.valueTable.setCellEditors(this.cellEditors);
        this.valueTable.setColumnProperties(columns);
        this.valueTable.setContentProvider((IContentProvider)this.contentProvider);
        this.valueTable.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.valueTable.setCellModifier(this.cellModifier);
        this.valueTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                Object param = ((StructuredSelection)selection).getFirstElement();
                if (param != CascadingParametersDialog.this.selectedParameter && param instanceof ScalarParameterHandle) {
                    try {
                        CascadingParametersDialog.this.saveParameterProperties();
                        CascadingParametersDialog.this.selectedParameter = (ScalarParameterHandle)param;
                    }
                    catch (SemanticException e) {
                        ExceptionHandler.handle(e);
                        CascadingParametersDialog.this.valueTable.setSelection((ISelection)new StructuredSelection((Object)CascadingParametersDialog.this.selectedParameter));
                    }
                    CascadingParametersDialog.this.refreshParameterProperties();
                    CascadingParametersDialog.this.updateButtons();
                }
            }
        });
    }

    private void createPropertiesPart(Composite parent) {
        this.propertiesGroup = new Group(parent, 0);
        this.propertiesGroup.setText(LABEL_GROUP_PROPERTIES);
        this.propertiesGroup.setLayout((Layout)new GridLayout(2, false));
        this.propertiesGroup.setLayoutData((Object)new GridData(768));
        this.createLabel((Composite)this.propertiesGroup, LABEL_PARAM_NAME, this.maxStrLengthProperty);
        this.paramNameEditor = new Text((Composite)this.propertiesGroup, 2048);
        this.paramNameEditor.setLayoutData((Object)new GridData(768));
        this.paramNameEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CascadingParametersDialog.this.valueTable.refresh((Object)CascadingParametersDialog.this.selectedParameter);
            }
        });
        this.createLabel((Composite)this.propertiesGroup, LABEL_PARAMTER_PROMPT_TEXT, this.maxStrLengthProperty);
        this.promptText = new Text((Composite)this.propertiesGroup, 2048);
        this.promptText.setLayoutData((Object)new GridData(768));
        this.createLabel((Composite)this.propertiesGroup, LABEL_DATA_TYPE, this.maxStrLengthProperty);
        this.dataTypeChooser = new Combo((Composite)this.propertiesGroup, 12);
        this.dataTypeChooser.setLayoutData((Object)new GridData(768));
        this.dataTypeChooser.setItems(ChoiceSetFactory.getDisplayNamefromChoiceSet(dataType));
        this.dataTypeChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CascadingParametersDialog.this.selectedParameter != null && CascadingParametersDialog.this.selectedParameter != CascadingParametersDialog.this.newParameter) {
                    CascadingParametersDialog.this.changeDataType(dataType.findChoiceByDisplayName(CascadingParametersDialog.this.dataTypeChooser.getText()).getName());
                    try {
                        CascadingParametersDialog.this.selectedParameter.setDataType(dataType.findChoiceByDisplayName(CascadingParametersDialog.this.dataTypeChooser.getText()).getName());
                    }
                    catch (SemanticException e1) {
                        ExceptionHandler.handle(e1);
                    }
                }
            }
        });
        this.createLabel((Composite)this.propertiesGroup, LABEL_DISPLAY_TYPE, this.maxStrLengthProperty);
        this.displayTypeChooser = new Combo((Composite)this.propertiesGroup, 12);
        this.displayTypeChooser.setLayoutData((Object)new GridData(768));
        this.displayTypeChooser.setItems(new String[]{DISPLAY_NAME_CONTROL_LIST, DISPLAY_NAME_CONTROL_COMBO});
        this.displayTypeChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CascadingParametersDialog.this.selectedParameter != null && CascadingParametersDialog.this.selectedParameter != CascadingParametersDialog.this.newParameter) {
                    try {
                        String newControlType = CascadingParametersDialog.this.getSelectedDisplayType();
                        if (CascadingParametersDialog.PARAM_CONTROL_COMBO.equals(newControlType)) {
                            newControlType = "list-box";
                            CascadingParametersDialog.this.selectedParameter.setMustMatch(true);
                        } else if (CascadingParametersDialog.PARAM_CONTROL_LIST.equals(newControlType)) {
                            newControlType = "list-box";
                            CascadingParametersDialog.this.selectedParameter.setMustMatch(false);
                        } else {
                            CascadingParametersDialog.this.selectedParameter.setProperty("mustMatch", null);
                        }
                        CascadingParametersDialog.this.selectedParameter.setControlType(newControlType);
                    }
                    catch (SemanticException e1) {
                        ExceptionHandler.handle(e1);
                    }
                }
            }
        });
        this.createLabel((Composite)this.propertiesGroup, LABEL_DEFAULT_VALUE, this.maxStrLengthProperty);
        this.defaultValueEditor = new Text((Composite)this.propertiesGroup, 2048);
        this.defaultValueEditor.setLayoutData((Object)new GridData(768));
    }

    private void createOptionsPart(Composite parent) {
        this.optionsGroup = new Group(parent, 0);
        this.optionsGroup.setText(LABEL_GROUP_MORE_OPTIONS);
        this.optionsGroup.setLayout((Layout)new GridLayout(2, false));
        this.optionsGroup.setLayoutData((Object)new GridData(768));
        this.createLabel((Composite)this.optionsGroup, LABEL_HELP_TEXT, this.maxStrLengthOption);
        this.helpTextEditor = new Text((Composite)this.optionsGroup, 2048);
        this.helpTextEditor.setLayoutData((Object)new GridData(768));
        Label lable = new Label((Composite)this.optionsGroup, 0);
        lable.setText(LABEL_FORMAT_AS);
        lable.setLayoutData((Object)new GridData(32));
        Composite formatArea = new Composite((Composite)this.optionsGroup, 0);
        formatArea.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(2, false));
        formatArea.setLayoutData((Object)new GridData(768));
        this.formatField = new Text(formatArea, 2060);
        this.formatField.setLayoutData((Object)new GridData(768));
        this.changeFormat = new Button(formatArea, 8);
        this.changeFormat.setText(LABEL_CHANGE_FORMAT_BUTTON);
        this.setButtonLayoutData(this.changeFormat);
        this.changeFormat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CascadingParametersDialog.this.popupFormatBuilder(true);
            }
        });
        Group preview = new Group(formatArea, 0);
        preview.setText(LABEL_PREVIEW_WITH_FORMAT);
        preview.setLayoutData((Object)new GridData(768));
        preview.setLayout((Layout)new GridLayout());
        this.previewLable = new Label((Composite)preview, 0x11000100);
        this.previewLable.setText("");
        this.previewLable.setLayoutData((Object)new GridData(768));
        this.createLabel((Composite)this.optionsGroup, LABEL_LIST_LIMIT, this.maxStrLengthOption);
        Composite composite = new Composite((Composite)this.optionsGroup, 0);
        composite.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(2, true));
        composite.setLayoutData((Object)new GridData(768));
        Composite limitArea = new Composite(composite, 0);
        limitArea.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(2, true));
        limitArea.setLayoutData((Object)new GridData(768));
        this.listLimit = new Text(limitArea, 2048);
        GridData gridData = new GridData();
        gridData.widthHint = 80;
        this.listLimit.setLayoutData((Object)gridData);
        this.listLimit.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = "0123456789\u0000\b\u007f".indexOf(e.character) != -1;
            }
        });
        this.listLimit.addModifyListener(new ModifyListener(){
            private String oldValue = "";

            public void modifyText(ModifyEvent e) {
                try {
                    if (!StringUtil.isBlank((String)CascadingParametersDialog.this.listLimit.getText())) {
                        Integer.parseInt(CascadingParametersDialog.this.listLimit.getText());
                        this.oldValue = CascadingParametersDialog.this.listLimit.getText();
                    }
                }
                catch (NumberFormatException e1) {
                    ExceptionHandler.openErrorMessageBox(ERROR_TITLE_INVALID_LIST_LIMIT, MessageFormat.format(ERROR_MSG_INVALID_LIST_LIMIT, Integer.toString(Integer.MAX_VALUE)));
                    CascadingParametersDialog.this.listLimit.setText(this.oldValue);
                }
            }
        });
        new Label(limitArea, 0).setText(LABEL_VALUES);
        this.allowNull = new Button(composite, 32);
        this.allowNull.setText(BUTTON_ALLOW_NULL_VALUE);
        this.allowNull.setLayoutData((Object)new GridData(768));
        this.allowNull.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CascadingParametersDialog.this.selectedParameter != null && CascadingParametersDialog.this.selectedParameter != CascadingParametersDialog.this.newParameter) {
                    try {
                        CascadingParametersDialog.this.selectedParameter.setAllowNull(CascadingParametersDialog.this.allowNull.getSelection());
                    }
                    catch (SemanticException e1) {
                        ExceptionHandler.handle(e1);
                    }
                }
            }
        });
    }

    private void createLabel(Composite parent, String content, int width) {
        Label label = new Label(parent, 0);
        this.setLabelLayoutData((Control)label, width);
        if (content != null) {
            label.setText(content);
        }
    }

    private void setLabelLayoutData(Control control, int width) {
        GridData gd = new GridData(2);
        gd.widthHint = width;
        control.setLayoutData((Object)gd);
    }

    public void setInput(Object input) {
        Assert.isNotNull((Object)input);
        Assert.isLegal((boolean)(input instanceof CascadingParameterGroupHandle));
        this.inputParameterGroup = (CascadingParameterGroupHandle)input;
    }

    protected boolean initDialog() {
        this.cascadingNameEditor.setText(this.inputParameterGroup.getName());
        this.promptTextEditor.setText(UIUtil.convertToGUIString(this.inputParameterGroup.getPromptText()));
        if ("multiple".equals(this.inputParameterGroup.getDataSetMode())) {
            this.multiDataSet.setSelection(true);
        } else {
            this.singleDataSet.setSelection(true);
        }
        this.valueTable.setInput((Object)this.inputParameterGroup);
        this.refreshParameterProperties();
        this.updateButtons();
        return true;
    }

    protected void okPressed() {
        try {
            this.saveParameterProperties();
            this.inputParameterGroup.setName(UIUtil.convertToModelString(this.cascadingNameEditor.getText(), true));
            this.inputParameterGroup.setPromptText(this.promptTextEditor.getText());
            if (this.isSingle()) {
                this.inputParameterGroup.setDataSetMode("single");
            } else {
                this.inputParameterGroup.setDataSetMode("multiple");
            }
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
            this.refreshParameterProperties();
            return;
        }
        this.setResult(this.inputParameterGroup);
        super.okPressed();
    }

    private void deleteRow() {
        int index = this.valueTable.getTable().getSelectionIndex();
        ScalarParameterHandle choice = (ScalarParameterHandle)((IStructuredSelection)this.valueTable.getSelection()).getFirstElement();
        if (choice == null) {
            return;
        }
        try {
            this.inputParameterGroup.getParameters().drop((DesignElementHandle)choice);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
            return;
        }
        this.refreshValueTable();
        if (--index < 0 && this.valueTable.getTable().getItemCount() > 1) {
            index = 0;
        }
        StructuredSelection selection = null;
        selection = index != -1 ? new StructuredSelection(this.valueTable.getTable().getItem(index).getData()) : StructuredSelection.EMPTY;
        this.valueTable.setSelection((ISelection)selection);
    }

    private String[] getDataSetColumns(ScalarParameterHandle handle, boolean needFilter) {
        DataSetHandle dataSet = this.getDataSet(handle);
        if (dataSet == null) {
            return new String[0];
        }
        CachedMetaDataHandle metaHandle = dataSet.getCachedMetaDataHandle();
        if (metaHandle == null) {
            try {
                metaHandle = DataSetUIUtil.getCachedMetaDataHandle(dataSet);
            }
            catch (SemanticException e) {
                ExceptionHandler.handle(e);
                return new String[0];
            }
        }
        if (metaHandle == null || metaHandle.getResultSet() == null) {
            return new String[0];
        }
        ArrayList<String> valueList = new ArrayList<String>();
        Iterator iter = metaHandle.getResultSet().iterator();
        while (iter.hasNext()) {
            ResultSetColumnHandle columnHandle = (ResultSetColumnHandle)iter.next();
            if (needFilter && !this.matchDataType(handle, columnHandle)) continue;
            valueList.add(columnHandle.getColumnName());
        }
        return valueList.toArray(new String[0]);
    }

    private DataSetHandle getDataSet(ScalarParameterHandle handle) {
        if (!this.isSingle()) {
            if (handle.getDataSetName() != null) {
                return this.getDataSet(handle.getDataSetName());
            }
            return null;
        }
        return this.inputParameterGroup.getDataSet();
    }

    private DataSetHandle getDataSet(String name) {
        return this.inputParameterGroup.getModuleHandle().findDataSet(name);
    }

    private void setCellEditorItems() {
        ((ComboBoxCellEditor)this.cellEditors[2]).setItems(this.getDataSetColumns(this.selectedParameter, true));
        ((ComboBoxCellEditor)this.cellEditors[3]).setItems(this.getDataSetColumns(this.selectedParameter, false));
    }

    private void clearNewParameter() {
        this.newParameter = null;
    }

    protected int getTableIndex(Object element) {
        Object[] input = ((IStructuredContentProvider)this.valueTable.getContentProvider()).getElements(this.valueTable.getInput());
        int index = 0;
        if (element != this.newParameter) {
            for (int i = 0; i < input.length; ++i) {
                if (element != input[i]) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    private void refreshValueTable() {
        if (this.valueTable != null && !this.valueTable.getTable().isDisposed()) {
            this.valueTable.refresh();
        }
    }

    private void refreshParameterProperties() {
        if (this.selectedParameter == null || this.selectedParameter == this.newParameter) {
            this.clearParamProperties();
            this.setControlEnabled(false);
            return;
        }
        this.loading = true;
        this.setControlEnabled(true);
        this.paramNameEditor.setText(this.selectedParameter.getName());
        if (this.selectedParameter.getPromptText() == null) {
            this.promptText.setText("");
        } else {
            this.promptText.setText(this.selectedParameter.getPromptText());
        }
        this.dataTypeChooser.setText(dataType.findChoice(this.selectedParameter.getDataType()).getDisplayName());
        if (this.getInputDisplayName() == null) {
            this.displayTypeChooser.clearSelection();
        } else {
            this.displayTypeChooser.setText(this.getInputDisplayName());
        }
        this.defaultValue = this.selectedParameter.getDefaultValue();
        if (this.defaultValue == null) {
            this.defaultValueEditor.setText("");
        } else {
            this.defaultValueEditor.setText(this.defaultValue);
        }
        this.helpTextEditor.setText(UIUtil.convertToGUIString(this.selectedParameter.getHelpText()));
        if (this.selectedParameter.getPropertyHandle("listLimit").isSet()) {
            this.listLimit.setText(String.valueOf(this.selectedParameter.getListlimit()));
        } else {
            this.listLimit.setText("");
        }
        this.allowNull.setSelection(this.selectedParameter.allowNull());
        this.changeDataType(this.selectedParameter.getDataType());
        this.loading = false;
    }

    private void clearParamProperties() {
        this.paramNameEditor.setText("");
        this.promptText.setText("");
        this.dataTypeChooser.select(-1);
        this.displayTypeChooser.select(-1);
        this.defaultValueEditor.setText("");
        this.helpTextEditor.setText("");
        this.formatField.setText("");
        this.listLimit.setText("");
        this.previewLable.setText("");
        this.allowNull.setSelection(false);
    }

    private void setControlEnabled(boolean enable) {
        this.paramNameEditor.setEnabled(enable);
        this.promptText.setEnabled(enable);
        this.dataTypeChooser.setEnabled(enable);
        this.displayTypeChooser.setEnabled(enable);
        this.defaultValueEditor.setEnabled(enable);
        this.helpTextEditor.setEnabled(enable);
        this.formatField.setEnabled(enable);
        this.listLimit.setEnabled(enable);
        this.changeFormat.setEnabled(enable);
    }

    private void changeDataType(String type) {
        this.initFormatField(type);
        this.refreshValueTable();
        this.updateButtons();
    }

    private void initFormatField(String selectedDataType) {
        IChoiceSet choiceSet = this.getFormatChoiceSet(selectedDataType);
        if (choiceSet == null) {
            this.formatPattern = null;
            this.formatCategroy = null;
        } else if (!this.loading || this.selectedParameter.getCategory() == null && this.selectedParameter.getPattern() == null) {
            if ("string".equals(selectedDataType)) {
                this.formatCategroy = choiceSet.findChoice("Unformatted").getName();
            } else if ("dateTime".equals(selectedDataType)) {
                this.formatCategroy = choiceSet.findChoice("Unformatted").getName();
            } else if ("decimal".equals(selectedDataType) || "float".equals(selectedDataType)) {
                this.formatCategroy = choiceSet.findChoice("Unformatted").getName();
            }
            this.formatPattern = null;
        } else {
            this.formatCategroy = this.selectedParameter.getCategory();
            if (this.formatCategroy == null) {
                this.formatCategroy = "Unformatted";
            }
            this.formatPattern = this.selectedParameter.getPattern();
        }
        this.updateFormatField();
    }

    private String getInputDisplayName() {
        String displayName = null;
        if ("list-box".equals(this.selectedParameter.getControlType())) {
            displayName = this.selectedParameter.isMustMatch() ? DISPLAY_NAME_CONTROL_COMBO : DISPLAY_NAME_CONTROL_LIST;
        }
        return displayName;
    }

    private IChoiceSet getFormatChoiceSet(String type) {
        IChoiceSet choiceSet = null;
        if ("string".equals(type)) {
            choiceSet = DesignEngine.getMetaDataDictionary().getChoiceSet("stringFormat");
        } else if ("dateTime".equals(type)) {
            choiceSet = DesignEngine.getMetaDataDictionary().getChoiceSet("dateTimeFormat");
        } else if ("decimal".equals(type) || "float".equals(type)) {
            choiceSet = DesignEngine.getMetaDataDictionary().getChoiceSet("numberFormat");
        }
        return choiceSet;
    }

    private String getSelectedDataType() {
        String type = null;
        if (StringUtil.isBlank((String)this.dataTypeChooser.getText())) {
            type = this.selectedParameter != null ? this.selectedParameter.getDataType() : "string";
        } else {
            IChoice choice = dataType.findChoiceByDisplayName(this.dataTypeChooser.getText());
            type = choice.getName();
        }
        return type;
    }

    private String getSelectedDisplayType() {
        String displayText = this.displayTypeChooser.getText();
        if (displayText.length() == 0) {
            return null;
        }
        if (DISPLAY_NAME_CONTROL_COMBO.equals(displayText)) {
            return PARAM_CONTROL_COMBO;
        }
        if (DISPLAY_NAME_CONTROL_LIST.equals(displayText)) {
            return PARAM_CONTROL_LIST;
        }
        return null;
    }

    private void popupFormatBuilder(boolean refresh) {
        String type = this.getSelectedDataType();
        if ("boolean".equals(type)) {
            return;
        }
        int style = "string".equals(type) ? 1 : ("dateTime".equals(type) ? 3 : 2);
        FormatBuilder formatBuilder = new FormatBuilder(style);
        formatBuilder.setInputFormat(this.formatCategroy, this.formatPattern);
        if (formatBuilder.open() == 0) {
            this.formatCategroy = ((String[])formatBuilder.getResult())[0];
            this.formatPattern = ((String[])formatBuilder.getResult())[1];
            this.updateFormatField();
        }
    }

    private void updateFormatField() {
        String displayFormat;
        IChoiceSet choiceSet = this.getFormatChoiceSet(this.getSelectedDataType());
        if (choiceSet == null) {
            displayFormat = DesignEngine.getMetaDataDictionary().getChoiceSet("stringFormat").findChoice("Unformatted").getDisplayName();
        } else {
            displayFormat = choiceSet.findChoice(this.formatCategroy).getDisplayName();
            if (this.formatCategroy != "Custom") {
                displayFormat = displayFormat + ":  " + this.formatPattern;
            }
        }
        this.formatField.setText("" + displayFormat);
        this.changeFormat.setEnabled(choiceSet != null);
        if (this.selectedParameter != null) {
            this.doPreview(this.formatCategroy != "Custom" ? this.formatCategroy : this.formatPattern);
        }
    }

    private void doPreview(String pattern) {
        String type = this.getSelectedDataType();
        String formatStr = "";
        if ("string".equals(type)) {
            formatStr = new StringFormatter(pattern, ULocale.getDefault()).format(DEFAULT_PREVIEW_STRING);
        } else if ("dateTime".equals(type)) {
            formatStr = new DateFormatter(pattern).format(new Date());
        } else if ("decimal".equals(type) || "float".equals(type)) {
            formatStr = new NumberFormatter(pattern).format(DEFAULT_PREVIEW_NUMBER);
        }
        this.previewLable.setText(formatStr);
    }

    private String getCategroy(String formatString) {
        if (formatString != null) {
            return formatString.split(":")[0];
        }
        return null;
    }

    private String getPattern(String formatString) {
        if (formatString != null) {
            int index = formatString.indexOf(58);
            if (index == -1) {
                return null;
            }
            return formatString.substring(index + 1);
        }
        return null;
    }

    private String getColumnName(ScalarParameterHandle handle, String column) {
        CachedMetaDataHandle cmdh = null;
        try {
            DataSetHandle dataSet = this.getDataSet(handle);
            if (dataSet == null) {
                return null;
            }
            cmdh = DataSetUIUtil.getCachedMetaDataHandle(dataSet);
        }
        catch (SemanticException e) {
            // empty catch block
        }
        String value = null;
        value = COLUMN_VALUE.equals(column) ? handle.getValueExpr() : handle.getLabelExpr();
        if (cmdh != null) {
            Iterator iter = cmdh.getResultSet().iterator();
            while (iter.hasNext()) {
                ResultSetColumnHandle element = (ResultSetColumnHandle)iter.next();
                if (!DEUtil.getColumnExpression((String)element.getColumnName()).equalsIgnoreCase(value)) continue;
                return element.getColumnName();
            }
        }
        return null;
    }

    private void updateButtons() {
        boolean okEnable = true;
        Iterator iter = this.inputParameterGroup.getParameters().iterator();
        if (!iter.hasNext()) {
            okEnable = false;
        } else {
            int count = 0;
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof ScalarParameterHandle)) continue;
                ScalarParameterHandle param = (ScalarParameterHandle)obj;
                ++count;
                if (this.checkParameter(param)) continue;
                okEnable = false;
                break;
            }
            okEnable &= count != 0;
        }
        this.getOkButton().setEnabled(okEnable);
    }

    private boolean matchDataType(ScalarParameterHandle handle, ResultSetColumnHandle columnHandle) {
        String type = handle.getDataType();
        if (handle == this.selectedParameter) {
            type = this.getSelectedDataType();
        }
        if ("string".equals(type) || "any".equals(columnHandle.getDataType())) {
            return true;
        }
        if ("boolean".equals(type)) {
            return "any".equals(columnHandle.getDataType());
        }
        if ("dateTime".equals(type)) {
            return "date-time".equals(columnHandle.getDataType());
        }
        if ("decimal".equals(type)) {
            return "decimal".equals(columnHandle.getDataType());
        }
        if ("float".equals(type)) {
            return "float".equals(columnHandle.getDataType());
        }
        return false;
    }

    private void saveParameterProperties() throws SemanticException {
        if (this.selectedParameter != null && this.selectedParameter != this.newParameter) {
            this.selectedParameter.setPromptText(UIUtil.convertToModelString(this.promptText.getText(), false));
            this.selectedParameter.setHelpText(UIUtil.convertToModelString(this.helpTextEditor.getText(), true));
            this.selectedParameter.setDefaultValue(UIUtil.convertToModelString(this.defaultValueEditor.getText(), true));
            if (StringUtil.isBlank((String)this.listLimit.getText())) {
                this.selectedParameter.setProperty("listLimit", null);
            } else {
                this.selectedParameter.setListlimit(Integer.parseInt(this.listLimit.getText()));
            }
            this.selectedParameter.setAllowNull(this.allowNull.getSelection());
            this.selectedParameter.setName(UIUtil.convertToModelString(this.paramNameEditor.getText(), true));
            this.selectedParameter.setCategory(this.formatCategroy);
            this.selectedParameter.setPattern(this.formatPattern);
            this.refreshValueTable();
        }
    }

    private boolean isSingle() {
        return this.singleDataSet.getSelection();
    }

    private ScalarParameterHandle getFirstParameter() {
        if (this.inputParameterGroup.getParameters().getCount() > 0) {
            return (ScalarParameterHandle)this.inputParameterGroup.getParameters().get(0);
        }
        return this.newParameter;
    }

    private boolean checkParameter(ScalarParameterHandle paramHandle) {
        return paramHandle.getValueExpr() != null && this.getColumnName(paramHandle, COLUMN_VALUE) != null;
    }
}

