/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.model.views.data.DataSetItemModel;
import org.eclipse.birt.report.designer.internal.ui.dialogs.ExpressionFilter;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.Operator;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.metadata.IArgumentInfo;
import org.eclipse.birt.report.model.api.metadata.IArgumentInfoList;
import org.eclipse.birt.report.model.api.metadata.IClassInfo;
import org.eclipse.birt.report.model.api.metadata.ILocalizableInfo;
import org.eclipse.birt.report.model.api.metadata.IMemberInfo;
import org.eclipse.birt.report.model.api.metadata.IMethodInfo;
import org.eclipse.swt.graphics.Image;

public class ExpressionProvider
implements IExpressionProvider {
    protected static final Operator[] OPERATORS_ASSIGNMENT = new Operator[]{new Operator("=", Messages.getString((String)"ExpressionProvider.Operator.Assign")), new Operator("+=", Messages.getString((String)"ExpressionProvider.Operator.AddTo")), new Operator("-=", Messages.getString((String)"ExpressionProvider.Operator.SubFrom")), new Operator("*=", Messages.getString((String)"ExpressionProvider.Operator.MultTo")), new Operator("/=", Messages.getString((String)"ExpressionProvider.Operator.DividingFrom"))};
    protected static Operator[] OPERATORS_COMPARISON = new Operator[]{new Operator("==", Messages.getString((String)"ExpressionProvider.Operator.Equals")), new Operator("<", Messages.getString((String)"ExpressionProvider.Operator.Less")), new Operator("<=", Messages.getString((String)"ExpressionProvider.Operator.LessEqual")), new Operator("!=", Messages.getString((String)"ExpressionProvider.Operator.NotEqual")), new Operator(">", Messages.getString((String)"ExpressionProvider.Operator.Greater")), new Operator(">=", Messages.getString((String)"ExpressionProvider.Operator.GreaterEquals"))};
    protected static final Operator[] OPERATORS_COMPUTATIONAL = new Operator[]{new Operator("+", Messages.getString((String)"ExpressionProvider.Operator.Add")), new Operator("-", Messages.getString((String)"ExpressionProvider.Operator.Sub")), new Operator("*", Messages.getString((String)"ExpressionProvider.Operator.Mult")), new Operator("/", Messages.getString((String)"ExpressionProvider.Operator.Divides")), new Operator("++ ", Messages.getString((String)"ExpressionProvider.Operator.Inc")), new Operator("-- ", Messages.getString((String)"ExpressionProvider.Operator.Dec"))};
    protected static final Operator[] OPERATORS_LOGICAL = new Operator[]{new Operator("&&", Messages.getString((String)"ExpressionProvider.Operator.And")), new Operator("||", Messages.getString((String)"ExpressionProvider.Operator.Or"))};
    protected static final Operator[] OPERATORS_ON_BAR = new Operator[]{OPERATORS_COMPUTATIONAL[0], OPERATORS_COMPUTATIONAL[1], OPERATORS_COMPUTATIONAL[2], OPERATORS_COMPUTATIONAL[3], OPERATOR_SEPARATOR, new Operator("!", Messages.getString((String)"ExpressionProvider.Operator.Not")), new Operator("=", Messages.getString((String)"ExpressionProvider.Operator.Equals")), OPERATORS_COMPARISON[1], OPERATORS_COMPARISON[4], OPERATOR_SEPARATOR, new Operator("&", Messages.getString((String)"ExpressionProvider.Operator.BitAnd")), new Operator("|", Messages.getString((String)"ExpressionProvider.Operator.BitOr")), new Operator("(", Messages.getString((String)"ExpressionProvider.Operator.LeftBracket")), new Operator(")", Messages.getString((String)"ExpressionProvider.Operator.RightBracket"))};
    protected static final String DISPLAY_TEXT_ASSIGNMENT = Messages.getString((String)"ExpressionProvider.Operators.Assignment");
    protected static final String DISPLAY_TEXT_COMPARISON = Messages.getString((String)"ExpressionProvider.Operators.Comparison");
    protected static final String DISPLAY_TEXT_COMPUTATIONAL = Messages.getString((String)"ExpressionProvider.Operators.Computational");
    protected static final String DISPLAY_TEXT_LOGICAL = Messages.getString((String)"ExpressionProvider.Operators.Logical");
    protected static final Image IMAGE_OPERATOR = ExpressionProvider.getIconImage("Operator");
    protected static final Image IMAGE_COLUMN = ExpressionProvider.getIconImage("DataColumn");
    protected static final Image IMAGE_METHOD = ExpressionProvider.getIconImage("Method");
    protected static final Image IMAGE_STATIC_METHOD = ExpressionProvider.getIconImage("Static Method");
    protected static final Image IMAGE_MEMBER = ExpressionProvider.getIconImage("Member");
    protected static final Image IMAGE_STATIC_MEMBER = ExpressionProvider.getIconImage("Static Member");
    public static final String OPERATORS = Messages.getString((String)"ExpressionProvider.Category.Operators");
    public static final String COLUMN_BINDINGS = Messages.getString((String)"ExpressionProvider.Category.ColumnBinding");
    public static final String PARAMETERS = Messages.getString((String)"ExpressionProvider.Category.Parameters");
    public static final String NATIVE_OBJECTS = Messages.getString((String)"ExpressionProvider.Category.NativeObjects");
    public static final String BIRT_OBJECTS = Messages.getString((String)"ExpressionProvider.Category.BirtObjects");
    protected static final String ALL = Messages.getString((String)"ExpressionProvider.Label.All");
    private static final String TOOLTIP_BINDING_PREFIX = Messages.getString((String)"ExpressionProvider.Tooltip.ColumnBinding");
    protected DesignElementHandle elementHandle;
    private List filterList;
    private boolean includeSelf;

    public ExpressionProvider() {
        this(null);
    }

    public ExpressionProvider(DesignElementHandle handle) {
        this(handle, true);
    }

    public ExpressionProvider(DesignElementHandle handle, boolean includeSelf) {
        this.elementHandle = handle == null ? SessionHandleAdapter.getInstance().getReportDesignHandle() : handle;
        this.includeSelf = includeSelf;
    }

    public Operator[] getOperators() {
        return OPERATORS_ON_BAR;
    }

    public Object[] getCategory() {
        Object[] category = this.getCategoryList().toArray();
        if (this.filterList != null && !this.filterList.isEmpty()) {
            Iterator iter = this.filterList.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof ExpressionFilter)) continue;
                category = ((ExpressionFilter)obj).filter("Category", category);
            }
        }
        return category;
    }

    protected List getCategoryList() {
        ArrayList<String> categoryList = new ArrayList<String>(5);
        if (!DEUtil.getAllColumnBindingList((DesignElementHandle)this.elementHandle).isEmpty()) {
            categoryList.add(COLUMN_BINDINGS);
        }
        if (this.elementHandle.getModuleHandle().getParameters().getCount() != 0) {
            categoryList.add(PARAMETERS);
        }
        categoryList.add(NATIVE_OBJECTS);
        categoryList.add(BIRT_OBJECTS);
        categoryList.add(OPERATORS);
        return categoryList;
    }

    public Object[] getChildren(Object parent) {
        Object[] children = this.getChildrenList(parent).toArray();
        if (this.filterList != null && !this.filterList.isEmpty()) {
            Iterator iter = this.filterList.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof ExpressionFilter)) continue;
                children = ((ExpressionFilter)obj).filter(parent, children);
            }
        }
        return children;
    }

    protected List getChildrenList(Object parent) {
        ArrayList<Object> childrenList = new ArrayList<Object>();
        if (parent instanceof Object[]) {
            Object[] array = (Object[])parent;
            if (array instanceof Operator[]) {
                return Arrays.asList(array);
            }
            for (int i = 0; i < array.length; ++i) {
                Object[] children = this.getChildren(array[i]);
                childrenList.addAll(Arrays.asList(children));
            }
        } else if (parent instanceof String) {
            if (PARAMETERS.equals(parent)) {
                childrenList.add(ALL);
                Iterator iter = this.elementHandle.getModuleHandle().getParameters().iterator();
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    if (!(obj instanceof ParameterGroupHandle)) continue;
                    childrenList.add(obj);
                }
            } else if (ALL.equals(parent)) {
                Iterator iter = this.elementHandle.getModuleHandle().getParameters().iterator();
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    if (!(obj instanceof ParameterHandle)) continue;
                    childrenList.add(obj);
                }
            } else if (COLUMN_BINDINGS.equals(parent)) {
                List bindingList = DEUtil.getAllColumnBindingList((DesignElementHandle)this.elementHandle, (boolean)this.includeSelf);
                Collections.reverse(bindingList);
                Iterator iter = bindingList.iterator();
                while (iter.hasNext()) {
                    ComputedColumnHandle handle = (ComputedColumnHandle)iter.next();
                    if (childrenList.contains(handle.getElementHandle())) continue;
                    childrenList.add(handle.getElementHandle());
                }
            } else if (BIRT_OBJECTS.equals(parent)) {
                childrenList.addAll(this.getClassList(false));
            } else if (NATIVE_OBJECTS.equals(parent)) {
                childrenList.addAll(this.getClassList(true));
            } else if (OPERATORS.equals(parent)) {
                childrenList.add(OPERATORS_ASSIGNMENT);
                childrenList.add(OPERATORS_COMPARISON);
                childrenList.add(OPERATORS_COMPUTATIONAL);
                childrenList.add(OPERATORS_LOGICAL);
                childrenList.add(0, childrenList.toArray());
            }
        } else if (parent instanceof IClassInfo) {
            IClassInfo classInfo = (IClassInfo)parent;
            Iterator iter = DEUtil.getMembers((IClassInfo)classInfo).iterator();
            while (iter.hasNext()) {
                childrenList.add(new ILocalizableInfo[]{classInfo, (IMemberInfo)iter.next()});
            }
            iter = DEUtil.getMethods((IClassInfo)classInfo).iterator();
            while (iter.hasNext()) {
                childrenList.add(new ILocalizableInfo[]{classInfo, (IMethodInfo)iter.next()});
            }
        } else if (parent instanceof ParameterGroupHandle) {
            childrenList.addAll(((ParameterGroupHandle)parent).getParameters().getContents());
        } else if (parent instanceof ReportItemHandle || parent instanceof GroupHandle) {
            Iterator iter = parent instanceof ReportItemHandle ? ((ReportItemHandle)parent).columnBindingsIterator() : ((GroupHandle)parent).columnBindingsIterator();
            while (iter.hasNext()) {
                childrenList.add(iter.next());
            }
            childrenList.add(new Object[]{Messages.getString((String)"ExpressionProvider.EditBindings"), parent});
        }
        return childrenList;
    }

    public String getDisplayText(Object element) {
        if (element instanceof Object[]) {
            Object[] inputArray;
            if (element instanceof Operator[]) {
                if (element == OPERATORS_ASSIGNMENT) {
                    return DISPLAY_TEXT_ASSIGNMENT;
                }
                if (element == OPERATORS_COMPARISON) {
                    return DISPLAY_TEXT_COMPARISON;
                }
                if (element == OPERATORS_COMPUTATIONAL) {
                    return DISPLAY_TEXT_COMPUTATIONAL;
                }
                if (element == OPERATORS_LOGICAL) {
                    return DISPLAY_TEXT_LOGICAL;
                }
            } else if (element instanceof ILocalizableInfo[]) {
                ILocalizableInfo info = ((ILocalizableInfo[])element)[1];
                StringBuffer displayText = new StringBuffer(info.getName());
                if (info instanceof IMethodInfo) {
                    IMethodInfo method = (IMethodInfo)info;
                    displayText.append("(");
                    boolean isFirst = true;
                    Iterator argumentListIter = method.argumentListIterator();
                    IArgumentInfoList arguments = (IArgumentInfoList)argumentListIter.next();
                    Iterator iter = arguments.argumentsIterator();
                    while (iter.hasNext()) {
                        IArgumentInfo argInfo = (IArgumentInfo)iter.next();
                        if (!isFirst) {
                            displayText.append(", ");
                        }
                        isFirst = false;
                        displayText.append(argInfo.getDisplayName());
                    }
                    displayText.append(")");
                    if (!argumentListIter.hasNext()) {
                        displayText.append(" : ");
                        String returnType = method.getReturnType();
                        if (returnType == null) {
                            returnType = "void";
                        }
                        displayText.append(returnType);
                    }
                } else if (info instanceof IMemberInfo) {
                    displayText.append(" : ");
                    displayText.append(((IMemberInfo)info).getDataType());
                }
                return displayText.toString();
            }
            if ((inputArray = (Object[])element).length == 2 && inputArray[1] instanceof ReportItemHandle) {
                return inputArray[0].toString();
            }
            return ALL;
        }
        if (element instanceof String) {
            return (String)element;
        }
        if (element instanceof Operator) {
            return ((Operator)element).symbol;
        }
        if (element instanceof DesignElementHandle) {
            return DEUtil.getDisplayLabel((Object)element, (boolean)false);
        }
        if (element instanceof ComputedColumnHandle) {
            return ((ComputedColumnHandle)element).getName();
        }
        return element.toString();
    }

    public String getTooltipText(Object element) {
        if (element instanceof Operator) {
            return ((Operator)element).tooltip;
        }
        if (element instanceof ILocalizableInfo[]) {
            return ((ILocalizableInfo[])element)[1].getToolTip();
        }
        if (element instanceof ComputedColumnHandle) {
            return TOOLTIP_BINDING_PREFIX + ((ComputedColumnHandle)element).getExpression();
        }
        return this.getDisplayText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof Operator) {
            return IMAGE_OPERATOR;
        }
        if (element instanceof ILocalizableInfo[]) {
            ILocalizableInfo info = ((ILocalizableInfo[])element)[1];
            if (info instanceof IMethodInfo) {
                if (((IMethodInfo)info).isStatic()) {
                    return IMAGE_STATIC_METHOD;
                }
                return IMAGE_METHOD;
            }
            if (info instanceof IMemberInfo) {
                if (((IMemberInfo)info).isStatic()) {
                    return IMAGE_STATIC_MEMBER;
                }
                return IMAGE_MEMBER;
            }
        } else {
            if (element instanceof ComputedColumnHandle || element instanceof ResultSetColumnHandle || element instanceof DataSetItemModel) {
                return IMAGE_COLUMN;
            }
            if (element instanceof DesignElementHandle) {
                return ReportPlatformUIImages.getImage(element);
            }
        }
        return null;
    }

    public String getInsertText(Object element) {
        if (element instanceof Operator) {
            return ((Operator)element).insertString;
        }
        if (element instanceof ILocalizableInfo[]) {
            IClassInfo classInfo = (IClassInfo)((ILocalizableInfo[])element)[0];
            ILocalizableInfo info = ((ILocalizableInfo[])element)[1];
            StringBuffer insertText = new StringBuffer();
            if (info instanceof IMemberInfo) {
                IMemberInfo memberInfo = (IMemberInfo)info;
                if (memberInfo.isStatic()) {
                    insertText.append(classInfo.getName() + ".");
                }
                insertText.append(memberInfo.getName());
            } else if (info instanceof IMethodInfo) {
                IMethodInfo methodInfo = (IMethodInfo)info;
                if (methodInfo.isStatic()) {
                    insertText.append(classInfo.getName() + ".");
                }
                insertText.append(methodInfo.getName());
                insertText.append("()");
            }
            return insertText.toString();
        }
        if (element instanceof ParameterHandle) {
            return DEUtil.getExpression((Object)element);
        }
        if (element instanceof ComputedColumnHandle) {
            return DEUtil.getBindingexpression((DesignElementHandle)this.elementHandle, (ComputedColumnHandle)((ComputedColumnHandle)element));
        }
        return null;
    }

    private static Image getIconImage(String id) {
        return ReportPlatformUIImages.getImage(id);
    }

    protected List getClassList(boolean isNative) {
        List list = DEUtil.getClasses();
        ArrayList<IClassInfo> resultList = new ArrayList<IClassInfo>();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            IClassInfo classInfo = (IClassInfo)iter.next();
            if (classInfo.isNative() != isNative) continue;
            resultList.add(classInfo);
        }
        return resultList;
    }

    public void addFilter(ExpressionFilter filter) {
        if (this.filterList == null) {
            this.filterList = new ArrayList();
        }
        if (!this.filterList.contains(filter)) {
            this.filterList.add(filter);
        }
    }

    public void addFilterList(List list) {
        if (list == null) {
            return;
        }
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof ExpressionFilter)) continue;
            this.addFilter((ExpressionFilter)obj);
        }
    }

    public void removeFilter(ExpressionFilter filter) {
        if (this.filterList == null) {
            return;
        }
        this.filterList.remove(filter);
    }

    public void clearFilters() {
        if (this.filterList == null) {
            return;
        }
        this.filterList.clear();
    }
}

