/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BackgroundPreferencePage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BlockPreferencePage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BorderPreferencePage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BoxPreferencePage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FontPreferencePage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FormatDateTimePreferencePage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FormatNumberPreferencePage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FormatStringPreferencePage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.GeneralPreferencePage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.HighlightsPreferencePage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.MapPreferencePage;
import org.eclipse.birt.report.designer.internal.ui.dialogs.PageBreakPreferencePage;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;

public class StyleBuilder
extends PreferenceDialog {
    public static final String DLG_TITLE_NEW = Messages.getString((String)"SytleBuilder.DialogTitle.New");
    public static final String DLG_TITLE_EDIT = Messages.getString((String)"SytleBuilder.DialogTitle.Edit");
    protected String title;

    public StyleBuilder(Shell parentShell, ReportElementHandle handle, String title) {
        super(parentShell, StyleBuilder.createPreferenceManager(handle));
        this.title = title;
    }

    public int open() {
        this.setSelectedNode("General");
        return super.open();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    private static PreferenceManager createPreferenceManager(ReportElementHandle handle) {
        PreferenceManager preferenceManager = new PreferenceManager('/');
        ArrayList<PreferenceNode> pageContributions = new ArrayList<PreferenceNode>();
        pageContributions.add(new PreferenceNode("General", (IPreferencePage)new GeneralPreferencePage(handle)));
        pageContributions.add(new PreferenceNode("Font", (IPreferencePage)new FontPreferencePage(handle)));
        pageContributions.add(new PreferenceNode("Background", (IPreferencePage)new BackgroundPreferencePage(handle)));
        pageContributions.add(new PreferenceNode("Block", (IPreferencePage)new BlockPreferencePage(handle)));
        pageContributions.add(new PreferenceNode("Box", (IPreferencePage)new BoxPreferencePage(handle)));
        pageContributions.add(new PreferenceNode("Border", (IPreferencePage)new BorderPreferencePage(handle)));
        pageContributions.add(new PreferenceNode("Number Format", (IPreferencePage)new FormatNumberPreferencePage(handle)));
        pageContributions.add(new PreferenceNode("DateTime Format", (IPreferencePage)new FormatDateTimePreferencePage(handle)));
        pageContributions.add(new PreferenceNode("String Format", (IPreferencePage)new FormatStringPreferencePage(handle)));
        pageContributions.add(new PreferenceNode("PageBreak", (IPreferencePage)new PageBreakPreferencePage(handle)));
        pageContributions.add(new PreferenceNode("Map", (IPreferencePage)new MapPreferencePage(handle)));
        pageContributions.add(new PreferenceNode("Highlights", (IPreferencePage)new HighlightsPreferencePage(handle)));
        Iterator it = pageContributions.iterator();
        while (it.hasNext()) {
            preferenceManager.addToRoot((IPreferenceNode)it.next());
        }
        return preferenceManager;
    }

    private void saveAll(final boolean closeDialog) {
        Platform.run((ISafeRunnable)new SafeRunnable(){
            private boolean errorOccurred;
            private boolean invalid;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                block11: {
                    block9: {
                        block10: {
                            this.errorOccurred = false;
                            this.invalid = false;
                            try {
                                try {
                                    Iterator nodes = StyleBuilder.this.getPreferenceManager().getElements(0).iterator();
                                    while (nodes.hasNext()) {
                                        IPreferenceNode node = (IPreferenceNode)nodes.next();
                                        IPreferencePage page = node.getPage();
                                        if (page == null || page.performOk()) continue;
                                        this.invalid = true;
                                        Object var5_5 = null;
                                        if (this.errorOccurred) break block9;
                                        break block10;
                                    }
                                    break block11;
                                }
                                catch (Exception e) {
                                    this.handleException(e);
                                    Object var5_7 = null;
                                    if (!this.errorOccurred) {
                                        StyleBuilder.this.handleSave();
                                    }
                                    if (this.invalid) return;
                                    if (!closeDialog) return;
                                    StyleBuilder.this.close();
                                    return;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var5_8 = null;
                                if (!this.errorOccurred) {
                                    StyleBuilder.this.handleSave();
                                }
                                if (this.invalid) throw throwable;
                                if (!closeDialog) throw throwable;
                                StyleBuilder.this.close();
                                throw throwable;
                            }
                        }
                        StyleBuilder.this.handleSave();
                    }
                    if (this.invalid) return;
                    if (!closeDialog) return;
                    StyleBuilder.this.close();
                    return;
                }
                Object var5_6 = null;
                if (!this.errorOccurred) {
                    StyleBuilder.this.handleSave();
                }
                if (this.invalid) return;
                if (!closeDialog) return;
                StyleBuilder.this.close();
            }

            public void handleException(Throwable e) {
                this.errorOccurred = true;
                if (Platform.isRunning()) {
                    String bundle = "org.eclipse.core.runtime";
                    Platform.getLog((Bundle)Platform.getBundle((String)bundle)).log((IStatus)new Status(4, bundle, 0, e.toString(), e));
                } else {
                    e.printStackTrace();
                }
                StyleBuilder.this.setSelectedNodePreference(null);
                String message = JFaceResources.getString((String)"SafeRunnable.errorMessage");
                MessageDialog.openError((Shell)StyleBuilder.this.getShell(), (String)JFaceResources.getString((String)"Error"), (String)message);
            }
        });
    }

    protected void okPressed() {
        this.saveAll(true);
    }
}

